function initializeCoreMod() {
	Java.type('net.minecraftforge.coremod.api.ASMAPI').loadFile(
			'coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'net/minecraft/fluid/FluidState',
		'methodName' : resolveName('func_206891_b'), // randomTick
		'methodDesc' : '(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Ljava/util/Random;)V'
	}

	var handler = {
		'class' : 'com/endertech/minecraft/forge/events/RandomTickEvent',
		'methodName' : 'onRandomTickFluid',
		'methodDesc' : '(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/fluid/FluidState;)Z'
	}

	var instructions = [
	    insnLoadObj(1, "world"),
	    insnLoadObj(2, "pos"),
	    insnLoadObj(0, "state"),
	    insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsBeforeAll(method, instructions.concat(instructionsIfTrueReturn()));
				return method;
			}
		}
	}
}