/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class WarpingRecipe
implements IRecipe<IInventory> {
    public static final Serializer SERIALIZER = new Serializer();
    public static RecipeType TYPE = new RecipeType();
    private final Ingredient input;
    private final ItemStack output;
    private final ResourceLocation dimension;
    private final ResourceLocation id;

    public WarpingRecipe(ResourceLocation id, Ingredient input, ItemStack output, ResourceLocation dimension) {
        this.input = input;
        this.output = output;
        this.dimension = dimension;
        this.id = id;
    }

    public ResourceLocation getDimension() {
        return this.dimension;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return this.input.test(inv.func_70301_a(0)) && this.dimension.compareTo(worldIn.func_234923_W_().func_240901_a_()) == 0;
    }

    public boolean func_192399_d() {
        return true;
    }

    public ItemStack func_77572_b(IInventory inv) {
        return this.func_77571_b().func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return false;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public IRecipeType<?> func_222127_g() {
        return TYPE;
    }

    public static class RecipeType
    implements IRecipeType<WarpingRecipe> {
        public String toString() {
            return "architects_palette".concat(":warping");
        }

        public <C extends IInventory> Optional<WarpingRecipe> find(C inv, World world) {
            return world.func_199532_z().func_215371_a((IRecipeType)TYPE, inv, world);
        }
    }

    private static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<WarpingRecipe> {
        Serializer() {
            this.setRegistryName(new ResourceLocation("architects_palette", "warping"));
        }

        public WarpingRecipe read(ResourceLocation recipeId, JsonObject json) {
            JsonArray inputElement = JSONUtils.func_151202_d((JsonObject)json, (String)"ingredient") ? JSONUtils.func_151214_t((JsonObject)json, (String)"ingredient") : JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient");
            Ingredient input = Ingredient.func_199802_a((JsonElement)inputElement);
            ItemStack output = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            ResourceLocation dimensionId = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"dimension"));
            return new WarpingRecipe(recipeId, input, output, dimensionId);
        }

        @Nullable
        public WarpingRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            Ingredient input = Ingredient.func_199566_b((PacketBuffer)buffer);
            ItemStack output = buffer.func_150791_c();
            ResourceLocation dimensionId = buffer.func_192575_l();
            return new WarpingRecipe(recipeId, input, output, dimensionId);
        }

        public void write(PacketBuffer buffer, WarpingRecipe recipe) {
            recipe.input.func_199564_a(buffer);
            buffer.func_150788_a(recipe.output);
            buffer.func_192572_a(recipe.dimension);
        }
    }
}

