/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.common.blocks;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;

public class PipeBlock
extends RotatedPillarBlock
implements IWaterLoggable {
    public static final EnumProperty<PipeBlockPart> PART = EnumProperty.func_177709_a((String)"part", PipeBlockPart.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final VoxelShape Y_AXIS_SHAPE = PipeBlock.cutout(Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0));
    protected static final VoxelShape Z_AXIS_SHAPE = PipeBlock.cutout(Block.func_208617_a((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)16.0));
    protected static final VoxelShape X_AXIS_SHAPE = PipeBlock.cutout(Block.func_208617_a((double)0.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0));

    public PipeBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_176298_M, (Comparable)Direction.Axis.Y)).func_206870_a(PART, (Comparable)((Object)PipeBlockPart.MIDDLE))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_176298_M, PART, WATERLOGGED});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction.Axis)state.func_177229_b((Property)field_176298_M)) {
            default: {
                return X_AXIS_SHAPE;
            }
            case Z: {
                return Z_AXIS_SHAPE;
            }
            case Y: 
        }
        return Y_AXIS_SHAPE;
    }

    public VoxelShape func_199600_g(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return VoxelShapes.func_197868_b();
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return (BlockState)state.func_206870_a(PART, (Comparable)((Object)this.checkNearbyPipes(state, worldIn, currentPos)));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        boolean flag = fluidstate.func_206886_c() == Fluids.field_204546_a;
        BlockState b = super.func_196258_a(context);
        return (BlockState)((BlockState)b.func_206870_a(PART, (Comparable)((Object)this.checkNearbyPipes(b, (IWorld)context.func_195991_k(), context.func_195995_a())))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public PipeBlockPart checkNearbyPipes(BlockState state, IWorld world, BlockPos pos) {
        Direction.Axis facing = (Direction.Axis)state.func_177229_b((Property)field_176298_M);
        BlockPos forward = pos.func_241872_a(facing, 1);
        BlockPos reverse = pos.func_241872_a(facing, -1);
        boolean ffound = this.pipeMatches(state, world.func_180495_p(forward));
        boolean rfound = this.pipeMatches(state, world.func_180495_p(reverse));
        if (facing == Direction.Axis.Z) {
            boolean e = ffound;
            ffound = rfound;
            rfound = e;
        }
        if (ffound && rfound) {
            return PipeBlockPart.MIDDLE;
        }
        if (ffound) {
            return PipeBlockPart.BOTTOM;
        }
        return PipeBlockPart.TOP;
    }

    private boolean pipeMatches(BlockState base, BlockState checking) {
        return checking.func_177230_c() instanceof PipeBlock && checking.func_177229_b((Property)field_176298_M) == base.func_177229_b((Property)field_176298_M);
    }

    private static VoxelShape cutout(VoxelShape ... cutouts) {
        VoxelShape shape = VoxelShapes.func_197868_b();
        for (VoxelShape cutout : cutouts) {
            shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)cutout, (IBooleanFunction)IBooleanFunction.field_223234_e_);
        }
        return shape.func_197753_c();
    }

    public static enum PipeBlockPart implements IStringSerializable
    {
        TOP,
        MIDDLE,
        BOTTOM;


        public String toString() {
            return this.func_176610_l();
        }

        public String func_176610_l() {
            switch (this) {
                case TOP: {
                    return "top";
                }
                case BOTTOM: {
                    return "bottom";
                }
            }
            return "middle";
        }
    }
}

