/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import com.github.alexthe666.alexsmobs.entity.EntityCrow;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import net.minecraft.block.BlockState;
import net.minecraft.block.CropsBlock;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;

public class CrowAICircleCrops
extends MoveToBlockGoal {
    private EntityCrow crow;
    private int idleAtFlowerTime = 0;
    private boolean isAboveDestinationBear;
    float circlingTime = 0.0f;
    float circleDistance = 2.0f;
    float maxCirclingTime = 80.0f;
    float yLevel = 2.0f;
    boolean clockwise = false;
    boolean circlePhase = false;

    public CrowAICircleCrops(EntityCrow bird) {
        super((CreatureEntity)bird, 1.0, 32, 8);
        this.crow = bird;
    }

    public void func_75249_e() {
        super.func_75249_e();
        this.circlePhase = true;
        this.clockwise = this.crow.func_70681_au().nextBoolean();
        this.yLevel = 1 + this.crow.func_70681_au().nextInt(3);
        this.circleDistance = 1 + this.crow.func_70681_au().nextInt(3);
    }

    public boolean func_75250_a() {
        return !this.crow.func_70631_g_() && (this.crow.func_70638_az() == null || !this.crow.func_70638_az().func_70089_S()) && !this.crow.func_70909_n() && this.crow.fleePumpkinFlag == 0 && !this.crow.aiItemFlag && super.func_75250_a();
    }

    public boolean func_75253_b() {
        return this.field_179494_b != null && (this.crow.func_70638_az() == null || !this.crow.func_70638_az().func_70089_S()) && !this.crow.func_70909_n() && !this.crow.aiItemFlag && this.crow.fleePumpkinFlag == 0 && super.func_75253_b();
    }

    public void func_75251_c() {
        this.idleAtFlowerTime = 0;
        this.circlingTime = 0.0f;
        this.field_179493_e = 0;
        this.field_179494_b = null;
    }

    public double func_203110_f() {
        return 1.0;
    }

    public void func_75246_d() {
        BlockPos blockpos = this.func_241846_j();
        if (this.circlePhase) {
            this.field_179493_e = 0;
            BlockPos circlePos = this.getVultureCirclePos(blockpos);
            if (circlePos != null) {
                this.crow.setFlying(true);
                this.crow.func_70605_aq().func_75642_a((double)circlePos.func_177958_n() + 0.5, (double)circlePos.func_177956_o() + 0.5, (double)circlePos.func_177952_p() + 0.5, (double)0.7f);
            }
            this.circlingTime += 1.0f;
            if (this.circlingTime > 200.0f) {
                this.circlingTime = 0.0f;
                this.circlePhase = false;
            }
        } else {
            super.func_75246_d();
            if (this.crow.func_233570_aj_()) {
                this.crow.setFlying(false);
            }
            if (!this.isWithinXZDist(blockpos, this.field_179495_c.func_213303_ch(), this.func_203110_f())) {
                this.isAboveDestinationBear = false;
                ++this.field_179493_e;
                this.field_179495_c.func_70661_as().func_75492_a((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() - 0.5, (double)blockpos.func_177952_p() + 0.5, 1.0);
            } else {
                this.isAboveDestinationBear = true;
                --this.field_179493_e;
            }
            if (this.func_179487_f()) {
                this.crow.func_200602_a(EntityAnchorArgument.Type.EYES, new Vector3d((double)this.field_179494_b.func_177958_n() + 0.5, (double)this.field_179494_b.func_177956_o(), (double)this.field_179494_b.func_177952_p() + 0.5));
                if (this.idleAtFlowerTime >= 5) {
                    this.pollinate();
                    this.func_75251_c();
                } else {
                    this.crow.peck();
                    ++this.idleAtFlowerTime;
                }
            }
        }
    }

    public BlockPos getVultureCirclePos(BlockPos target) {
        float angle = 0.13962634f * (this.clockwise ? -this.circlingTime : this.circlingTime);
        double extraX = this.circleDistance * MathHelper.func_76126_a((float)angle);
        double extraZ = this.circleDistance * MathHelper.func_76134_b((float)angle);
        BlockPos pos = new BlockPos((double)((float)target.func_177958_n() + 0.5f) + extraX, (double)((float)(target.func_177956_o() + 1) + this.yLevel), (double)((float)target.func_177952_p() + 0.5f) + extraZ);
        if (this.crow.field_70170_p.func_175623_d(pos)) {
            return pos;
        }
        return null;
    }

    private boolean isWithinXZDist(BlockPos blockpos, Vector3d positionVec, double distance) {
        return blockpos.func_218140_a(positionVec.func_82615_a(), positionVec.func_82617_b(), positionVec.func_82616_c(), true) < distance * distance;
    }

    protected boolean func_179487_f() {
        return this.isAboveDestinationBear;
    }

    private void pollinate() {
        if (this.crow.field_70170_p.func_180495_p(this.field_179494_b).func_177230_c() instanceof CropsBlock) {
            CropsBlock block = (CropsBlock)this.crow.field_70170_p.func_180495_p(this.field_179494_b).func_177230_c();
            int cropAge = (Integer)this.crow.field_70170_p.func_180495_p(this.field_179494_b).func_177229_b((Property)block.func_185524_e());
            if (cropAge > 0) {
                this.crow.field_70170_p.func_175656_a(this.field_179494_b, (BlockState)this.crow.field_70170_p.func_180495_p(this.field_179494_b).func_206870_a((Property)block.func_185524_e(), (Comparable)Integer.valueOf(cropAge - 1)));
            } else {
                this.crow.field_70170_p.func_175655_b(this.field_179494_b, true);
            }
            this.func_75251_c();
        } else {
            this.crow.field_70170_p.func_175655_b(this.field_179494_b, true);
            this.func_75251_c();
        }
        this.field_179493_e = 1200;
    }

    protected boolean func_179488_a(IWorldReader worldIn, BlockPos pos) {
        return BlockTags.func_199896_a().func_199910_a(AMTagRegistry.CROW_FOODBLOCKS).func_230235_a_((Object)worldIn.func_180495_p(pos).func_177230_c());
    }
}

