/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.client.particle.AMParticleRegistry;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.effect.AMEffectRegistry;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.ICustomCollisions;
import com.github.alexthe666.alexsmobs.entity.ITargetsDroppedItems;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIPanicBaby;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIWanderRanged;
import com.github.alexthe666.alexsmobs.entity.ai.CreatureAITargetItems;
import com.github.alexthe666.alexsmobs.entity.ai.GroundPathNavigatorWide;
import com.github.alexthe666.alexsmobs.entity.ai.MovementControllerCustomCollisions;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.ResetAngerGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.ReuseableStream;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TickRangeConverter;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EntityTiger
extends AnimalEntity
implements ICustomCollisions,
IAnimatedEntity,
IAngerable,
ITargetsDroppedItems {
    public static final Animation ANIMATION_PAW_R = Animation.create((int)15);
    public static final Animation ANIMATION_PAW_L = Animation.create((int)15);
    public static final Animation ANIMATION_TAIL_FLICK = Animation.create((int)45);
    public static final Animation ANIMATION_LEAP = Animation.create((int)20);
    private static final DataParameter<Boolean> WHITE = EntityDataManager.func_187226_a(EntityTiger.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> RUNNING = EntityDataManager.func_187226_a(EntityTiger.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SITTING = EntityDataManager.func_187226_a(EntityTiger.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SLEEPING = EntityDataManager.func_187226_a(EntityTiger.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> STEALTH_MODE = EntityDataManager.func_187226_a(EntityTiger.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> HOLDING = EntityDataManager.func_187226_a(EntityTiger.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> ANGER_TIME = EntityDataManager.func_187226_a(EntityTiger.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> LAST_SCARED_MOB_ID = EntityDataManager.func_187226_a(EntityTiger.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final RangedInteger ANGRY_TIMER = TickRangeConverter.func_233037_a_((int)40, (int)80);
    private static final Predicate<LivingEntity> NO_BLESSING_EFFECT = mob -> !mob.func_70644_a(AMEffectRegistry.TIGERS_BLESSING);
    public float prevSitProgress;
    public float sitProgress;
    public float prevSleepProgress;
    public float sleepProgress;
    public float prevHoldProgress;
    public float holdProgress;
    public float prevStealthProgress;
    public float stealthProgress;
    private int animationTick;
    private Animation currentAnimation;
    private boolean hasSpedUp = false;
    private UUID lastHurtBy;
    private int sittingTime;
    private int maxSitTime;
    private int holdTime = 0;
    private int prevScaredMobId = -1;
    private boolean dontSitFlag = false;

    protected EntityTiger(EntityType type, World worldIn) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.func_184644_a(PathNodeType.WATER_BORDER, 0.0f);
        this.field_70765_h = new MovementControllerCustomCollisions((MobEntity)this);
    }

    public static boolean canTigerSpawn(EntityType<? extends AnimalEntity> animal, IWorld worldIn, SpawnReason reason, BlockPos pos, Random random) {
        return worldIn.func_226659_b_(pos, 0) > 8;
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 50.0).func_233815_a_(Attributes.field_233823_f_, 12.0).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233819_b_, 86.0);
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.tigerSpawnRolls, this.func_70681_au(), spawnReasonIn);
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        return worldIn.func_204610_c(pos.func_177977_b()).func_206888_e() && worldIn.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a) ? 0.0f : super.func_205022_a(pos, worldIn);
    }

    public boolean func_205019_a(IWorldReader worldIn) {
        return !worldIn.func_72953_d(this.func_174813_aQ());
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("TigerSitting", this.isSitting());
        compound.func_74757_a("TigerSleeping", this.func_70608_bn());
        compound.func_74757_a("White", this.isWhite());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setSitting(compound.func_74767_n("TigerSitting"));
        this.setSleeping(compound.func_74767_n("TigerSleeping"));
        this.setWhite(compound.func_74767_n("White"));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(WHITE, (Object)false);
        this.field_70180_af.func_187214_a(RUNNING, (Object)false);
        this.field_70180_af.func_187214_a(SITTING, (Object)false);
        this.field_70180_af.func_187214_a(STEALTH_MODE, (Object)false);
        this.field_70180_af.func_187214_a(HOLDING, (Object)false);
        this.field_70180_af.func_187214_a(SLEEPING, (Object)false);
        this.field_70180_af.func_187214_a(ANGER_TIME, (Object)0);
        this.field_70180_af.func_187214_a(LAST_SCARED_MOB_ID, (Object)-1);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new AnimalAIPanicBaby(this, 1.25));
        this.field_70714_bg.func_75776_a(3, (Goal)new AIMelee());
        this.field_70714_bg.func_75776_a(5, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(7, (Goal)new AnimalAIWanderRanged((CreatureEntity)this, 60, 1.0, 14, 7));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 25.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, new CreatureAITargetItems((CreatureEntity)this, false, 10));
        this.field_70715_bh.func_75776_a(2, (Goal)new AngerGoal(this));
        this.field_70715_bh.func_75776_a(3, (Goal)new AttackPlayerGoal());
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LivingEntity.class, 10, false, false, AMEntityRegistry.buildPredicateFromTag(EntityTypeTags.func_219762_a().func_199910_a(AMTagRegistry.TIGER_TARGETS))){

            public boolean func_75250_a() {
                return !EntityTiger.this.func_70631_g_() && super.func_75250_a();
            }
        });
        this.field_70715_bh.func_75776_a(5, (Goal)new ResetAngerGoal((MobEntity)this, true));
    }

    protected SoundEvent func_184639_G() {
        return this.isStealth() ? super.func_184639_G() : (this.func_230256_F__() > 0 ? AMSoundRegistry.TIGER_ANGRY : AMSoundRegistry.TIGER_IDLE);
    }

    public int func_70627_aG() {
        return this.func_230256_F__() > 0 ? 40 : 80;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return AMSoundRegistry.TIGER_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSoundRegistry.TIGER_HURT;
    }

    protected float func_189749_co() {
        return 0.99f;
    }

    public boolean shouldMove() {
        return !this.isSitting() && !this.func_70608_bn() && !this.isHolding();
    }

    public double func_213340_A(@Nullable Entity lookingEntity) {
        if (this.isStealth()) {
            return 0.2;
        }
        return super.func_213340_A(lookingEntity);
    }

    public boolean func_70877_b(ItemStack stack) {
        return ItemTags.func_199903_a().func_199910_a(AMTagRegistry.TIGER_BREEDABLES).func_230235_a_((Object)stack.func_77973_b());
    }

    public void func_241847_a(ServerWorld world, LivingEntity entity) {
        this.func_70691_i(5.0f);
        super.func_241847_a(world, entity);
    }

    public void func_213352_e(Vector3d vec3d) {
        if (!this.shouldMove()) {
            if (this.func_70661_as().func_75505_d() != null) {
                this.func_70661_as().func_75499_g();
            }
            vec3d = Vector3d.field_186680_a;
        }
        super.func_213352_e(vec3d);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new Navigator((MobEntity)this, worldIn);
    }

    public boolean isWhite() {
        return (Boolean)this.field_70180_af.func_187225_a(WHITE);
    }

    public void setWhite(boolean white) {
        this.field_70180_af.func_187227_b(WHITE, (Object)white);
    }

    public boolean isRunning() {
        return (Boolean)this.field_70180_af.func_187225_a(RUNNING);
    }

    public void setRunning(boolean running) {
        this.field_70180_af.func_187227_b(RUNNING, (Object)running);
    }

    public boolean isSitting() {
        return (Boolean)this.field_70180_af.func_187225_a(SITTING);
    }

    public void setSitting(boolean bar) {
        this.field_70180_af.func_187227_b(SITTING, (Object)bar);
    }

    public boolean isStealth() {
        return (Boolean)this.field_70180_af.func_187225_a(STEALTH_MODE);
    }

    public void setStealth(boolean bar) {
        this.field_70180_af.func_187227_b(STEALTH_MODE, (Object)bar);
    }

    public boolean isHolding() {
        return (Boolean)this.field_70180_af.func_187225_a(HOLDING);
    }

    public void setHolding(boolean running) {
        this.field_70180_af.func_187227_b(HOLDING, (Object)running);
    }

    public boolean func_70608_bn() {
        return (Boolean)this.field_70180_af.func_187225_a(SLEEPING);
    }

    public void setSleeping(boolean sleeping) {
        this.field_70180_af.func_187227_b(SLEEPING, (Object)sleeping);
    }

    public int func_230256_F__() {
        return (Integer)this.field_70180_af.func_187225_a(ANGER_TIME);
    }

    public void func_230260_a__(int time) {
        this.field_70180_af.func_187227_b(ANGER_TIME, (Object)time);
    }

    public UUID func_230257_G__() {
        return this.lastHurtBy;
    }

    public void func_230259_a_(@Nullable UUID target) {
        this.lastHurtBy = target;
    }

    public void func_230258_H__() {
        this.func_230260_a__(ANGRY_TIMER.func_233018_a_(this.field_70146_Z));
    }

    protected void func_70619_bc() {
        if (!this.field_70170_p.field_72995_K) {
            this.func_241359_a_((ServerWorld)this.field_70170_p, false);
        }
    }

    public void func_70071_h_() {
        Entity e;
        super.func_70071_h_();
        this.prevSitProgress = this.sitProgress;
        this.prevSleepProgress = this.sleepProgress;
        this.prevHoldProgress = this.holdProgress;
        this.prevStealthProgress = this.stealthProgress;
        if (this.isSitting() && this.sitProgress < 5.0f) {
            this.sitProgress += 1.0f;
        }
        if (!this.isSitting() && this.sitProgress > 0.0f) {
            this.sitProgress -= 1.0f;
        }
        if (this.func_70608_bn() && this.sleepProgress < 5.0f) {
            this.sleepProgress += 1.0f;
        }
        if (!this.func_70608_bn() && this.sleepProgress > 0.0f) {
            this.sleepProgress -= 1.0f;
        }
        if (this.isHolding() && this.holdProgress < 5.0f) {
            this.holdProgress += 1.0f;
        }
        if (!this.isHolding() && this.holdProgress > 0.0f) {
            this.holdProgress -= 1.0f;
        }
        if (this.isStealth() && this.stealthProgress < 10.0f) {
            this.stealthProgress += 0.25f;
        }
        if (!this.isStealth() && this.stealthProgress > 0.0f) {
            this.stealthProgress -= 1.0f;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.isRunning() && !this.hasSpedUp) {
                this.hasSpedUp = true;
                this.field_70138_W = 1.0f;
                this.func_70031_b(true);
                this.func_110148_a(Attributes.field_233821_d_).func_111128_a((double)0.4f);
            }
            if (!this.isRunning() && this.hasSpedUp) {
                this.hasSpedUp = false;
                this.field_70138_W = 0.6f;
                this.func_70031_b(false);
                this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.25);
            }
            if ((this.isSitting() || this.func_70608_bn()) && (++this.sittingTime > this.maxSitTime || this.func_70638_az() != null || this.func_70880_s() || this.dontSitFlag || this.func_203005_aq())) {
                this.setSitting(false);
                this.setSleeping(false);
                this.sittingTime = 0;
                this.maxSitTime = 100 + this.field_70146_Z.nextInt(50);
            }
            if (!(this.func_70638_az() != null || this.dontSitFlag || !(this.func_213322_ci().func_189985_c() < 0.03) || this.getAnimation() != NO_ANIMATION || this.func_70608_bn() || this.isSitting() || this.func_203005_aq() || this.field_70146_Z.nextInt(100) != 0)) {
                this.sittingTime = 0;
                if (this.func_70681_au().nextBoolean()) {
                    this.maxSitTime = 100 + this.field_70146_Z.nextInt(550);
                    this.setSitting(true);
                    this.setSleeping(false);
                } else {
                    this.maxSitTime = 200 + this.field_70146_Z.nextInt(550);
                    this.setSitting(false);
                    this.setSleeping(true);
                }
            }
            if (this.func_213322_ci().func_189985_c() < 0.03 && this.getAnimation() == NO_ANIMATION && !this.func_70608_bn() && !this.isSitting() && this.field_70146_Z.nextInt(100) == 0) {
                this.setAnimation(ANIMATION_TAIL_FLICK);
            }
        }
        if (this.isHolding()) {
            this.func_70031_b(false);
            this.setRunning(false);
            if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null && this.func_70638_az().func_70089_S()) {
                this.field_70125_A = 0.0f;
                float radius = 1.0f + this.func_70638_az().func_213311_cf() * 0.5f;
                float angle = (float)Math.PI / 180 * this.field_70761_aq;
                double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
                double extraZ = radius * MathHelper.func_76134_b((float)angle);
                double extraY = -0.5;
                Vector3d minus = new Vector3d(this.func_226277_ct_() + extraX - this.func_70638_az().func_226277_ct_(), this.func_226278_cu_() + extraY - this.func_70638_az().func_226278_cu_(), this.func_226281_cx_() + extraZ - this.func_70638_az().func_226281_cx_());
                this.func_70638_az().func_213317_d(minus);
                if (this.holdTime % 20 == 0) {
                    this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)(5 + this.func_70681_au().nextInt(2)));
                }
            }
            ++this.holdTime;
            if (this.holdTime > 100) {
                this.holdTime = 0;
                this.setHolding(false);
            }
        } else {
            this.holdTime = 0;
        }
        if (this.prevScaredMobId != (Integer)this.field_70180_af.func_187225_a(LAST_SCARED_MOB_ID) && this.field_70170_p.field_72995_K && (e = this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(LAST_SCARED_MOB_ID)).intValue())) != null) {
            double d2 = this.field_70146_Z.nextGaussian() * 0.1;
            double d0 = this.field_70146_Z.nextGaussian() * 0.1;
            double d1 = this.field_70146_Z.nextGaussian() * 0.1;
            this.field_70170_p.func_195594_a((IParticleData)AMParticleRegistry.SHOCKED, e.func_226277_ct_(), e.func_226280_cw_() + (double)(e.func_213302_cg() * 0.15f) + (double)(this.field_70146_Z.nextFloat() * e.func_213302_cg() * 0.15f), e.func_226281_cx_(), d0, d1, d2);
        }
        if (this.func_70638_az() != null && this.func_70638_az().func_70644_a(AMEffectRegistry.TIGERS_BLESSING)) {
            this.func_70624_b(null);
            this.func_70604_c(null);
        }
        this.prevScaredMobId = (Integer)this.field_70180_af.func_187225_a(LAST_SCARED_MOB_ID);
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        boolean prev = super.func_70097_a(source, amount);
        if (prev) {
            LivingEntity hurter;
            if (source.func_76346_g() != null && source.func_76346_g() instanceof LivingEntity && (hurter = (LivingEntity)source.func_76346_g()).func_70644_a(AMEffectRegistry.TIGERS_BLESSING)) {
                hurter.func_195063_d(AMEffectRegistry.TIGERS_BLESSING);
            }
            return prev;
        }
        return prev;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public BlockPos getLightPosition() {
        BlockPos pos = new BlockPos(this.func_213303_ch());
        if (!this.field_70170_p.func_180495_p(pos).func_200132_m()) {
            return pos.func_177984_a();
        }
        return pos;
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        boolean whiteOther = p_241840_2_ instanceof EntityTiger && ((EntityTiger)p_241840_2_).isWhite();
        EntityTiger baby = (EntityTiger)AMEntityRegistry.TIGER.func_200721_a((World)p_241840_1_);
        double whiteChance = 0.1;
        if (this.isWhite() && whiteOther) {
            whiteChance = 0.8;
        }
        if (this.isWhite() != whiteOther) {
            whiteChance = 0.4;
        }
        baby.setWhite(this.field_70146_Z.nextDouble() < whiteChance);
        return baby;
    }

    public Vector3d func_213306_e(Vector3d vec) {
        boolean flag3;
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        ISelectionContext iselectioncontext = ISelectionContext.func_216374_a((Entity)this);
        VoxelShape voxelshape = this.field_70170_p.func_175723_af().func_222521_a();
        Stream<Object> stream = VoxelShapes.func_197879_c((VoxelShape)voxelshape, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)axisalignedbb.func_186664_h(1.0E-7)), (IBooleanFunction)IBooleanFunction.field_223238_i_) ? Stream.empty() : Stream.of(voxelshape);
        Stream stream1 = this.field_70170_p.func_230318_c_((Entity)this, axisalignedbb.func_216361_a(vec), p_233561_0_ -> true);
        ReuseableStream reuseablestream = new ReuseableStream(Stream.concat(stream1, stream));
        Vector3d vector3d = vec.func_189985_c() == 0.0 ? vec : this.collideBoundingBoxHeuristicallyPassable((Entity)this, vec, axisalignedbb, this.field_70170_p, iselectioncontext, reuseablestream);
        boolean flag = vec.field_72450_a != vector3d.field_72450_a;
        boolean flag1 = vec.field_72448_b != vector3d.field_72448_b;
        boolean flag2 = vec.field_72449_c != vector3d.field_72449_c;
        boolean bl = flag3 = this.field_70122_E || flag1 && vec.field_72448_b < 0.0;
        if (this.field_70138_W > 0.0f && flag3 && (flag || flag2)) {
            Vector3d vector3d3;
            Vector3d vector3d1 = this.collideBoundingBoxHeuristicallyPassable((Entity)this, new Vector3d(vec.field_72450_a, (double)this.field_70138_W, vec.field_72449_c), axisalignedbb, this.field_70170_p, iselectioncontext, reuseablestream);
            Vector3d vector3d2 = this.collideBoundingBoxHeuristicallyPassable((Entity)this, new Vector3d(0.0, (double)this.field_70138_W, 0.0), axisalignedbb.func_72321_a(vec.field_72450_a, 0.0, vec.field_72449_c), this.field_70170_p, iselectioncontext, reuseablestream);
            if (vector3d2.field_72448_b < (double)this.field_70138_W && EntityTiger.func_213296_b((Vector3d)(vector3d3 = this.collideBoundingBoxHeuristicallyPassable((Entity)this, new Vector3d(vec.field_72450_a, 0.0, vec.field_72449_c), axisalignedbb.func_191194_a(vector3d2), this.field_70170_p, iselectioncontext, reuseablestream).func_178787_e(vector3d2))) > EntityTiger.func_213296_b((Vector3d)vector3d1)) {
                vector3d1 = vector3d3;
            }
            if (EntityTiger.func_213296_b((Vector3d)vector3d1) > EntityTiger.func_213296_b((Vector3d)vector3d)) {
                return vector3d1.func_178787_e(this.collideBoundingBoxHeuristicallyPassable((Entity)this, new Vector3d(0.0, -vector3d1.field_72448_b + vec.field_72448_b, 0.0), axisalignedbb.func_191194_a(vector3d1), this.field_70170_p, iselectioncontext, reuseablestream));
            }
        }
        return vector3d;
    }

    @Override
    public boolean canPassThrough(BlockPos mutablePos, BlockState blockstate, VoxelShape voxelshape) {
        return blockstate.func_177230_c() == Blocks.field_222405_kQ || blockstate.func_235714_a_((ITag)BlockTags.field_206952_E);
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_PAW_R, ANIMATION_PAW_L, ANIMATION_LEAP, ANIMATION_TAIL_FLICK};
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public void func_70108_f(Entity entityIn) {
        if (!this.isHolding() || entityIn != this.func_70638_az()) {
            super.func_70108_f(entityIn);
        }
    }

    protected void func_82167_n(Entity entityIn) {
        if (!this.isHolding() || entityIn != this.func_70638_az()) {
            super.func_82167_n(entityIn);
        }
    }

    @Override
    public boolean canTargetItem(ItemStack stack) {
        return stack.func_77973_b().func_219971_r() && stack.func_77973_b().func_219967_s() != null && stack.func_77973_b().func_219967_s().func_221467_c() && stack.func_77973_b() != Items.field_151078_bh;
    }

    @Override
    public double getMaxDistToItem() {
        return 3.0;
    }

    @Override
    public void onGetItem(ItemEntity e) {
        this.dontSitFlag = false;
        ItemStack stack = e.func_92059_d();
        if (stack.func_77973_b().func_219971_r() && stack.func_77973_b().func_219967_s() != null && stack.func_77973_b().func_219967_s().func_221467_c() && stack.func_77973_b() != Items.field_151078_bh) {
            this.func_184185_a(SoundEvents.field_219607_aG, this.func_70647_i(), this.func_70599_aP());
            this.func_70691_i(5.0f);
            if (e.func_200214_m() != null && (double)this.field_70146_Z.nextFloat() < this.getChanceForEffect(stack) && this.field_70170_p.func_217371_b(e.func_200214_m()) != null) {
                PlayerEntity player = this.field_70170_p.func_217371_b(e.func_200214_m());
                player.func_195064_c(new EffectInstance(AMEffectRegistry.TIGERS_BLESSING, 12000));
                this.func_70624_b(null);
                this.func_70604_c(null);
            }
        }
    }

    @Override
    public void onFindTarget(ItemEntity e) {
        this.dontSitFlag = true;
        this.setSitting(false);
        this.setSleeping(false);
    }

    public double getChanceForEffect(ItemStack stack) {
        if (stack.func_77973_b() == Items.field_151147_al || stack.func_77973_b() == Items.field_151157_am) {
            return 0.4f;
        }
        if (stack.func_77973_b() == Items.field_151076_bf || stack.func_77973_b() == Items.field_151077_bg) {
            return 0.3f;
        }
        return 0.1f;
    }

    protected void func_70664_aZ() {
        if (!this.func_70608_bn() && !this.isSitting()) {
            super.func_70664_aZ();
        }
    }

    class AngerGoal
    extends HurtByTargetGoal {
        AngerGoal(EntityTiger beeIn) {
            super((CreatureEntity)beeIn, new Class[0]);
        }

        public boolean func_75253_b() {
            return EntityTiger.this.func_233678_J__() && super.func_75253_b();
        }

        public void func_75249_e() {
            super.func_75249_e();
            if (EntityTiger.this.func_70631_g_()) {
                this.func_190105_f();
                this.func_75251_c();
            }
        }

        protected void func_220793_a(MobEntity mobIn, LivingEntity targetIn) {
            if (!mobIn.func_70631_g_()) {
                super.func_220793_a(mobIn, targetIn);
            }
        }
    }

    class AttackPlayerGoal
    extends NearestAttackableTargetGoal<PlayerEntity> {
        public AttackPlayerGoal() {
            super((MobEntity)EntityTiger.this, PlayerEntity.class, 100, false, true, NO_BLESSING_EFFECT);
        }

        public boolean func_75250_a() {
            if (EntityTiger.this.func_70631_g_()) {
                return false;
            }
            return super.func_75250_a();
        }

        protected double func_111175_f() {
            return 4.0;
        }
    }

    private class AIMelee
    extends Goal {
        private EntityTiger tiger;
        private int jumpAttemptCooldown = 0;

        public AIMelee() {
            this.tiger = EntityTiger.this;
        }

        public boolean func_75250_a() {
            return this.tiger.func_70638_az() != null && this.tiger.func_70638_az().func_70089_S();
        }

        public void func_75246_d() {
            LivingEntity target;
            if (this.jumpAttemptCooldown > 0) {
                --this.jumpAttemptCooldown;
            }
            if ((target = this.tiger.func_70638_az()) != null && target.func_70089_S()) {
                double dist = this.tiger.func_70032_d((Entity)target);
                if (this.tiger.func_70643_av() != null && this.tiger.func_70643_av().func_70089_S() && dist < 10.0) {
                    this.tiger.setStealth(false);
                } else if (dist > 20.0) {
                    this.tiger.setRunning(false);
                    this.tiger.setStealth(true);
                }
                if (dist <= 20.0) {
                    this.tiger.setStealth(false);
                    this.tiger.setRunning(true);
                    if (((Integer)this.tiger.field_70180_af.func_187225_a(LAST_SCARED_MOB_ID)).intValue() != target.func_145782_y()) {
                        this.tiger.field_70180_af.func_187227_b(LAST_SCARED_MOB_ID, (Object)target.func_145782_y());
                        target.func_195064_c(new EffectInstance(AMEffectRegistry.FEAR, 100, 0, true, false));
                    }
                }
                if (dist < 12.0 && this.tiger.getAnimation() == IAnimatedEntity.NO_ANIMATION && this.tiger.func_233570_aj_() && this.jumpAttemptCooldown == 0 && !this.tiger.isHolding()) {
                    this.tiger.setAnimation(ANIMATION_LEAP);
                    this.jumpAttemptCooldown = 70;
                }
                if ((this.jumpAttemptCooldown > 0 || this.tiger.func_203005_aq()) && !this.tiger.isHolding() && this.tiger.getAnimation() == IAnimatedEntity.NO_ANIMATION && dist < (double)(4.0f + target.func_213311_cf())) {
                    this.tiger.setAnimation(this.tiger.func_70681_au().nextBoolean() ? ANIMATION_PAW_L : ANIMATION_PAW_R);
                }
                if (dist < (double)(4.0f + target.func_213311_cf()) && (this.tiger.getAnimation() == ANIMATION_PAW_L || this.tiger.getAnimation() == ANIMATION_PAW_R) && this.tiger.getAnimationTick() == 8) {
                    target.func_70097_a(DamageSource.func_76358_a((LivingEntity)this.tiger), (float)(7 + this.tiger.func_70681_au().nextInt(5)));
                }
                if (this.tiger.getAnimation() == ANIMATION_LEAP) {
                    this.tiger.func_70661_as().func_75499_g();
                    Vector3d vec = target.func_213303_ch().func_178788_d(this.tiger.func_213303_ch());
                    this.tiger.field_70761_aq = this.tiger.field_70177_z = -((float)MathHelper.func_181159_b((double)vec.field_72450_a, (double)vec.field_72449_c)) * 57.295776f;
                    if (this.tiger.getAnimationTick() == 5 && this.tiger.field_70122_E) {
                        Vector3d vector3d1 = new Vector3d(target.func_226277_ct_() - this.tiger.func_226277_ct_(), 0.0, target.func_226281_cx_() - this.tiger.func_226281_cx_());
                        if (vector3d1.func_189985_c() > 1.0E-7) {
                            vector3d1 = vector3d1.func_72432_b().func_186678_a(Math.min(dist, 15.0) * (double)0.2f);
                        }
                        this.tiger.func_213293_j(vector3d1.field_72450_a, vector3d1.field_72448_b + (double)0.3f + (double)0.1f * MathHelper.func_151237_a((double)(target.func_226280_cw_() - this.tiger.func_226278_cu_()), (double)0.0, (double)2.0), vector3d1.field_72449_c);
                    }
                    if (dist < (double)(target.func_213311_cf() + 3.0f) && this.tiger.getAnimationTick() >= 15) {
                        target.func_70097_a(DamageSource.func_76358_a((LivingEntity)this.tiger), 2.0f);
                        this.tiger.setRunning(false);
                        this.tiger.setStealth(false);
                        this.tiger.setHolding(true);
                    }
                } else if (this.tiger.isHolding()) {
                    this.tiger.func_70661_as().func_75499_g();
                } else {
                    try {
                        this.tiger.func_70661_as().func_75497_a((Entity)target, this.tiger.isStealth() ? 0.75 : 1.0);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        public void func_75251_c() {
            this.tiger.setStealth(false);
            this.tiger.setRunning(false);
            this.tiger.setHolding(false);
        }
    }

    class Navigator
    extends GroundPathNavigatorWide {
        public Navigator(MobEntity mob, World world) {
            super(mob, world, 1.2f);
        }

        protected PathFinder func_179679_a(int i) {
            this.field_179695_a = new NodeProcessor();
            return new PathFinder(this.field_179695_a, i);
        }

        protected boolean func_75493_a(Vector3d posVec31, Vector3d posVec32, int sizeX, int sizeY, int sizeZ) {
            int i = MathHelper.func_76128_c((double)posVec31.field_72450_a);
            int j = MathHelper.func_76128_c((double)posVec31.field_72449_c);
            double d0 = posVec32.field_72450_a - posVec31.field_72450_a;
            double d1 = posVec32.field_72449_c - posVec31.field_72449_c;
            double d2 = d0 * d0 + d1 * d1;
            if (d2 < 1.0E-8) {
                return false;
            }
            double d3 = 1.0 / Math.sqrt(d2);
            if (!this.isSafeToStandAt(i, MathHelper.func_76128_c((double)posVec31.field_72448_b), j, sizeX += 2, sizeY, sizeZ += 2, posVec31, d0 *= d3, d1 *= d3)) {
                return false;
            }
            sizeX -= 2;
            sizeZ -= 2;
            double d4 = 1.0 / Math.abs(d0);
            double d5 = 1.0 / Math.abs(d1);
            double d6 = (double)i - posVec31.field_72450_a;
            double d7 = (double)j - posVec31.field_72449_c;
            if (d0 >= 0.0) {
                d6 += 1.0;
            }
            if (d1 >= 0.0) {
                d7 += 1.0;
            }
            d6 /= d0;
            d7 /= d1;
            int k = d0 < 0.0 ? -1 : 1;
            int l = d1 < 0.0 ? -1 : 1;
            int i1 = MathHelper.func_76128_c((double)posVec32.field_72450_a);
            int j1 = MathHelper.func_76128_c((double)posVec32.field_72449_c);
            int k1 = i1 - i;
            int l1 = j1 - j;
            while (k1 * k > 0 || l1 * l > 0) {
                if (d6 < d7) {
                    d6 += d4;
                    k1 = i1 - (i += k);
                } else {
                    d7 += d5;
                    l1 = j1 - (j += l);
                }
                if (this.isSafeToStandAt(i, MathHelper.func_76128_c((double)posVec31.field_72448_b), j, sizeX, sizeY, sizeZ, posVec31, d0, d1)) continue;
                return false;
            }
            return true;
        }

        private boolean isPositionClear(int x, int y, int z, int sizeX, int sizeY, int sizeZ, Vector3d p_179692_7_, double p_179692_8_, double p_179692_10_) {
            for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)new BlockPos(x, y, z), (BlockPos)new BlockPos(x + sizeX - 1, y + sizeY - 1, z + sizeZ - 1))) {
                double d1;
                double d0 = (double)blockpos.func_177958_n() + 0.5 - p_179692_7_.field_72450_a;
                if ((d0 * p_179692_8_ + (d1 = (double)blockpos.func_177952_p() + 0.5 - p_179692_7_.field_72449_c) * p_179692_10_ < 0.0 || this.field_75513_b.func_180495_p(blockpos).func_196957_g((IBlockReader)this.field_75513_b, blockpos, PathType.LAND)) && !EntityTiger.this.canPassThrough(blockpos, this.field_75513_b.func_180495_p(blockpos), null)) continue;
                return false;
            }
            return true;
        }

        private boolean isSafeToStandAt(int x, int y, int z, int sizeX, int sizeY, int sizeZ, Vector3d vec31, double p_179683_8_, double p_179683_10_) {
            int i = x - sizeX / 2;
            int j = z - sizeZ / 2;
            if (!this.isPositionClear(i, y, j, sizeX, sizeY, sizeZ, vec31, p_179683_8_, p_179683_10_)) {
                return false;
            }
            BlockPos.Mutable mutable = new BlockPos.Mutable();
            for (int k = i; k < i + sizeX; ++k) {
                for (int l = j; l < j + sizeZ; ++l) {
                    double d0 = (double)k + 0.5 - vec31.field_72450_a;
                    double d1 = (double)l + 0.5 - vec31.field_72449_c;
                    if (d0 * p_179683_8_ + d1 * p_179683_10_ < 0.0) continue;
                    PathNodeType pathnodetype = this.field_179695_a.func_186319_a((IBlockReader)this.field_75513_b, k, y - 1, l, this.field_75515_a, sizeX, sizeY, sizeZ, true, true);
                    mutable.func_181079_c(k, y - 1, l);
                    if (!this.func_230287_a_(pathnodetype) || EntityTiger.this.canPassThrough((BlockPos)mutable, this.field_75513_b.func_180495_p((BlockPos)mutable), null)) {
                        return false;
                    }
                    pathnodetype = this.field_179695_a.func_186319_a((IBlockReader)this.field_75513_b, k, y, l, this.field_75515_a, sizeX, sizeY, sizeZ, true, true);
                    float f = this.field_75515_a.func_184643_a(pathnodetype);
                    if (f < 0.0f || f >= 8.0f) {
                        return false;
                    }
                    if (pathnodetype != PathNodeType.DAMAGE_FIRE && pathnodetype != PathNodeType.DANGER_FIRE && pathnodetype != PathNodeType.DAMAGE_OTHER) continue;
                    return false;
                }
            }
            return true;
        }

        protected boolean func_230287_a_(PathNodeType p_230287_1_) {
            if (p_230287_1_ == PathNodeType.WATER) {
                return false;
            }
            if (p_230287_1_ == PathNodeType.LAVA) {
                return false;
            }
            return p_230287_1_ != PathNodeType.OPEN;
        }
    }

    static class NodeProcessor
    extends WalkNodeProcessor {
        private NodeProcessor() {
        }

        public static PathNodeType func_237231_a_(IBlockReader p_237231_0_, BlockPos.Mutable p_237231_1_) {
            int i = p_237231_1_.func_177958_n();
            int j = p_237231_1_.func_177956_o();
            int k = p_237231_1_.func_177952_p();
            PathNodeType pathnodetype = NodeProcessor.getNodes(p_237231_0_, (BlockPos)p_237231_1_);
            if (pathnodetype == PathNodeType.OPEN && j >= 1) {
                PathNodeType pathnodetype1 = NodeProcessor.getNodes(p_237231_0_, (BlockPos)p_237231_1_.func_181079_c(i, j - 1, k));
                PathNodeType pathNodeType = pathnodetype = pathnodetype1 != PathNodeType.WALKABLE && pathnodetype1 != PathNodeType.OPEN && pathnodetype1 != PathNodeType.WATER && pathnodetype1 != PathNodeType.LAVA ? PathNodeType.WALKABLE : PathNodeType.OPEN;
                if (pathnodetype1 == PathNodeType.DAMAGE_FIRE) {
                    pathnodetype = PathNodeType.DAMAGE_FIRE;
                }
                if (pathnodetype1 == PathNodeType.DAMAGE_CACTUS) {
                    pathnodetype = PathNodeType.DAMAGE_CACTUS;
                }
                if (pathnodetype1 == PathNodeType.DAMAGE_OTHER) {
                    pathnodetype = PathNodeType.DAMAGE_OTHER;
                }
                if (pathnodetype1 == PathNodeType.STICKY_HONEY) {
                    pathnodetype = PathNodeType.STICKY_HONEY;
                }
            }
            if (pathnodetype == PathNodeType.WALKABLE) {
                pathnodetype = NodeProcessor.func_237232_a_((IBlockReader)p_237231_0_, (BlockPos.Mutable)p_237231_1_.func_181079_c(i, j, k), (PathNodeType)pathnodetype);
            }
            return pathnodetype;
        }

        protected static PathNodeType getNodes(IBlockReader p_237238_0_, BlockPos p_237238_1_) {
            BlockState blockstate = p_237238_0_.func_180495_p(p_237238_1_);
            PathNodeType type = blockstate.getAiPathNodeType(p_237238_0_, p_237238_1_);
            if (type != null) {
                return type;
            }
            Block block = blockstate.func_177230_c();
            Material material = blockstate.func_185904_a();
            if (blockstate.isAir(p_237238_0_, p_237238_1_)) {
                return PathNodeType.OPEN;
            }
            if (blockstate.func_177230_c() == Blocks.field_222405_kQ) {
                return PathNodeType.OPEN;
            }
            return NodeProcessor.func_237238_b_((IBlockReader)p_237238_0_, (BlockPos)p_237238_1_);
        }

        public PathNodeType func_186330_a(IBlockReader blockaccessIn, int x, int y, int z) {
            return NodeProcessor.func_237231_a_(blockaccessIn, new BlockPos.Mutable(x, y, z));
        }

        protected PathNodeType func_215744_a(IBlockReader world, boolean b1, boolean b2, BlockPos pos, PathNodeType nodeType) {
            return nodeType == PathNodeType.LEAVES || world.func_180495_p(pos).func_177230_c() == Blocks.field_222405_kQ ? PathNodeType.OPEN : super.func_215744_a(world, b1, b2, pos, nodeType);
        }
    }
}

