/*
 * Decompiled with CFR 0.152.
 */
package curiousarmorstands;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Tuple;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.type.ISlotType;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.api.type.util.ISlotHelper;
import top.theillusivec4.curios.common.inventory.CurioStacksHandler;

public class CurioInventoryCapability {
    public static ICapabilityProvider createProvider(LivingEntity entity) {
        return new Provider(entity);
    }

    public static class Provider
    implements ICapabilitySerializable<INBT> {
        final LazyOptional<ICuriosItemHandler> optional;
        final ICuriosItemHandler instance;

        Provider(LivingEntity entity) {
            this.instance = new CurioInventoryWrapper(entity);
            this.optional = LazyOptional.of(() -> this.instance);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
            return CuriosCapability.INVENTORY.orEmpty(capability, this.optional);
        }

        public INBT serializeNBT() {
            return CuriosCapability.INVENTORY.writeNBT((Object)this.instance, null);
        }

        public void deserializeNBT(INBT nbt) {
            CuriosCapability.INVENTORY.readNBT((Object)this.instance, null, nbt);
        }
    }

    public static class CurioInventoryWrapper
    implements ICuriosItemHandler {
        Map<String, ICurioStacksHandler> curios = new LinkedHashMap<String, ICurioStacksHandler>();
        NonNullList<ItemStack> invalidStacks = NonNullList.func_191196_a();
        LivingEntity wearer;
        Set<ICurioStacksHandler> updates = new HashSet<ICurioStacksHandler>();

        CurioInventoryWrapper(LivingEntity entity) {
            this.wearer = entity;
            this.reset();
        }

        public void reset() {
            ISlotHelper slotHelper = CuriosApi.getSlotHelper();
            if (slotHelper != null && this.wearer != null && !this.wearer.func_130014_f_().func_201670_d()) {
                this.curios.clear();
                this.invalidStacks.clear();
                TreeSet sorted = new TreeSet(slotHelper.getSlotTypes(this.wearer));
                for (ISlotType slotType : sorted) {
                    this.curios.put(slotType.getIdentifier(), (ICurioStacksHandler)new CurioStacksHandler((ICuriosItemHandler)this, slotType.getIdentifier(), slotType.getSize(), 0, slotType.isVisible(), slotType.hasCosmetic()));
                }
            }
        }

        public int getSlots() {
            int totalSlots = 0;
            for (ICurioStacksHandler stacks : this.curios.values()) {
                totalSlots += stacks.getSlots();
            }
            return totalSlots;
        }

        public int getVisibleSlots() {
            int totalSlots = 0;
            for (ICurioStacksHandler stacks : this.curios.values()) {
                if (!stacks.isVisible()) continue;
                totalSlots += stacks.getSlots();
            }
            return totalSlots;
        }

        public Set<String> getLockedSlots() {
            return Collections.emptySet();
        }

        public Optional<ICurioStacksHandler> getStacksHandler(String identifier) {
            return Optional.ofNullable(this.curios.get(identifier));
        }

        public Map<String, ICurioStacksHandler> getCurios() {
            return Collections.unmodifiableMap(this.curios);
        }

        public void setCurios(Map<String, ICurioStacksHandler> curios) {
            this.curios = curios;
        }

        public void unlockSlotType(String identifier, int amount, boolean visible, boolean cosmetic) {
        }

        public void lockSlotType(String identifier) {
        }

        public void processSlots() {
        }

        public void growSlotType(String identifier, int amount) {
            if (amount > 0) {
                this.getStacksHandler(identifier).ifPresent(stackHandler -> stackHandler.grow(amount));
            }
        }

        public void shrinkSlotType(String identifier, int amount) {
            if (amount > 0) {
                this.getStacksHandler(identifier).ifPresent(stackHandler -> stackHandler.shrink(amount));
            }
        }

        public LivingEntity getWearer() {
            return this.wearer;
        }

        public void loseInvalidStack(ItemStack stack) {
            this.invalidStacks.add((Object)stack);
        }

        public void handleInvalidStacks() {
            if (this.wearer != null && !this.invalidStacks.isEmpty()) {
                this.invalidStacks.forEach(drop -> this.dropStack(this.wearer, (ItemStack)drop));
                this.invalidStacks = NonNullList.func_191196_a();
            }
        }

        private void dropStack(LivingEntity entity, ItemStack stack) {
            if (!entity.field_70170_p.field_72995_K) {
                ItemEntity itemEntity = new ItemEntity(entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_() + 0.5, entity.func_226281_cx_(), stack);
                entity.field_70170_p.func_217376_c((Entity)itemEntity);
            }
        }

        public Set<ICurioStacksHandler> getUpdatingInventories() {
            return this.updates;
        }

        public ListNBT saveInventory(boolean clear) {
            return new ListNBT();
        }

        public void loadInventory(ListNBT data) {
        }

        public void addTransientSlotModifiers(Multimap<String, AttributeModifier> modifiers) {
            for (Map.Entry entry : modifiers.asMap().entrySet()) {
                String id = (String)entry.getKey();
                for (AttributeModifier attributeModifier : (Collection)entry.getValue()) {
                    ICurioStacksHandler stacksHandler = this.curios.get(id);
                    if (stacksHandler == null) continue;
                    stacksHandler.addTransientModifier(attributeModifier);
                }
            }
        }

        public void addPermanentSlotModifiers(Multimap<String, AttributeModifier> modifiers) {
            for (Map.Entry entry : modifiers.asMap().entrySet()) {
                String id = (String)entry.getKey();
                for (AttributeModifier attributeModifier : (Collection)entry.getValue()) {
                    ICurioStacksHandler stacksHandler = this.curios.get(id);
                    if (stacksHandler == null) continue;
                    stacksHandler.addPermanentModifier(attributeModifier);
                }
            }
        }

        public void removeSlotModifiers(Multimap<String, AttributeModifier> modifiers) {
            for (Map.Entry entry : modifiers.asMap().entrySet()) {
                String id = (String)entry.getKey();
                for (AttributeModifier attributeModifier : (Collection)entry.getValue()) {
                    ICurioStacksHandler stacksHandler = this.curios.get(id);
                    if (stacksHandler == null) continue;
                    stacksHandler.removeModifier(attributeModifier.func_111167_a());
                }
            }
        }

        public void clearSlotModifiers() {
            for (Map.Entry<String, ICurioStacksHandler> entry : this.curios.entrySet()) {
                entry.getValue().clearModifiers();
            }
        }

        public void clearCachedSlotModifiers() {
            for (Map.Entry<String, ICurioStacksHandler> entry : this.curios.entrySet()) {
                entry.getValue().clearCachedModifiers();
            }
        }

        public Multimap<String, AttributeModifier> getModifiers() {
            HashMultimap result = HashMultimap.create();
            for (Map.Entry<String, ICurioStacksHandler> entry : this.curios.entrySet()) {
                result.putAll((Object)entry.getKey(), entry.getValue().getModifiers().values());
            }
            return result;
        }

        public CompoundNBT writeNBT() {
            CompoundNBT compound = new CompoundNBT();
            ListNBT taglist = new ListNBT();
            this.getCurios().forEach((key, stacksHandler) -> {
                CompoundNBT tag = new CompoundNBT();
                tag.func_218657_a("StacksHandler", (INBT)stacksHandler.serializeNBT());
                tag.func_74778_a("Identifier", key);
                taglist.add((Object)tag);
            });
            compound.func_218657_a("Curios", (INBT)taglist);
            return compound;
        }

        public void readNBT(CompoundNBT compoundNBT) {
            ListNBT tagList = compoundNBT.func_150295_c("Curios", 10);
            ISlotHelper slotHelper = CuriosApi.getSlotHelper();
            if (!tagList.isEmpty() && slotHelper != null) {
                LinkedHashMap<String, ICurioStacksHandler> curios = new LinkedHashMap<String, ICurioStacksHandler>();
                TreeMap<ISlotType, Object> sortedCurios = new TreeMap<ISlotType, Object>();
                TreeSet sorted = new TreeSet(CuriosApi.getSlotHelper().getSlotTypes(this.wearer));
                for (ISlotType slotType2 : sorted) {
                    sortedCurios.put(slotType2, new CurioStacksHandler((ICuriosItemHandler)this, slotType2.getIdentifier(), slotType2.getSize(), 0, slotType2.isVisible(), slotType2.hasCosmetic()));
                }
                for (int i = 0; i < tagList.size(); ++i) {
                    CompoundNBT tag = tagList.func_150305_b(i);
                    String identifier = tag.func_74779_i("Identifier");
                    CurioStacksHandler prevStacksHandler = new CurioStacksHandler((ICuriosItemHandler)this, identifier);
                    prevStacksHandler.deserializeNBT(tag.func_74775_l("StacksHandler"));
                    Optional optionalType = CuriosApi.getSlotHelper().getSlotType(identifier);
                    optionalType.ifPresent(type -> {
                        int index;
                        CurioStacksHandler newStacksHandler = new CurioStacksHandler((ICuriosItemHandler)this, type.getIdentifier(), type.getSize(), prevStacksHandler.getSizeShift(), type.isVisible(), type.hasCosmetic());
                        newStacksHandler.copyModifiers((ICurioStacksHandler)prevStacksHandler);
                        for (index = 0; index < newStacksHandler.getSlots() && index < prevStacksHandler.getSlots(); ++index) {
                            ItemStack prevCosmetic;
                            ItemStack prevStack = prevStacksHandler.getStacks().getStackInSlot(index);
                            if (!prevStack.func_190926_b()) {
                                newStacksHandler.getStacks().setStackInSlot(index, prevStack);
                            }
                            if ((prevCosmetic = prevStacksHandler.getCosmeticStacks().getStackInSlot(index)).func_190926_b()) continue;
                            newStacksHandler.getCosmeticStacks().setStackInSlot(index, prevStacksHandler.getCosmeticStacks().getStackInSlot(index));
                        }
                        while (index < prevStacksHandler.getSlots()) {
                            this.loseInvalidStack(prevStacksHandler.getStacks().getStackInSlot(index));
                            this.loseInvalidStack(prevStacksHandler.getCosmeticStacks().getStackInSlot(index));
                            ++index;
                        }
                        sortedCurios.put((ISlotType)type, newStacksHandler);
                        for (int j = 0; j < newStacksHandler.getRenders().size() && j < prevStacksHandler.getRenders().size(); ++j) {
                            newStacksHandler.getRenders().set(j, prevStacksHandler.getRenders().get(j));
                        }
                    });
                    if (optionalType.isPresent()) continue;
                    IDynamicStackHandler stackHandler = prevStacksHandler.getStacks();
                    IDynamicStackHandler cosmeticStackHandler = prevStacksHandler.getCosmeticStacks();
                    for (int j = 0; j < stackHandler.getSlots(); ++j) {
                        ItemStack cosmeticStack;
                        ItemStack stack = stackHandler.getStackInSlot(j);
                        if (!stack.func_190926_b()) {
                            this.loseInvalidStack(stack);
                        }
                        if ((cosmeticStack = cosmeticStackHandler.getStackInSlot(j)).func_190926_b()) continue;
                        this.loseInvalidStack(cosmeticStack);
                    }
                }
                sortedCurios.forEach((slotType, stacksHandler) -> curios.put(slotType.getIdentifier(), (ICurioStacksHandler)stacksHandler));
                this.setCurios(curios);
            }
        }

        public int getFortuneBonus() {
            return 0;
        }

        public int getLootingBonus() {
            return 0;
        }

        public void setEnchantmentBonuses(Tuple<Integer, Integer> tuple) {
        }
    }
}

