/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.soundfilters.handlers;

import com.tmtravlr.soundfilters.SoundFiltersConfig;
import com.tmtravlr.soundfilters.SoundFiltersMod;
import com.tmtravlr.soundfilters.filters.BaseFilter;
import com.tmtravlr.soundfilters.filters.FilterException;
import com.tmtravlr.soundfilters.filters.FilterLowPass;
import com.tmtravlr.soundfilters.filters.FilterReverb;
import com.tmtravlr.soundfilters.handlers.LiquidLowPassHandler;
import com.tmtravlr.soundfilters.handlers.OcclusionHandler;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ReportedException;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.AL11;

public class FilterHandler {
    private static final Minecraft MC = Minecraft.func_71410_x();
    private static final FilterLowPass FILTER_LOW_PASS = new FilterLowPass();
    private static final FilterReverb FILTER_REVERB = new FilterReverb();
    public static final ConcurrentHashMap<ISound, Integer> SOURCE_IDS = new ConcurrentHashMap();

    public static void initializeReverbFilter() {
        FilterHandler.FILTER_REVERB.density = ((Double)SoundFiltersConfig.REVERB_ADVANCED_DENSITY.get()).floatValue();
        FilterHandler.FILTER_REVERB.diffusion = ((Double)SoundFiltersConfig.REVERB_ADVANCED_DIFFUSION.get()).floatValue();
        FilterHandler.FILTER_REVERB.gain = ((Double)SoundFiltersConfig.REVERB_ADVANCED_GAIN.get()).floatValue();
        FilterHandler.FILTER_REVERB.gainHF = ((Double)SoundFiltersConfig.REVERB_ADVANCED_GAIN_HF.get()).floatValue();
        FilterHandler.FILTER_REVERB.decayTime = ((Double)SoundFiltersConfig.REVERB_ADVANCED_DECAY_TIME_MIN.get()).floatValue();
        FilterHandler.FILTER_REVERB.decayHFRatio = ((Double)SoundFiltersConfig.REVERB_ADVANCED_DECAY_HF_RATIO.get()).floatValue();
        FilterHandler.FILTER_REVERB.reflectionsGain = 0.0f;
        FilterHandler.FILTER_REVERB.reflectionsDelay = 0.0f;
        FilterHandler.FILTER_REVERB.lateReverbGain = 0.0f;
        FilterHandler.FILTER_REVERB.lateReverbDelay = 0.0f;
        FilterHandler.FILTER_REVERB.airAbsorptionGainHF = ((Double)SoundFiltersConfig.REVERB_ADVANCED_AIR_ABSORPTION_GAIN_HF.get()).floatValue();
        FilterHandler.FILTER_REVERB.roomRolloffFactor = 0.0f;
    }

    public static void updateReverbFilter(float decayFactor, float roomFactor, float skyFactor) {
        float reverbPercent = ((Double)SoundFiltersConfig.REVERB_PERCENT.get()).floatValue();
        float minDecayTime = ((Double)SoundFiltersConfig.REVERB_ADVANCED_DECAY_TIME_MIN.get()).floatValue();
        float reflectionGainBase = ((Double)SoundFiltersConfig.REVERB_ADVANCED_REFLECTIONS_GAIN_BASE.get()).floatValue();
        float reflectionGainMultiplier = ((Double)SoundFiltersConfig.REVERB_ADVANCED_REFLECTIONS_GAIN_MULTIPLIER.get()).floatValue();
        float reflectionDelayMultiplier = ((Double)SoundFiltersConfig.REVERB_ADVANCED_REFLECTIONS_DELAY_MULTIPLIER.get()).floatValue();
        float lateReverbGainBase = ((Double)SoundFiltersConfig.REVERB_ADVANCED_LATE_REVERB_GAIN_BASE.get()).floatValue();
        float lateReverbGainMultiplier = ((Double)SoundFiltersConfig.REVERB_ADVANCED_LATE_REVERB_GAIN_MULTIPLIER.get()).floatValue();
        float lateReverbDelayMultiplier = ((Double)SoundFiltersConfig.REVERB_ADVANCED_LATE_REVERB_DELAY_MULTIPLIER.get()).floatValue();
        float decayTime = reverbPercent * 6.0f * decayFactor * roomFactor * skyFactor;
        if (decayTime < minDecayTime) {
            decayTime = minDecayTime;
        }
        FilterHandler.FILTER_REVERB.decayTime = decayTime;
        FilterHandler.FILTER_REVERB.reflectionsGain = reverbPercent * (reflectionGainBase + reflectionGainMultiplier * roomFactor);
        FilterHandler.FILTER_REVERB.reflectionsDelay = reflectionDelayMultiplier * roomFactor;
        FilterHandler.FILTER_REVERB.lateReverbGain = reverbPercent * (lateReverbGainBase + lateReverbGainMultiplier * roomFactor);
        FilterHandler.FILTER_REVERB.lateReverbDelay = lateReverbDelayMultiplier * roomFactor;
    }

    public static void updateSourceFilters(ISound sound) {
        Integer sourceId;
        if (sound != null && (sourceId = SOURCE_IDS.get(sound)) != null) {
            if (FilterHandler.MC.field_71441_e != null) {
                double occlusionAmount = OcclusionHandler.getOcclusion(sound);
                float lowPassGain = LiquidLowPassHandler.getLowPassGain();
                float lowPassGainHF = LiquidLowPassHandler.getLowPassGainHF();
                if (occlusionAmount > 0.05 && sound.func_147656_j() != ISound.AttenuationType.NONE && !sound.func_217861_m()) {
                    lowPassGain = (float)((double)lowPassGain * (1.0 - 1.0 * occlusionAmount));
                    lowPassGainHF = (float)((double)lowPassGainHF * (1.0 - 1.0 * (double)MathHelper.func_76133_a((double)occlusionAmount)));
                }
                if (lowPassGain >= 1.0f && lowPassGainHF >= 1.0f) {
                    FILTER_LOW_PASS.disable();
                } else {
                    FilterHandler.FILTER_LOW_PASS.gain = lowPassGain;
                    FilterHandler.FILTER_LOW_PASS.gainHF = lowPassGainHF;
                    FILTER_LOW_PASS.enable();
                    FILTER_LOW_PASS.loadParameters();
                }
                if (FilterHandler.FILTER_REVERB.reflectionsDelay <= 0.0f && FilterHandler.FILTER_REVERB.lateReverbDelay <= 0.0f) {
                    FILTER_REVERB.disable();
                } else {
                    FILTER_REVERB.enable();
                    if (!sound.func_217861_m() && sound.func_147656_j() != ISound.AttenuationType.NONE) {
                        FilterHandler.FILTER_REVERB.roomRolloffFactor = 2.0f / (Math.max(sound.func_147653_e(), 1.0f) + 2.0f);
                    }
                    FILTER_REVERB.loadParameters();
                }
                try {
                    FilterHandler.loadSourceFilter(sourceId, 131077, FILTER_LOW_PASS);
                    FilterHandler.load3SourceFilters(sourceId, 131078, FILTER_REVERB, null, FILTER_LOW_PASS);
                }
                catch (FilterException e) {
                    e.printStackTrace();
                    SoundFiltersMod.LOGGER.error("Error while updating sound filters", (Throwable)e);
                    CrashReport crashreport = CrashReport.func_85055_a((Throwable)e, (String)"Updating Sound Filters");
                    throw new ReportedException(crashreport);
                }
            }
            try {
                FilterHandler.loadSourceFilter(sourceId, 131077, null);
                FilterHandler.load3SourceFilters(sourceId, 131078, null, null, null);
            }
            catch (FilterException e) {
                SoundFiltersMod.LOGGER.error("Error while removing sound filters", (Throwable)e);
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)e, (String)"Removing Sound Filters");
                throw new ReportedException(crashreport);
            }
            SOURCE_IDS.remove(sound);
        }
    }

    private static void load3SourceFilters(int sourceChannel, int type, BaseFilter filter1, BaseFilter filter2, BaseFilter filter3) throws FilterException {
        AL11.alSource3i((int)sourceChannel, (int)type, (int)FilterHandler.safeSlot(filter1), (int)FilterHandler.safeSlot(filter2), (int)FilterHandler.safeSlot(filter3));
        if (FilterHandler.checkError("load3SourceFilters attempt 1") != 0) {
            int error;
            if (filter1 != null) {
                filter1.isLoaded = false;
                filter1.loadFilter();
            }
            if (filter2 != null) {
                filter2.isLoaded = false;
                filter2.loadFilter();
            }
            if (filter3 != null) {
                filter3.isLoaded = false;
                filter3.loadFilter();
            }
            if ((error = FilterHandler.checkError("load3SourceFilters attempt 2")) != 0) {
                throw new FilterException("Sound Filters - Error while trying to load 3 source filters. Error code is " + FilterHandler.getErrorMessage(error));
            }
        }
    }

    private static void loadSourceFilter(int sourceChannel, int type, BaseFilter filter) throws FilterException {
        AL10.alSourcei((int)sourceChannel, (int)type, (int)FilterHandler.safeSlot(filter));
        if (FilterHandler.checkError("loadSourceFilter attempt 1") != 0) {
            if (filter != null) {
                filter.isLoaded = false;
                filter.loadFilter();
            }
            AL10.alSourcei((int)sourceChannel, (int)type, (int)FilterHandler.safeSlot(filter));
            int error = FilterHandler.checkError("loadSourceFilter attempt 2");
            if (error != 0) {
                throw new FilterException("Sound Filters - Error while trying to load source filter. Error code is " + FilterHandler.getErrorMessage(error));
            }
        }
    }

    private static int safeSlot(BaseFilter filter) {
        return filter != null && filter.isEnabled && filter.slot != -1 ? filter.slot : 0;
    }

    private static int checkError(String location) {
        int error = AL10.alGetError();
        if (error != 0) {
            SoundFiltersMod.LOGGER.error("Caught AL error in '" + location + "'! Error is " + FilterHandler.getErrorMessage(error));
            return error;
        }
        return 0;
    }

    private static String getErrorMessage(int error) {
        switch (error) {
            case 40961: {
                return "AL_INVALID_NAME (" + error + ")";
            }
            case 40962: {
                return "AL_INVALID_ENUM (" + error + ")";
            }
            case 40963: {
                return "AL_INVALID_VALUE (" + error + ")";
            }
            case 40964: {
                return "AL_INVALID_OPERATION (" + error + ")";
            }
            case 40965: {
                return "AL_OUT_OF_MEMORY (" + error + ")";
            }
        }
        return "Unrecognized Error (" + error + ")";
    }
}

