/*
 * Decompiled with CFR 0.152.
 */
package com.branders.spawnermod.networking.packet;

import com.branders.spawnermod.item.SpawnerKeyItem;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.spawner.AbstractSpawner;
import net.minecraftforge.fml.network.NetworkEvent;

public class SyncSpawnerMessage {
    private final BlockPos pos;
    private short delay;
    private short minSpawnDelay;
    private short maxSpawnDelay;
    private short spawnCount;
    private short maxNearbyEntities;
    private short requiredPlayerRange;

    public SyncSpawnerMessage(BlockPos pos, short delay, short spawnCount, short requiredPlayerRange, short maxNearbyEntities, short minSpawnDelay, short maxSpawnDelay) {
        this.pos = pos;
        this.delay = delay;
        this.minSpawnDelay = minSpawnDelay;
        this.maxSpawnDelay = maxSpawnDelay;
        this.spawnCount = spawnCount;
        this.maxNearbyEntities = maxNearbyEntities;
        this.requiredPlayerRange = requiredPlayerRange;
    }

    public static void encode(SyncSpawnerMessage msg, PacketBuffer buf) {
        buf.func_179255_a(msg.pos);
        buf.writeShort((int)msg.delay);
        buf.writeShort((int)msg.maxNearbyEntities);
        buf.writeShort((int)msg.maxSpawnDelay);
        buf.writeShort((int)msg.minSpawnDelay);
        buf.writeShort((int)msg.requiredPlayerRange);
        buf.writeShort((int)msg.spawnCount);
    }

    public static SyncSpawnerMessage decode(PacketBuffer buf) {
        BlockPos pos = new BlockPos((Vector3i)buf.func_179259_c());
        short delay = buf.readShort();
        short maxNearbyEntities = buf.readShort();
        short maxSpawnDelay = buf.readShort();
        short minSpawnDelay = buf.readShort();
        short requiredPlayerRange = buf.readShort();
        short spawnCount = buf.readShort();
        return new SyncSpawnerMessage(pos, delay, spawnCount, requiredPlayerRange, maxNearbyEntities, minSpawnDelay, maxSpawnDelay);
    }

    public static void handle(SyncSpawnerMessage msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            World world = ((NetworkEvent.Context)ctx.get()).getSender().field_70170_p;
            if (world != null) {
                MobSpawnerTileEntity spawner = (MobSpawnerTileEntity)world.func_175625_s(msg.pos);
                AbstractSpawner logic = spawner.func_145881_a();
                BlockState blockstate = world.func_180495_p(msg.pos);
                CompoundNBT nbt = new CompoundNBT();
                nbt = logic.func_189530_b(nbt);
                if (msg.requiredPlayerRange == 0) {
                    nbt.func_74777_a("SpawnRange", nbt.func_74765_d("RequiredPlayerRange"));
                } else {
                    nbt.func_74777_a("SpawnRange", (short)4);
                }
                nbt.func_74777_a("Delay", msg.delay);
                nbt.func_74777_a("SpawnCount", msg.spawnCount);
                nbt.func_74777_a("RequiredPlayerRange", msg.requiredPlayerRange);
                nbt.func_74777_a("MaxNearbyEntities", msg.maxNearbyEntities);
                nbt.func_74777_a("MinSpawnDelay", msg.minSpawnDelay);
                nbt.func_74777_a("MaxSpawnDelay", msg.maxSpawnDelay);
                logic.func_98270_a(nbt);
                spawner.func_70296_d();
                world.func_184138_a(msg.pos, blockstate, blockstate, 3);
                ItemStack stack = ((NetworkEvent.Context)ctx.get()).getSender().func_184614_ca();
                if (stack.func_77973_b() instanceof SpawnerKeyItem) {
                    stack.func_222118_a(1, (LivingEntity)((NetworkEvent.Context)ctx.get()).getSender(), arg_0 -> SyncSpawnerMessage.lambda$null$0((Supplier)ctx, arg_0));
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$null$0(Supplier ctx, LivingEntity player) {
        player.func_213334_d(((NetworkEvent.Context)ctx.get()).getSender().func_184600_cs());
    }
}

