/*
 * Decompiled with CFR 0.152.
 */
package com.branders.spawnermod;

import com.branders.spawnermod.config.ConfigValues;
import com.branders.spawnermod.config.ModConfigManager;
import com.branders.spawnermod.event.SpawnerEventHandler;
import com.branders.spawnermod.item.SpawnerKeyItem;
import com.branders.spawnermod.networking.SpawnerModPacketHandler;
import com.branders.spawnermod.networking.packet.SyncSpawnerConfig;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.Rarity;
import net.minecraft.item.SpawnEggItem;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
@Mod(value="spawnermod")
public class SpawnerMod {
    public static final String MODID = "spawnermod";
    public static final Logger LOGGER = LogManager.getLogger((String)"spawnermod");
    public static Item iron_golem_spawn_egg = new SpawnEggItem(EntityType.field_200757_aw, 0xE7E7E7, 9794134, new Item.Properties().func_200916_a(ItemGroup.field_78026_f));

    public SpawnerMod() {
        SpawnerModPacketHandler.register();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onClientStarting);
        MinecraftForge.EVENT_BUS.register((Object)new SpawnerEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onClientStarting(FMLClientSetupEvent event) {
        ModConfigManager.initConfig(MODID, Minecraft.func_71410_x().field_71412_D.getAbsoluteFile());
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerAboutToStartEvent event) {
        ModConfigManager.initConfig(MODID, event.getServer().func_71238_n().getAbsoluteFile());
    }

    @SubscribeEvent
    public void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
        SpawnerModPacketHandler.INSTANCE.sendTo((Object)new SyncSpawnerConfig(ConfigValues.get("disable_spawner_config"), ConfigValues.get("disable_count"), ConfigValues.get("disable_speed"), ConfigValues.get("disable_range")), player.field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        SpawnerMod.registerItems((IForgeRegistry<Item>)event.getRegistry());
    }

    public static void registerItems(IForgeRegistry<Item> registry) {
        registry.register(new SpawnerKeyItem(new Item.Properties().func_200916_a(ItemGroup.field_78040_i).func_200918_c(10).func_208103_a(Rarity.RARE)).setRegistryName(MODID, "spawner_key"));
        registry.register(iron_golem_spawn_egg.setRegistryName(MODID, "iron_golem_spawn_egg"));
        registry.register(new BlockItem(Blocks.field_150474_ac, new Item.Properties().func_200916_a(ItemGroup.field_78031_c).func_208103_a(Rarity.EPIC)).setRegistryName(Blocks.field_150474_ac.getRegistryName()));
    }
}

