/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.mixins;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.mehvahdjukaar.supplementaries.configs.RegistryConfigs;
import net.minecraftforge.common.ForgeConfigSpec;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class MixinConfig
implements IMixinConfigPlugin {
    public static List<String> getMixinClassesNames() {
        try {
            String className = MixinConfig.class.getName();
            String packageName = MixinConfig.class.getPackage().getName();
            return MixinConfig.getClassesInPackage(packageName).stream().filter(s -> !s.equals(className) && !s.contains("$")).map(s -> s.substring(packageName.length() + 1)).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not fetch mixin classes, giving up: " + e.getMessage());
        }
    }

    private static List<String> getClassesInPackage(String packageName) throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        assert (classLoader != null);
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<File> dirs = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            dirs.add(new File(resource.getFile()));
        }
        ArrayList<String> classes = new ArrayList<String>();
        for (File directory : dirs) {
            classes.addAll(MixinConfig.findClasses(directory, packageName));
        }
        return classes;
    }

    private static List<String> findClasses(File directory, String packageName) {
        File[] files;
        ArrayList<String> classes = new ArrayList<String>();
        if (!directory.exists()) {
            return classes;
        }
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory()) {
                assert (!file.getName().contains("."));
                classes.addAll(MixinConfig.findClasses(file, packageName + "." + file.getName()));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            classes.add(packageName + '.' + file.getName().substring(0, file.getName().length() - 6));
        }
        return classes;
    }

    public void onLoad(String mixinPackage) {
        try {
            RegistryConfigs.createSpec();
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to create registry configs: " + exception);
        }
        try {
            RegistryConfigs.load();
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to load config supplementaries-registry.toml. Try deleting it");
        }
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        String truncatedName = mixinClassName.substring(this.getClass().getPackage().getName().length() + 1);
        ForgeConfigSpec.BooleanValue config = RegistryConfigs.reg.MIXIN_VALUES.get(truncatedName);
        return config == null || (Boolean)config.get() != false;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

