/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.items;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Predicate;
import net.mehvahdjukaar.selene.api.IFirstPersonAnimationProvider;
import net.mehvahdjukaar.selene.api.IThirdPersonAnimationProvider;
import net.mehvahdjukaar.selene.util.TwoHandedAnimation;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.entities.SlingshotProjectileEntity;
import net.mehvahdjukaar.supplementaries.events.ItemsOverrideHandler;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.enchantment.IVanishable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShootableItem;
import net.minecraft.item.UseAction;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;

public class SlingshotItem
extends ShootableItem
implements IVanishable,
IFirstPersonAnimationProvider,
IThirdPersonAnimationProvider {
    public SlingshotItem(Item.Properties properties) {
        super(properties);
    }

    public void func_77615_a(ItemStack stack, World world, LivingEntity entity2, int timeLeft) {
        float power;
        PlayerEntity playerentity;
        ItemStack projectileStack;
        if (entity2 instanceof PlayerEntity && !(projectileStack = (playerentity = (PlayerEntity)entity2).func_213356_f(stack)).func_190926_b() && this.func_220004_b().test(projectileStack) && !((double)(power = this.getPowerForTime(stack, timeLeft)) < 0.085)) {
            int maxProjectiles = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222192_G, (ItemStack)stack) > 0 ? 3 : 1;
            ArrayList<ItemStack> projectiles = new ArrayList<ItemStack>();
            for (int p = 0; p < maxProjectiles && this.func_220004_b().test(projectileStack); ++p) {
                projectiles.add(projectileStack.func_77946_l());
                if (!playerentity.field_71075_bZ.field_75098_d) {
                    projectileStack.func_190918_g(1);
                    if (projectileStack.func_190926_b()) {
                        playerentity.field_71071_by.func_184437_d(projectileStack);
                    }
                }
                projectileStack = playerentity.func_213356_f(stack);
            }
            if (!world.field_72995_K) {
                float[] pitches = SlingshotItem.getShotPitches(world.func_201674_k());
                int count = projectiles.size();
                float angle = 10.0f;
                for (int j = 0; j < count; ++j) {
                    boolean stasis = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)ModRegistry.STASIS_ENCHANTMENT.get()), (ItemStack)stack) != 0;
                    Hand hand = playerentity.func_184600_cs();
                    power = (float)((double)power * ((ServerConfigs.cached.SLINGSHOT_RANGE + (stasis ? 0.5 : 0.0)) * 1.1));
                    SlingshotItem.shootProjectile(world, entity2, hand, stack, (ItemStack)projectiles.get(j), count == 1 ? 1.0f : pitches[j], power, 1.0f, angle * ((float)j - (float)(count - 1) / 2.0f));
                }
            }
            playerentity.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
        }
    }

    private static void shootProjectile(World world, LivingEntity entity2, Hand hand, ItemStack stack, ItemStack projectileStack, float soundPitch, float power, float accuracy, float yaw) {
        SlingshotProjectileEntity projectile = new SlingshotProjectileEntity(entity2, world, projectileStack, stack);
        Vector3d vector3d1 = entity2.func_213286_i(1.0f);
        Quaternion quaternion = new Quaternion(new Vector3f(vector3d1), yaw, true);
        Vector3d vector3d = entity2.func_70676_i(1.0f);
        Vector3f vector3f = new Vector3f(vector3d);
        vector3f.func_214905_a(quaternion);
        projectile.func_70186_c(vector3f.func_195899_a(), vector3f.func_195900_b(), vector3f.func_195902_c(), power, accuracy);
        stack.func_222118_a(1, entity2, p -> p.func_213334_d(hand));
        world.func_217376_c((Entity)projectile);
        world.func_184148_a(null, entity2.func_226277_ct_(), entity2.func_226278_cu_(), entity2.func_226281_cx_(), SoundEvents.field_187924_gx, SoundCategory.PLAYERS, 1.0f, soundPitch * (1.0f / (field_77697_d.nextFloat() * 0.3f + 0.9f) + power * 0.6f));
    }

    private static float[] getShotPitches(Random random) {
        boolean flag = random.nextBoolean();
        return new float[]{SlingshotItem.getRandomShotPitch(flag), 1.0f, SlingshotItem.getRandomShotPitch(!flag)};
    }

    private static float getRandomShotPitch(boolean left) {
        float f = left ? 0.63f : 0.43f;
        return 1.0f / (field_77697_d.nextFloat() * 0.5f + 1.8f) + f;
    }

    public float getPowerForTime(ItemStack stack, float timeLeft) {
        float useTime = (float)this.func_77626_a(stack) - timeLeft;
        float f = useTime / (float)SlingshotItem.getChargeDuration(stack);
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public static int getChargeDuration(ItemStack stack) {
        int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222193_H, (ItemStack)stack);
        int maxCharge = ServerConfigs.cached.SLINGSHOT_CHARGE;
        return i == 0 ? maxCharge : maxCharge - maxCharge / 4 * i;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) || ImmutableSet.of((Object)Enchantments.field_222193_H, (Object)Enchantments.field_222192_G, (Object)Enchantments.field_203193_C).contains((Object)enchantment);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        boolean flag = this.func_220004_b().test(player.func_213356_f(itemstack));
        if (!flag) {
            return ActionResult.func_226251_d_((Object)itemstack);
        }
        player.func_184598_c(hand);
        return ActionResult.func_226249_b_((Object)itemstack);
    }

    public Predicate<ItemStack> func_220004_b() {
        return s -> s.func_77973_b() instanceof BlockItem || ItemsOverrideHandler.hasBlockOverride(s.func_77973_b());
    }

    public int func_230305_d_() {
        return 10;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.NONE;
    }

    public <T extends LivingEntity> boolean poseLeftArm(ItemStack stack, BipedModel<T> model, T entity2, HandSide mainHand, TwoHandedAnimation twoHanded) {
        if (entity2.func_184605_cv() > 0 && entity2.func_184607_cu().func_77973_b() == this) {
            model.field_178724_i.field_78796_g = 0.1f + model.field_78116_c.field_78796_g;
            model.field_178724_i.field_78795_f = -1.5707964f + model.field_78116_c.field_78795_f;
            return true;
        }
        return false;
    }

    public <T extends LivingEntity> boolean poseRightArm(ItemStack stack, BipedModel<T> model, T entity2, HandSide mainHand, TwoHandedAnimation twoHanded) {
        if (entity2.func_184605_cv() > 0 && entity2.func_184607_cu().func_77973_b() == this) {
            model.field_178723_h.field_78796_g = -0.1f + model.field_78116_c.field_78796_g;
            model.field_178723_h.field_78795_f = -1.5707964f + model.field_78116_c.field_78795_f;
            return true;
        }
        return false;
    }

    public void animateItemFirstPerson(LivingEntity entity2, ItemStack stack, Hand hand, MatrixStack matrixStack, float partialTicks, float pitch, float attackAnim, float handHeight) {
        if (entity2.func_184587_cr() && entity2.func_184605_cv() > 0 && entity2.func_184600_cs() == hand) {
            float timeLeft = (float)stack.func_77988_m() - ((float)Minecraft.func_71410_x().field_71439_g.func_184605_cv() - partialTicks + 1.0f);
            float f12 = this.getPowerForTime(stack, timeLeft);
            if (f12 > 0.1f) {
                float f15 = MathHelper.func_76126_a((float)((timeLeft - 0.1f) * 1.3f));
                float f18 = f12 - 0.1f;
                float f20 = f15 * f18;
                matrixStack.func_227861_a_((double)(f20 * 0.0f), (double)(f20 * 0.004f), (double)(f20 * 0.0f));
            }
            matrixStack.func_227861_a_((double)(f12 * 0.0f), (double)(f12 * 0.0f), (double)(f12 * 0.04f));
            matrixStack.func_227862_a_(1.0f, 1.0f, 1.0f + f12 * 0.2f);
        }
    }

    public static void animateCrossbowCharge(ModelRenderer offHand, ModelRenderer mainHand, LivingEntity entity2, boolean right) {
        offHand.field_78795_f = mainHand.field_78795_f;
        float f = CrossbowItem.func_220026_e((ItemStack)entity2.func_184607_cu());
        float f1 = MathHelper.func_76131_a((float)entity2.func_184612_cw(), (float)0.0f, (float)f);
        float f2 = f1 / f;
        offHand.field_78796_g = MathHelper.func_219799_g((float)f2, (float)0.4f, (float)0.85f) * (float)(right ? 1 : -1);
        offHand.field_78795_f = MathHelper.func_219799_g((float)f2, (float)offHand.field_78795_f, (float)-1.5707964f);
    }
}

