/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.tiles;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.blocks.ItemDisplayTile;
import net.mehvahdjukaar.supplementaries.block.blocks.NoticeBoardBlock;
import net.mehvahdjukaar.supplementaries.block.util.IMapDisplay;
import net.mehvahdjukaar.supplementaries.client.Materials;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.inventories.NoticeBoardContainer;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BannerPatternItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.WritableBookItem;
import net.minecraft.item.WrittenBookItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.INameable;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class NoticeBoardBlockTile
extends ItemDisplayTile
implements INameable,
IMapDisplay {
    private String text = null;
    private int fontScale = 1;
    private List<IReorderingProcessor> cachedPageLines = Collections.emptyList();
    private boolean needsVisualRefresh = true;
    private RenderMaterial cachedPattern = null;
    private boolean powered = false;
    private int pageNumber = 0;
    private DyeColor textColor = DyeColor.BLACK;
    private boolean textVisible = true;

    public NoticeBoardBlockTile() {
        super((TileEntityType)ModRegistry.NOTICE_BOARD_TILE.get());
    }

    public ITextComponent func_213907_g() {
        return new TranslationTextComponent("block.supplementaries.notice_board");
    }

    public void updateTileOnInventoryChanged() {
        boolean shouldHaveBook = !this.getDisplayedItem().func_190926_b();
        BlockState state = this.func_195044_w();
        if ((Boolean)state.func_177229_b((Property)BlockStateProperties.field_222515_o) != shouldHaveBook) {
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_222515_o, (Comparable)Boolean.valueOf(shouldHaveBook)), 2);
            if (shouldHaveBook) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_219617_ah, SoundCategory.BLOCKS, 1.0f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.85f);
            } else {
                this.pageNumber = 0;
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_219617_ah, SoundCategory.BLOCKS, 1.0f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.5f);
            }
        }
    }

    @Override
    public ItemStack getMapStack() {
        return this.getDisplayedItem();
    }

    public void updateClientVisualsOnLoad() {
        CompoundNBT com;
        ItemStack itemstack = this.getDisplayedItem();
        Item item2 = itemstack.func_77973_b();
        this.cachedPattern = null;
        if (item2 instanceof BannerPatternItem) {
            this.cachedPattern = Materials.FLAG_MATERIALS.get(((BannerPatternItem)item2).func_219980_b());
        }
        this.needsVisualRefresh = true;
        this.cachedPageLines = Collections.emptyList();
        this.text = null;
        if (item2 instanceof WrittenBookItem) {
            CompoundNBT com2 = itemstack.func_77978_p();
            if (WrittenBookItem.func_77828_a((CompoundNBT)com2)) {
                ListNBT listnbt = com2.func_150295_c("pages", 8).func_74737_b();
                if (this.pageNumber >= listnbt.size()) {
                    this.pageNumber %= listnbt.size();
                }
                this.text = listnbt.func_150307_f(this.pageNumber);
            }
        } else if (item2 instanceof WritableBookItem && WritableBookItem.func_150930_a((CompoundNBT)(com = itemstack.func_77978_p()))) {
            ListNBT listnbt = com.func_150295_c("pages", 8).func_74737_b();
            if (this.pageNumber >= listnbt.size()) {
                this.pageNumber %= listnbt.size();
            }
            this.text = listnbt.func_150307_f(this.pageNumber);
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        this.textColor = DyeColor.func_204271_a((String)compound.func_74779_i("Color"), (DyeColor)DyeColor.BLACK);
        this.textVisible = compound.func_74767_n("TextVisible");
        this.pageNumber = compound.func_74762_e("PageNumber");
        super.func_230337_a_(state, compound);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74778_a("Color", this.textColor.func_176762_d());
        compound.func_74757_a("TextVisible", this.textVisible);
        compound.func_74768_a("PageNumber", this.pageNumber);
        return compound;
    }

    public Container func_213906_a(int id, PlayerInventory player) {
        return new NoticeBoardContainer(id, player, (IInventory)this);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.func_191420_l() && (ServerConfigs.cached.NOTICE_BOARDS_UNRESTRICTED || NoticeBoardBlockTile.isPageItem(stack.func_77973_b()));
    }

    public static boolean isPageItem(Item item2) {
        return ItemTags.field_226160_P_ != null && item2.func_206844_a((ITag)ItemTags.field_226160_P_) || item2 instanceof FilledMapItem || item2 instanceof BannerPatternItem;
    }

    public boolean func_180462_a(int index, ItemStack stack, @Nullable Direction direction) {
        return this.func_94041_b(index, stack);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public DyeColor getTextColor() {
        return this.textColor;
    }

    public boolean setTextColor(DyeColor newColor) {
        if (newColor != this.getTextColor()) {
            this.textColor = newColor;
            return true;
        }
        return false;
    }

    public boolean shouldSkipTileRenderer() {
        return !this.textVisible || (Boolean)this.func_195044_w().func_177229_b((Property)NoticeBoardBlock.HAS_BOOK) == false;
    }

    public void setTextVisible(boolean textVisible) {
        this.textVisible = textVisible;
    }

    public RenderMaterial getCachedPattern() {
        return this.cachedPattern;
    }

    public String getText() {
        return this.text;
    }

    public int getFontScale() {
        return this.fontScale;
    }

    public void setFontScale(int s) {
        this.fontScale = s;
    }

    public void setCachedPageLines(List<IReorderingProcessor> l) {
        this.cachedPageLines = l;
    }

    public List<IReorderingProcessor> getCachedPageLines() {
        return this.cachedPageLines;
    }

    public boolean getFlag() {
        if (this.needsVisualRefresh) {
            this.needsVisualRefresh = false;
            return true;
        }
        return false;
    }

    public Direction getDirection() {
        return (Direction)this.func_195044_w().func_177229_b((Property)NoticeBoardBlock.FACING);
    }

    public void updatePower(boolean powered) {
        if (powered != this.powered && powered) {
            ++this.pageNumber;
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_219617_ah, SoundCategory.BLOCKS, 1.0f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 1.45f);
            this.func_70296_d();
        }
        this.powered = powered;
    }

    public ActionResultType interact(PlayerEntity player, Hand handIn, BlockPos pos, BlockState state) {
        boolean server;
        ItemStack itemStack = player.func_184586_b(handIn);
        Item item2 = itemStack.func_77973_b();
        boolean bl = server = !this.field_145850_b.field_72995_K;
        if (item2 instanceof DyeItem && player.field_71075_bZ.field_75099_e) {
            if (this.setTextColor(((DyeItem)item2).func_195962_g())) {
                if (!player.func_184812_l_()) {
                    itemStack.func_190918_g(1);
                }
                if (server) {
                    this.func_70296_d();
                }
            }
        } else if (player.func_225608_bj_() && !this.func_191420_l()) {
            if (server) {
                ItemStack it = this.func_70304_b(0);
                BlockPos newPos = pos.func_177971_a(((Direction)state.func_177229_b((Property)NoticeBoardBlock.FACING)).func_176730_m());
                ItemEntity drop = new ItemEntity(this.field_145850_b, (double)newPos.func_177958_n() + 0.5, (double)newPos.func_177956_o() + 0.5, (double)newPos.func_177952_p() + 0.5, it);
                drop.func_174869_p();
                this.field_145850_b.func_217376_c((Entity)drop);
                this.func_70296_d();
            }
        } else if (!super.interact(player, handIn).func_226246_a_() && server) {
            player.func_213829_a((INamedContainerProvider)this);
        }
        return ActionResultType.func_233537_a_((!server ? 1 : 0) != 0);
    }
}

