/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tools.item;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.base.item.QuarkItem;
import vazkii.quark.base.module.QuarkModule;

public class AbacusItem
extends QuarkItem {
    public static final String TAG_POS_X = "boundPosX";
    public static final String TAG_POS_Y = "boundPosY";
    public static final String TAG_POS_Z = "boundPosZ";
    public static int MAX_COUNT = 48;

    public AbacusItem(QuarkModule module) {
        super("abacus", module, new Item.Properties().func_200916_a(ItemGroup.field_78040_i).func_200917_a(1));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ItemStack stack = context.func_195996_i();
        BlockPos curr = AbacusItem.getBlockPos(stack);
        if (curr != null) {
            AbacusItem.setBlockPos(stack, null);
        } else {
            AbacusItem.setBlockPos(stack, context.func_195995_a());
        }
        return ActionResultType.SUCCESS;
    }

    public static void setBlockPos(ItemStack stack, BlockPos pos) {
        if (pos == null) {
            ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_POS_Y, (int)-1);
        } else {
            ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_POS_X, (int)pos.func_177958_n());
            ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_POS_Y, (int)pos.func_177956_o());
            ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_POS_Z, (int)pos.func_177952_p());
        }
    }

    public static BlockPos getBlockPos(ItemStack stack) {
        int y = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_POS_Y, (int)-1);
        if (y == -1) {
            return null;
        }
        int x = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_POS_X, (int)0);
        int z = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_POS_Z, (int)0);
        return new BlockPos(x, y, z);
    }

    public static int getCount(ItemStack stack, BlockPos target, World world) {
        BlockPos pos = AbacusItem.getBlockPos(stack);
        if (pos != null && !world.func_175623_d(target)) {
            return target.func_218139_n((Vector3i)pos);
        }
        return -1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int getCount(ItemStack stack, LivingEntity entityIn) {
        RayTraceResult result;
        int count = -1;
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (entityIn == player && (result = mc.field_71476_x) instanceof BlockRayTraceResult) {
            BlockPos target = ((BlockRayTraceResult)result).func_216350_a();
            count = AbacusItem.getCount(stack, target, player.field_70170_p);
        }
        return count;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static float count(ItemStack stack, ClientWorld world, LivingEntity entityIn) {
        int count = AbacusItem.getCount(stack, entityIn);
        if (count == -1) {
            return 9999.0f;
        }
        return 0.01f * (float)count + 0.005f;
    }
}

