/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.mobs.ai;

import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.BooleanSupplier;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.vector.Vector3d;
import vazkii.quark.base.util.MutableVectorHolder;
import vazkii.quark.content.mobs.entity.StonelingEntity;

public class ActWaryGoal
extends WaterAvoidingRandomWalkingGoal {
    private final StonelingEntity stoneling;
    private final BooleanSupplier scaredBySuddenMovement;
    private final double range;
    private boolean startled;
    private final Map<PlayerEntity, MutableVectorHolder> lastPositions = new WeakHashMap<PlayerEntity, MutableVectorHolder>();
    private final Map<PlayerEntity, MutableVectorHolder> lastSpeeds = new WeakHashMap<PlayerEntity, MutableVectorHolder>();

    public ActWaryGoal(StonelingEntity stoneling, double speed, double range, BooleanSupplier scaredBySuddenMovement) {
        super((CreatureEntity)stoneling, speed, 1.0f);
        this.stoneling = stoneling;
        this.range = range;
        this.scaredBySuddenMovement = scaredBySuddenMovement;
    }

    private static void updateMotion(MutableVectorHolder holder, double x, double y, double z) {
        holder.x = x;
        holder.y = y;
        holder.z = z;
    }

    private static void updatePos(MutableVectorHolder holder, Entity entity) {
        Vector3d pos = entity.func_213303_ch();
        holder.x = pos.field_72450_a;
        holder.y = pos.field_72448_b;
        holder.z = pos.field_72449_c;
    }

    private static MutableVectorHolder initPos(PlayerEntity p) {
        MutableVectorHolder holder = new MutableVectorHolder();
        ActWaryGoal.updatePos(holder, (Entity)p);
        return holder;
    }

    public void startle() {
        this.startled = true;
    }

    public boolean isStartled() {
        return this.startled;
    }

    protected boolean shouldApplyPath() {
        return super.func_75250_a();
    }

    public void func_75246_d() {
        if (this.stoneling.func_70661_as().func_75500_f() && this.shouldApplyPath()) {
            this.func_75249_e();
        }
    }

    public boolean func_75253_b() {
        return this.func_75250_a();
    }

    public void func_75251_c() {
        this.stoneling.func_70661_as().func_75499_g();
    }

    public boolean func_75250_a() {
        if (this.startled || this.stoneling.isPlayerMade()) {
            return false;
        }
        List playersAround = this.stoneling.field_70170_p.func_175647_a(PlayerEntity.class, this.stoneling.func_174813_aQ().func_186662_g(this.range), player -> player != null && !player.field_71075_bZ.field_75098_d && player.func_70068_e((Entity)this.stoneling) < this.range * this.range);
        if (playersAround.isEmpty()) {
            return false;
        }
        for (PlayerEntity player2 : playersAround) {
            if (player2.func_226273_bm_()) {
                if (!this.scaredBySuddenMovement.getAsBoolean()) continue;
                MutableVectorHolder lastSpeed = this.lastSpeeds.computeIfAbsent(player2, p -> new MutableVectorHolder());
                MutableVectorHolder lastPos = this.lastPositions.computeIfAbsent(player2, ActWaryGoal::initPos);
                Vector3d pos = player2.func_213303_ch();
                double dX = pos.field_72450_a - lastPos.x;
                double dY = pos.field_72448_b - lastPos.y;
                double dZ = pos.field_72449_c - lastPos.z;
                double xDisplacement = dX - lastSpeed.x;
                double yDisplacement = dY - lastSpeed.y;
                double zDisplacement = dZ - lastSpeed.z;
                ActWaryGoal.updateMotion(lastSpeed, dX, dY, dZ);
                ActWaryGoal.updatePos(lastPos, (Entity)player2);
                double displacementSq = xDisplacement * xDisplacement + yDisplacement * yDisplacement + zDisplacement * zDisplacement;
                if (displacementSq < 0.01) {
                    return true;
                }
                this.startled = true;
                return false;
            }
            this.startled = true;
            return false;
        }
        return true;
    }
}

