/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.client.tooltip;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.item.Food;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import vazkii.quark.content.client.module.ImprovedTooltipsModule;
import vazkii.quark.content.client.tooltip.TooltipUtils;

public class FoodTooltips {
    @OnlyIn(value=Dist.CLIENT)
    public static void makeTooltip(ItemTooltipEvent event, boolean showFood, boolean showSaturation) {
        Food food;
        if (event.getItemStack().func_222117_E() && (food = event.getItemStack().func_77973_b().func_219967_s()) != null) {
            int pips = food.func_221466_a();
            if (pips == 0) {
                return;
            }
            int len = (int)Math.ceil((double)pips / (double)ImprovedTooltipsModule.foodDivisor);
            StringBuilder s = new StringBuilder(" ");
            for (int i = 0; i < len; ++i) {
                s.append("  ");
            }
            int saturationSimplified = 0;
            float saturation = food.func_221469_b();
            if (saturation < 1.0f) {
                saturationSimplified = (double)saturation > 0.7 ? 1 : ((double)saturation > 0.5 ? 2 : ((double)saturation > 0.2 ? 3 : 4));
            }
            StringTextComponent spaces = new StringTextComponent(s.toString());
            IFormattableTextComponent saturationText = new TranslationTextComponent("quark.misc.saturation" + saturationSimplified).func_240699_a_(TextFormatting.GRAY);
            List tooltip = event.getToolTip();
            if (tooltip.isEmpty()) {
                if (showFood) {
                    tooltip.add(spaces);
                }
                if (showSaturation) {
                    tooltip.add(saturationText);
                }
            } else {
                int i = 1;
                if (showFood) {
                    tooltip.add(i, spaces);
                    ++i;
                }
                if (showSaturation) {
                    tooltip.add(i, saturationText);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderTooltip(RenderTooltipEvent.PostText event) {
        Food food;
        if (event.getStack().func_222117_E() && (food = event.getStack().func_77973_b().func_219967_s()) != null) {
            boolean compress;
            RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft mc = Minecraft.func_71410_x();
            MatrixStack matrix = event.getMatrixStack();
            int pips = food.func_221466_a();
            if (pips == 0) {
                return;
            }
            boolean poison = false;
            for (Pair effect : food.func_221464_f()) {
                if (effect.getFirst() == null || ((EffectInstance)effect.getFirst()).func_188419_a() == null || ((EffectInstance)effect.getFirst()).func_188419_a().func_220303_e() != EffectType.HARMFUL) continue;
                poison = true;
                break;
            }
            int count = (int)Math.ceil((double)pips / (double)ImprovedTooltipsModule.foodDivisor);
            boolean fract = pips % 2 != 0;
            int renderCount = count;
            int y = TooltipUtils.shiftTextByLines(event.getLines(), event.getY() + 10);
            boolean bl = compress = count > ImprovedTooltipsModule.foodCompressionThreshold;
            if (compress) {
                renderCount = 1;
                if (fract) {
                    --count;
                }
            }
            matrix.func_227860_a_();
            matrix.func_227861_a_(0.0, 0.0, 500.0);
            mc.func_110434_K().func_110577_a(ForgeIngameGui.field_230665_h_);
            for (int i = 0; i < renderCount; ++i) {
                int x = event.getX() + i * 9 - 1;
                int u = 16;
                if (poison) {
                    u += 117;
                }
                int v = 27;
                AbstractGui.func_238463_a_((MatrixStack)matrix, (int)x, (int)y, (float)u, (float)v, (int)9, (int)9, (int)256, (int)256);
                u = 52;
                if (fract && i == 0) {
                    u += 9;
                }
                if (poison) {
                    u += 36;
                }
                AbstractGui.func_238463_a_((MatrixStack)matrix, (int)x, (int)y, (float)u, (float)v, (int)9, (int)9, (int)256, (int)256);
            }
            if (compress) {
                mc.field_71466_p.func_238405_a_(matrix, "x" + count + (fract ? ".5" : ""), (float)(event.getX() + 10), (float)(y + 1), -10066330);
            }
            matrix.func_227865_b_();
        }
    }
}

