/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.automation.module;

import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.OptionalDispenseBehavior;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.network.QuarkNetwork;
import vazkii.quark.base.network.message.SyncChainMessage;
import vazkii.quark.content.automation.base.ChainHandler;
import vazkii.quark.content.automation.client.render.ChainRenderer;

@LoadModule(category=ModuleCategory.AUTOMATION, hasSubscriptions=true)
public class ChainLinkageModule
extends QuarkModule {
    @Config(description="Can vehicle-linking chains be used for crafting chain armor?", flag="chain_craft_armor")
    public static boolean craftsArmor = true;
    private static final IntObjectMap<UUID> AWAIT_MAP = new IntObjectHashMap();

    @Override
    public void setup() {
        if (!this.enabled) {
            return;
        }
        DispenserBlock.field_149943_a.put(Items.field_234729_dO_, new LinkCartsBehaviour());
    }

    public static void queueChainUpdate(int vehicle, UUID other) {
        if (other != null && !other.equals(SyncChainMessage.NULL_UUID)) {
            AWAIT_MAP.put(vehicle, (Object)other);
        }
    }

    public static void onEntityUpdate(Entity vehicle) {
        if (ChainHandler.canBeLinkedTo(vehicle)) {
            ChainHandler.adjustVehicle(vehicle);
        }
    }

    public static void drop(Entity vehicle) {
        if (ChainHandler.getLinked(vehicle) != null) {
            vehicle.func_70099_a(new ItemStack((IItemProvider)Items.field_234729_dO_), 0.0f);
        }
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent.EntityInteract event) {
        PlayerEntity player = event.getPlayer();
        ItemStack stack = event.getItemStack();
        Entity entity = event.getTarget();
        Entity link = ChainHandler.getLinked(entity);
        boolean sneaking = player.func_226273_bm_();
        ArrayList<Entity> linkedToPlayer = new ArrayList<Entity>();
        for (Entity linkCandidate : entity.field_70170_p.func_217357_a(Entity.class, player.func_174813_aQ().func_186662_g(8.0))) {
            if (ChainHandler.getLinked(linkCandidate) != player) continue;
            linkedToPlayer.add(linkCandidate);
        }
        if (ChainHandler.canBeLinked(entity) && linkedToPlayer.isEmpty() && !stack.func_190926_b() && stack.func_77973_b() == Items.field_234729_dO_ && link == null) {
            if (!entity.field_70170_p.field_72995_K) {
                ChainHandler.setLink(entity, player.func_110124_au(), true);
                if (!player.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
            }
            event.setCancellationResult(ActionResultType.SUCCESS);
            event.setCanceled(true);
        } else if (link == player) {
            event.setCancellationResult(ActionResultType.SUCCESS);
            event.setCanceled(true);
        } else if (ChainHandler.canBeLinked(entity) && !linkedToPlayer.isEmpty()) {
            if (!entity.field_70170_p.field_72995_K) {
                for (Entity linked : linkedToPlayer) {
                    ChainHandler.setLink(linked, entity.func_110124_au(), true);
                }
            }
            event.setCancellationResult(ActionResultType.SUCCESS);
            event.setCanceled(true);
        } else if (link != null && sneaking) {
            if (!entity.field_70170_p.field_72995_K) {
                if (!player.func_184812_l_()) {
                    entity.func_70099_a(new ItemStack((IItemProvider)Items.field_234729_dO_), 0.0f);
                }
                ChainHandler.setLink(entity, null, true);
            }
            event.setCancellationResult(ActionResultType.SUCCESS);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientUpdateTick(TickEvent.ClientTickEvent event) {
        if (event.side == LogicalSide.CLIENT && event.phase == TickEvent.Phase.START) {
            ChainRenderer.updateTick();
        }
    }

    @SubscribeEvent
    public void onVehicleSeen(PlayerEvent.StartTracking event) {
        if (ChainHandler.canBeLinked(event.getTarget()) && event.getPlayer() instanceof ServerPlayerEntity) {
            QuarkNetwork.sendToPlayer(new SyncChainMessage(event.getTarget().func_145782_y(), ChainHandler.getLink(event.getTarget())), (ServerPlayerEntity)event.getPlayer());
        }
    }

    @SubscribeEvent
    public void onVehicleArrive(EntityJoinWorldEvent event) {
        Entity target = event.getEntity();
        if (event.getWorld().field_72995_K && ChainHandler.canBeLinked(target)) {
            int id = target.func_145782_y();
            if (AWAIT_MAP.containsKey(id)) {
                target.getPersistentData().func_186854_a("Quark:VehicleLink", (UUID)AWAIT_MAP.get(id));
            }
            AWAIT_MAP.remove(id);
        }
    }

    public static class LinkCartsBehaviour
    extends OptionalDispenseBehavior {
        @Nonnull
        public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            Direction direction = (Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a);
            AxisAlignedBB targetArea = new AxisAlignedBB(source.func_180699_d().func_177972_a(direction));
            List linkableCarts = source.func_197524_h().func_217357_a(AbstractMinecartEntity.class, targetArea).stream().filter(e -> ChainHandler.getLinked(e) == null).collect(Collectors.toList());
            if (linkableCarts.size() != 2) {
                return stack;
            }
            ChainHandler.setLink((Entity)linkableCarts.get(0), ((AbstractMinecartEntity)linkableCarts.get(1)).func_110124_au(), true);
            stack.func_190918_g(1);
            this.field_218407_b = true;
            return stack;
        }
    }
}

