/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.client.config.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Arrays;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.gui.widget.Slider;
import vazkii.quark.base.client.config.ConfigCategory;
import vazkii.quark.base.client.config.gui.AbstractInputScreen;
import vazkii.quark.base.module.config.type.ColorMatrixConfig;

public class ColorMatrixInputScreen
extends AbstractInputScreen<ColorMatrixConfig> {
    final ColorMatrixConfig color;
    final ColorMatrixConfig mutable;
    final ConfigCategory category;

    public ColorMatrixInputScreen(Screen parent, ColorMatrixConfig colorMatrix, ConfigCategory category) {
        super(parent);
        this.color = colorMatrix;
        this.mutable = colorMatrix.copy();
        this.category = category;
    }

    @Override
    void onInit() {
        int w = 70;
        int p = 12;
        int x = this.field_230708_k_ / 2 - 33;
        int y = 55;
        StringTextComponent prefix = new StringTextComponent("");
        StringTextComponent suffix = new StringTextComponent("");
        for (int i = 0; i < 9; ++i) {
            this.func_230480_a_((Widget)new Slider(x + w * (i % 3), y + 25 * (i / 3), w - p, 20, (ITextComponent)prefix, (ITextComponent)suffix, 0.0, 2.0, this.color.colorMatrix[i], false, false, this::onSlide));
        }
        this.func_230480_a_((Widget)new Button(x + w * 0, y + 115, w - p, 20, (ITextComponent)new StringTextComponent("Identity"), this::onSlide));
        this.func_230480_a_((Widget)new Button(x + w * 1, y + 115, w - p, 20, (ITextComponent)new StringTextComponent("Dreary"), this::onSlide));
        this.func_230480_a_((Widget)new Button(x + w * 2, y + 115, w - p, 20, (ITextComponent)new StringTextComponent("Vibrant"), this::onSlide));
    }

    @Override
    public void func_230430_a_(MatrixStack mstack, int mouseX, int mouseY, float pticks) {
        super.func_230430_a_(mstack, mouseX, mouseY, pticks);
        int x = this.field_230708_k_ / 2 - 203;
        int y = 10;
        int size = 60;
        int titleLeft = this.field_230708_k_ / 2 + 66;
        ColorMatrixInputScreen.func_238472_a_((MatrixStack)mstack, (FontRenderer)this.field_230712_o_, (ITextComponent)new StringTextComponent(this.category.getGuiDisplayName()).func_240699_a_(TextFormatting.BOLD), (int)titleLeft, (int)20, (int)0xFFFFFF);
        ColorMatrixInputScreen.func_238472_a_((MatrixStack)mstack, (FontRenderer)this.field_230712_o_, (ITextComponent)new StringTextComponent("Presets"), (int)titleLeft, (int)155, (int)0xFFFFFF);
        int sliders = 0;
        boolean needsUpdate = false;
        for (Widget w : this.field_230710_m_) {
            double val;
            double curr;
            if (!(w instanceof Slider)) continue;
            Slider s = (Slider)w;
            if (mouseX < s.field_230690_l_ || mouseY < s.field_230691_m_ || mouseX >= s.field_230690_l_ + s.func_230998_h_() || mouseY >= s.field_230691_m_ + s.func_238483_d_()) {
                s.dragging = false;
            }
            if ((curr = this.mutable.colorMatrix[sliders]) != (val = this.correct(s))) {
                this.mutable.colorMatrix[sliders] = val;
                needsUpdate = true;
            }
            String displayVal = String.format("%.2f", val);
            this.field_230712_o_.func_238405_a_(mstack, displayVal, (float)(s.field_230690_l_ + s.func_230998_h_() / 2 - this.field_230712_o_.func_78256_a(displayVal) / 2), (float)(s.field_230691_m_ + 6), 0xFFFFFF);
            switch (sliders) {
                case 0: {
                    this.field_230712_o_.func_238405_a_(mstack, "R =", (float)(s.field_230690_l_ - 20), (float)(s.field_230691_m_ + 5), 0xFF0000);
                    this.field_230712_o_.func_238405_a_(mstack, "R", (float)(s.field_230690_l_ + s.func_230998_h_() / 2 - 2), (float)(s.field_230691_m_ - 12), 0xFF0000);
                    break;
                }
                case 1: {
                    this.field_230712_o_.func_238405_a_(mstack, "G", (float)(s.field_230690_l_ + s.func_230998_h_() / 2 - 2), (float)(s.field_230691_m_ - 12), 65280);
                    break;
                }
                case 2: {
                    this.field_230712_o_.func_238405_a_(mstack, "B", (float)(s.field_230690_l_ + s.func_230998_h_() / 2 - 2), (float)(s.field_230691_m_ - 12), 30719);
                    break;
                }
                case 3: {
                    this.field_230712_o_.func_238405_a_(mstack, "G =", (float)(s.field_230690_l_ - 20), (float)(s.field_230691_m_ + 5), 65280);
                    break;
                }
                case 6: {
                    this.field_230712_o_.func_238405_a_(mstack, "B =", (float)(s.field_230690_l_ - 20), (float)(s.field_230691_m_ + 5), 30719);
                    break;
                }
            }
            if (sliders % 3 != 0) {
                this.field_230712_o_.func_238405_a_(mstack, "+", (float)(s.field_230690_l_ - 9), (float)(s.field_230691_m_ + 5), 0xFFFFFF);
            }
            ++sliders;
        }
        String[] biomes = new String[]{"plains", "forest", "mountains", "jungle", "savanna", "swamp"};
        int[] colors = new int[]{-7226023, -8798118, -7686519, -10892996, -4212907, -9801671};
        int[] folliageColors = new int[]{-8934609, -10899920, -9591957, -13583605, -5331926, -9801671};
        for (int i = 0; i < biomes.length; ++i) {
            String name = biomes[i];
            int color = colors[i];
            int folliage = folliageColors[i];
            int convolved = this.mutable.convolve(color);
            int convolvedFolliage = this.mutable.convolve(folliage);
            int cx = x + i % 2 * (size + 5);
            int cy = y + i / 2 * (size + 5);
            ColorMatrixInputScreen.func_238467_a_((MatrixStack)mstack, (int)(cx - 1), (int)(cy - 1), (int)(cx + size + 1), (int)(cy + size + 1), (int)-16777216);
            ColorMatrixInputScreen.func_238467_a_((MatrixStack)mstack, (int)cx, (int)cy, (int)(cx + size), (int)(cy + size), (int)convolved);
            ColorMatrixInputScreen.func_238467_a_((MatrixStack)mstack, (int)(cx + size / 2 - 1), (int)(cy + size / 2 - 1), (int)(cx + size), (int)(cy + size), (int)0x22000000);
            ColorMatrixInputScreen.func_238467_a_((MatrixStack)mstack, (int)(cx + size / 2), (int)(cy + size / 2), (int)(cx + size), (int)(cy + size), (int)convolvedFolliage);
            this.field_230712_o_.func_238421_b_(mstack, name, (float)(cx + 2), (float)(cy + 2), 0x55000000);
            this.field_230706_i_.func_175599_af().func_175042_a(new ItemStack((IItemProvider)Items.field_221592_t), cx + size - 18, cy + size - 16);
            mstack.func_227860_a_();
            mstack.func_227861_a_(0.0, 0.0, 999.0);
            ColorMatrixInputScreen.func_238467_a_((MatrixStack)mstack, (int)(cx + size / 2), (int)(cy + size / 2), (int)(cx + size), (int)(cy + size), (int)(convolvedFolliage & 0x55FFFFFF));
            mstack.func_227865_b_();
        }
        if (needsUpdate) {
            this.update();
        }
    }

    private double correct(Slider s) {
        double val = s.getValue();
        val = this.correct(val, 1.0, s);
        val = this.correct(val, 0.5, s);
        val = this.correct(val, 1.5, s);
        return val;
    }

    private double correct(double val, double correct, Slider s) {
        if (Math.abs(val - correct) < 0.02) {
            s.setValue(correct);
            return correct;
        }
        return val;
    }

    @Override
    ColorMatrixConfig compute() {
        return this.mutable;
    }

    void onSlide(Button button) {
        String name = button.func_230458_i_().getString();
        double[][] matrices = new double[][]{{1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0}, {1.24, 0.0, 0.0, 0.0, 0.84, 0.0, 0.0, 0.16, 0.36}, {1.0, 0.0, 0.0, 0.24, 1.0, 0.24, 0.0, 0.0, 0.6}};
        int idx = 0;
        switch (name) {
            case "Dreary": {
                idx = 1;
                break;
            }
            case "Vibrant": {
                idx = 2;
            }
        }
        int sliders = 0;
        this.mutable.colorMatrix = Arrays.copyOf(matrices[idx], matrices[idx].length);
        for (Widget w : this.field_230710_m_) {
            if (!(w instanceof Slider)) continue;
            Slider s = (Slider)w;
            s.setValue(matrices[idx][sliders]);
            ++sliders;
        }
        this.update();
    }

    @Override
    void setDefault() {
        this.mutable.colorMatrix = Arrays.copyOf(this.color.defaultMatrix, this.color.defaultMatrix.length);
    }

    @Override
    void reset() {
        this.mutable.colorMatrix = Arrays.copyOf(this.mutable.defaultMatrix, this.mutable.defaultMatrix.length);
    }

    @Override
    boolean isErrored() {
        return false;
    }

    @Override
    boolean isDirty() {
        return !this.color.equals(this.mutable);
    }

    @Override
    void commit() {
        this.color.inherit(this.mutable);
    }
}

