/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.transfer;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.ResourceLocation;

public class BasicRecipeTransferInfo<C extends Container>
implements IRecipeTransferInfo<C> {
    private final Class<C> containerClass;
    private final ResourceLocation recipeCategoryUid;
    private final int recipeSlotStart;
    private final int recipeSlotCount;
    private final int inventorySlotStart;
    private final int inventorySlotCount;

    public BasicRecipeTransferInfo(Class<C> containerClass, ResourceLocation recipeCategoryUid, int recipeSlotStart, int recipeSlotCount, int inventorySlotStart, int inventorySlotCount) {
        this.containerClass = containerClass;
        this.recipeCategoryUid = recipeCategoryUid;
        this.recipeSlotStart = recipeSlotStart;
        this.recipeSlotCount = recipeSlotCount;
        this.inventorySlotStart = inventorySlotStart;
        this.inventorySlotCount = inventorySlotCount;
    }

    @Override
    public Class<C> getContainerClass() {
        return this.containerClass;
    }

    @Override
    public ResourceLocation getRecipeCategoryUid() {
        return this.recipeCategoryUid;
    }

    @Override
    public boolean canHandle(C container) {
        return true;
    }

    @Override
    public List<Slot> getRecipeSlots(C container) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (int i = this.recipeSlotStart; i < this.recipeSlotStart + this.recipeSlotCount; ++i) {
            Slot slot = container.func_75139_a(i);
            slots.add(slot);
        }
        return slots;
    }

    @Override
    public List<Slot> getInventorySlots(C container) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (int i = this.inventorySlotStart; i < this.inventorySlotStart + this.inventorySlotCount; ++i) {
            Slot slot = container.func_75139_a(i);
            slots.add(slot);
        }
        return slots;
    }
}

