/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.voiding;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IInsertResponseUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IOverflowResponseUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IPickupResponseUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.api.ISlotChangeResponseUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.api.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackInventoryHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.IFilteredUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.PrimaryMatch;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.voiding.VoidUpgradeItem;
import net.p3pp3rf1y.sophisticatedbackpacks.util.IItemHandlerSimpleInserter;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;

public class VoidUpgradeWrapper
extends UpgradeWrapperBase<VoidUpgradeWrapper, VoidUpgradeItem>
implements IPickupResponseUpgrade,
IInsertResponseUpgrade,
IFilteredUpgrade,
ISlotChangeResponseUpgrade,
ITickableUpgrade,
IOverflowResponseUpgrade {
    private final FilterLogic filterLogic;
    private final Set<Integer> slotsToVoid = new HashSet<Integer>();
    private boolean shouldVoidOverflow;

    public VoidUpgradeWrapper(IBackpackWrapper backpackWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(backpackWrapper, upgrade, upgradeSaveHandler);
        this.filterLogic = new FilterLogic(upgrade, upgradeSaveHandler, ((VoidUpgradeItem)this.upgradeItem).getFilterSlotCount());
        this.filterLogic.setAllowByDefault();
        this.shouldVoidOverflow = NBTHelper.getBoolean(upgrade, "shouldVoidOverflow").orElse(false);
    }

    @Override
    public ItemStack pickup(World world, ItemStack stack, boolean simulate) {
        if (this.filterLogic.matchesFilter(stack)) {
            if (this.shouldVoidOverflow && !simulate) {
                this.backpackWrapper.getInventoryForUpgradeProcessing().insertItem(stack, false);
            }
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    @Override
    public ItemStack onBeforeInsert(IItemHandlerSimpleInserter inventoryHandler, int slot, ItemStack stack, boolean simulate) {
        if (this.shouldVoidOverflow && inventoryHandler.getStackInSlot(slot).func_190926_b() && (!this.filterLogic.shouldMatchNbt() || !this.filterLogic.shouldMatchDurability() || this.filterLogic.getPrimaryMatch() != PrimaryMatch.ITEM) && this.filterLogic.matchesFilter(stack)) {
            for (int s = 0; s < inventoryHandler.getSlots(); ++s) {
                if (s == slot || !this.stackMatchesFilterStack(inventoryHandler.getStackInSlot(s), stack)) continue;
                return ItemStack.field_190927_a;
            }
            return stack;
        }
        return !this.shouldVoidOverflow && this.filterLogic.matchesFilter(stack) ? ItemStack.field_190927_a : stack;
    }

    @Override
    public void onAfterInsert(IItemHandlerSimpleInserter inventoryHandler, int slot) {
    }

    @Override
    public FilterLogic getFilterLogic() {
        return this.filterLogic;
    }

    public void setShouldWorkdInGUI(boolean shouldWorkdInGUI) {
        NBTHelper.setBoolean(this.upgrade, "shouldWorkInGUI", shouldWorkdInGUI);
        this.save();
    }

    public boolean shouldWorkInGUI() {
        return NBTHelper.getBoolean(this.upgrade, "shouldWorkInGUI").orElse(false);
    }

    public void setShouldVoidOverflow(boolean shouldVoidOverflow) {
        this.shouldVoidOverflow = shouldVoidOverflow;
        NBTHelper.setBoolean(this.upgrade, "shouldVoidOverflow", shouldVoidOverflow);
        this.save();
    }

    public boolean shouldVoidOverflow() {
        return this.shouldVoidOverflow;
    }

    @Override
    public void onSlotChange(IItemHandler inventoryHandler, int slot) {
        if (!this.shouldWorkInGUI() || this.shouldVoidOverflow()) {
            return;
        }
        ItemStack slotStack = inventoryHandler.getStackInSlot(slot);
        if (this.filterLogic.matchesFilter(slotStack)) {
            this.slotsToVoid.add(slot);
        }
    }

    @Override
    public void tick(@Nullable LivingEntity entity, World world, BlockPos pos) {
        if (this.slotsToVoid.isEmpty()) {
            return;
        }
        BackpackInventoryHandler backpackInventory = this.backpackWrapper.getInventoryHandler();
        for (int slot : this.slotsToVoid) {
            backpackInventory.extractItem(slot, backpackInventory.getStackInSlot(slot).func_190916_E(), false);
        }
        this.slotsToVoid.clear();
    }

    @Override
    public boolean worksInGui() {
        return this.shouldWorkInGUI();
    }

    @Override
    public ItemStack onOverflow(ItemStack stack) {
        return this.filterLogic.matchesFilter(stack) ? ItemStack.field_190927_a : stack;
    }

    @Override
    public boolean stackMatchesFilter(ItemStack stack) {
        return this.filterLogic.matchesFilter(stack);
    }
}

