/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.common.integration.refinedstorage;

import com.refinedmods.refinedstorage.api.network.grid.ICraftingGridListener;
import com.refinedmods.refinedstorage.api.network.grid.IGrid;
import com.refinedmods.refinedstorage.apiimpl.network.node.GridNetworkNode;
import com.refinedmods.refinedstorage.container.GridContainer;
import com.refinedmods.refinedstorage.tile.grid.GridTile;
import java.util.Optional;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import top.theillusivec4.polymorph.api.PolymorphApi;
import top.theillusivec4.polymorph.api.client.base.IPolymorphClient;
import top.theillusivec4.polymorph.api.common.base.IPolymorphCommon;
import top.theillusivec4.polymorph.common.crafting.RecipeSelection;
import top.theillusivec4.polymorph.common.integration.AbstractCompatibilityModule;
import top.theillusivec4.polymorph.common.integration.refinedstorage.GridTileRecipeData;
import top.theillusivec4.polymorph.common.integration.refinedstorage.GridTileRecipesWidget;
import top.theillusivec4.polymorph.mixin.integration.refinedstorage.AccessorGrid;

public class RefinedStorageModule
extends AbstractCompatibilityModule {
    @Override
    public void clientSetup() {
        IPolymorphClient clientApi = PolymorphApi.client();
        clientApi.registerWidget(pContainerScreen -> {
            GridContainer container;
            if (pContainerScreen.func_212873_a_() instanceof GridContainer && (container = (GridContainer)pContainerScreen.func_212873_a_()).getTile() instanceof GridTile) {
                return clientApi.findCraftingResultSlot(pContainerScreen).map(slot -> new GridTileRecipesWidget((ContainerScreen<?>)pContainerScreen, (Slot)slot)).orElse(null);
            }
            return null;
        });
    }

    @Override
    public void setup() {
        IPolymorphCommon commonApi = PolymorphApi.common();
        commonApi.registerTileEntity2RecipeData(pTileEntity -> {
            if (pTileEntity instanceof GridTile) {
                return new GridTileRecipeData((GridTile)pTileEntity);
            }
            return null;
        });
        commonApi.registerContainer2TileEntity(pContainer -> {
            IGrid grid;
            if (pContainer instanceof GridContainer && (grid = ((GridContainer)pContainer).getGrid()) instanceof GridNetworkNode) {
                GridNetworkNode gridNetworkNode = (GridNetworkNode)grid;
                return gridNetworkNode.getWorld().func_175625_s(gridNetworkNode.getPos());
            }
            return null;
        });
    }

    @Override
    public boolean selectRecipe(TileEntity tileEntity, IRecipe<?> recipe) {
        IGrid grid;
        if (recipe instanceof ICraftingRecipe && tileEntity instanceof GridTile && (grid = (IGrid)((GridTile)tileEntity).getNode()) instanceof GridNetworkNode) {
            ((AccessorGrid)grid).setCurrentRecipe((ICraftingRecipe)recipe);
            grid.onCraftingMatrixChanged();
            return true;
        }
        return false;
    }

    public static <C extends IInventory, T extends IRecipe<C>> Optional<T> getRecipe(IRecipeType<T> type, C inventory, World world, BlockPos pos, int ticks) {
        TileEntity te;
        if (pos != null && ticks > 1 && (te = world.func_175625_s(pos)) != null) {
            return RecipeSelection.getTileEntityRecipe(type, inventory, world, te);
        }
        return world.func_199532_z().func_215371_a(type, inventory, world);
    }

    public static void appendPattern(boolean exactPattern, ItemStack stack, World world, BlockPos pos, int ticks) {
        if (exactPattern) {
            TileEntity te;
            CompoundNBT tag = stack.func_77978_p();
            if (tag == null) {
                stack.func_77982_d(new CompoundNBT());
            }
            if (world != null && pos != null && ticks > 1 && (te = world.func_175625_s(pos)) instanceof GridTile) {
                Optional<ICraftingRecipe> recipe = RecipeSelection.getTileEntityRecipe(IRecipeType.field_222149_a, ((GridNetworkNode)((GridTile)te).getNode()).getCraftingMatrix(), world, te);
                recipe.ifPresent(rec -> stack.func_77978_p().func_74778_a("PolymorphRecipe", rec.func_199560_c().toString()));
            }
        }
    }

    public static <T extends IRecipe<C>, C extends IInventory> Optional<T> getPatternRecipe(ItemStack stack, IRecipeType<T> type, C inventory, World world) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null) {
            String id = tag.func_74779_i("PolymorphRecipe");
            Optional opt = world.func_199532_z().func_215367_a(new ResourceLocation(id));
            if (opt.isPresent()) {
                return opt;
            }
        }
        return world.func_199532_z().func_215371_a(type, inventory, world);
    }

    public static <T extends IRecipe<C>, C extends IInventory> Optional<T> getWirelessRecipe(RecipeManager unused, IRecipeType<T> type, C inventory, World world, ICraftingGridListener listener) {
        if (listener instanceof GridContainer) {
            GridContainer container = (GridContainer)listener;
            return RecipeSelection.getPlayerRecipe(type, inventory, world, container.getPlayer());
        }
        return world.func_199532_z().func_215371_a(type, inventory, world);
    }
}

