/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.common.world.gen.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class StonePillarFeature
extends Feature<NoFeatureConfig> {
    public StonePillarFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader worldIn, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig configIn) {
        if (worldIn.func_175623_d(pos) && !worldIn.func_175623_d(pos.func_177984_a())) {
            BlockPos.Mutable oldPos = pos.func_239590_i_();
            BlockPos.Mutable newPos = pos.func_239590_i_();
            boolean north = true;
            boolean south = true;
            boolean west = true;
            boolean east = true;
            while (StonePillarFeature.isEmptyOrWaterOrLava((IWorld)worldIn, (BlockPos)oldPos)) {
                if (World.func_189509_E((BlockPos)oldPos)) {
                    return true;
                }
                worldIn.func_180501_a((BlockPos)oldPos, Blocks.field_150484_ah.func_176223_P(), 2);
                north = north && this.stopOrPlaceStone((IWorld)worldIn, rand, (BlockPos)newPos.func_239622_a_((Vector3i)oldPos, Direction.NORTH));
                south = south && this.stopOrPlaceStone((IWorld)worldIn, rand, (BlockPos)newPos.func_239622_a_((Vector3i)oldPos, Direction.SOUTH));
                west = west && this.stopOrPlaceStone((IWorld)worldIn, rand, (BlockPos)newPos.func_239622_a_((Vector3i)oldPos, Direction.WEST));
                east = east && this.stopOrPlaceStone((IWorld)worldIn, rand, (BlockPos)newPos.func_239622_a_((Vector3i)oldPos, Direction.EAST));
                oldPos.func_189536_c(Direction.DOWN);
            }
            oldPos.func_189536_c(Direction.UP);
            this.tryPlacingStone((IWorld)worldIn, rand, (BlockPos)newPos.func_239622_a_((Vector3i)oldPos, Direction.NORTH));
            this.tryPlacingStone((IWorld)worldIn, rand, (BlockPos)newPos.func_239622_a_((Vector3i)oldPos, Direction.SOUTH));
            this.tryPlacingStone((IWorld)worldIn, rand, (BlockPos)newPos.func_239622_a_((Vector3i)oldPos, Direction.WEST));
            this.tryPlacingStone((IWorld)worldIn, rand, (BlockPos)newPos.func_239622_a_((Vector3i)oldPos, Direction.EAST));
            oldPos.func_189536_c(Direction.UP);
            BlockPos.Mutable mutable = new BlockPos.Mutable();
            for (int x = -3; x < 4; ++x) {
                for (int z = -3; z < 4; ++z) {
                    int radius = MathHelper.func_76130_a((int)x) * MathHelper.func_76130_a((int)z);
                    if (rand.nextInt(10) >= 10 - radius) continue;
                    mutable.func_189533_g((Vector3i)oldPos.func_177982_a(x, 0, z));
                    int index = 3;
                    while (StonePillarFeature.isEmptyOrWaterOrLava((IWorld)worldIn, (BlockPos)newPos.func_239622_a_((Vector3i)mutable, Direction.DOWN))) {
                        mutable.func_189536_c(Direction.DOWN);
                        if (--index > 0) continue;
                    }
                }
            }
            return true;
        }
        return false;
    }

    private void tryPlacingStone(IWorld worldIn, Random rand, BlockPos pos) {
        if (rand.nextInt(10) != 0) {
            BlockPos.Mutable pos1 = pos.func_239590_i_();
            worldIn.func_180501_a((BlockPos)pos1, Blocks.field_150484_ah.func_176223_P(), 2);
            worldIn.func_180501_a(pos1.func_177976_e(), Blocks.field_150475_bE.func_176223_P(), 2);
            worldIn.func_180501_a(pos1.func_177974_f(), Blocks.field_150475_bE.func_176223_P(), 2);
            worldIn.func_180501_a(pos1.func_177978_c(), Blocks.field_150475_bE.func_176223_P(), 2);
            worldIn.func_180501_a(pos1.func_177968_d(), Blocks.field_150475_bE.func_176223_P(), 2);
            worldIn.func_180501_a(pos1.func_177984_a(), Blocks.field_150475_bE.func_176223_P(), 2);
            worldIn.func_180501_a(pos1.func_177981_b(2), Blocks.field_150475_bE.func_176223_P(), 2);
            worldIn.func_180501_a(pos1.func_177981_b(3), Blocks.field_150475_bE.func_176223_P(), 2);
            worldIn.func_180501_a(pos1.func_177981_b(4), Blocks.field_150475_bE.func_176223_P(), 2);
        }
    }

    private boolean stopOrPlaceStone(IWorld worldIn, Random rand, BlockPos pos) {
        if (rand.nextInt(5) != 0) {
            BlockPos.Mutable pos1 = pos.func_239590_i_();
            worldIn.func_180501_a((BlockPos)pos1, Blocks.field_150484_ah.func_176223_P(), 2);
            worldIn.func_180501_a(pos1.func_177976_e(), Blocks.field_150339_S.func_176223_P(), 2);
            worldIn.func_180501_a(pos1.func_177974_f(), Blocks.field_150339_S.func_176223_P(), 2);
            worldIn.func_180501_a(pos1.func_177978_c(), Blocks.field_150339_S.func_176223_P(), 2);
            worldIn.func_180501_a(pos1.func_177968_d(), Blocks.field_150339_S.func_176223_P(), 2);
            return true;
        }
        return false;
    }

    public static boolean isEmptyOrWaterOrLava(IWorld worldIn, BlockPos pos) {
        return worldIn.func_175623_d(pos) || worldIn.func_180495_p(pos).func_203425_a(Blocks.field_150355_j) || worldIn.func_180495_p(pos).func_203425_a(Blocks.field_150353_l);
    }
}

