/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.common.math;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.naterbobber.darkerdepths.common.math.IntProvider;
import com.naterbobber.darkerdepths.common.math.IntProviderType;
import com.naterbobber.darkerdepths.core.util.helpers.MathUtils;
import java.util.Random;
import java.util.function.Function;

public class UniformIntProvider
extends IntProvider {
    public static final Codec<UniformIntProvider> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("min_inclusive").forGetter(config -> config.min), (App)Codec.INT.fieldOf("max_inclusive").forGetter(config -> config.max)).apply((Applicative)instance, UniformIntProvider::new)).comapFlatMap(config -> config.max < config.min ? DataResult.error((String)("Max must be at least min, min_inclusive: " + config.min + ", max_inclusive: " + config.max)) : DataResult.success((Object)config), Function.identity());
    private final int min;
    private final int max;

    private UniformIntProvider(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public static UniformIntProvider create(int min, int max) {
        return new UniformIntProvider(min, max);
    }

    @Override
    public int get(Random rand) {
        return MathUtils.nextBetween(rand, this.min, this.max);
    }

    @Override
    public int getMin() {
        return this.min;
    }

    @Override
    public int getMax() {
        return this.max;
    }

    @Override
    public IntProviderType<?> getType() {
        return IntProviderType.UNIFORM;
    }

    public String toString() {
        return "[" + this.min + '-' + (this.min + this.max) + ']';
    }
}

