/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.common.blocks;

import com.naterbobber.darkerdepths.core.registries.DDTileEntities;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class GeyserBlock
extends Block {
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;

    public GeyserBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(context.func_195991_k().func_175640_z(context.func_195995_a())));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)DDTileEntities.GEYSER.get()).func_200968_a();
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean isPowered;
        if (!worldIn.field_72995_K && (isPowered = ((Boolean)state.func_177229_b((Property)POWERED)).booleanValue()) != worldIn.func_175640_z(pos)) {
            if (isPowered) {
                worldIn.func_205220_G_().func_205360_a(pos, (Object)this, 4);
            } else {
                worldIn.func_180501_a(pos, (BlockState)state.func_235896_a_((Property)POWERED), 2);
            }
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (((Boolean)state.func_177229_b((Property)POWERED)).booleanValue() && !worldIn.func_175640_z(pos)) {
            worldIn.func_180501_a(pos, (BlockState)state.func_235896_a_((Property)POWERED), 2);
        }
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        int xPos = pos.func_177958_n();
        int yPos = pos.func_177956_o();
        int zPos = pos.func_177952_p();
        double x = (double)xPos + 0.5;
        double y = (double)yPos + rand.nextDouble() + rand.nextDouble();
        double z = (double)zPos + 0.5;
        if (!((Boolean)stateIn.func_177229_b((Property)POWERED)).booleanValue()) {
            this.addParticle(worldIn, rand, x, y, z, pos, worldIn.func_180495_p(pos.func_177984_a()).func_203425_a(Blocks.field_150355_j));
        }
    }

    private void addParticle(World worldIn, Random rand, double x, double y, double z, BlockPos pos, boolean waterlogged) {
        if (waterlogged) {
            for (int i = 1; i < 7; ++i) {
                if (!worldIn.func_175623_d(pos.func_177981_b(i))) continue;
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_218417_ae, x, y, z, 0.0, 0.07, 0.0);
            }
            worldIn.func_195589_b((IParticleData)ParticleTypes.field_203220_f, x, y, z, 0.0, 0.04, 0.0);
            worldIn.func_195589_b((IParticleData)ParticleTypes.field_203220_f, x + (double)rand.nextFloat(), y + (double)rand.nextFloat(), z + (double)rand.nextFloat(), 0.0, 0.04, 0.0);
            if (rand.nextInt(200) == 0) {
                worldIn.func_184134_a(x, y, z, SoundEvents.field_203251_S, SoundCategory.BLOCKS, 0.2f + rand.nextFloat() * 0.2f, 0.9f + rand.nextFloat() * 0.15f, false);
            }
        } else {
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_218417_ae, x, y, z, 0.0, 0.07, 0.0);
            if (rand.nextInt(5) == 0) {
                for (int i = 0; i < rand.nextInt(1) + 1; ++i) {
                    worldIn.func_195594_a((IParticleData)ParticleTypes.field_197595_F, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (double)(rand.nextFloat() / 2.0f), 5.0E-5, (double)(rand.nextFloat() / 2.0f));
                }
            }
        }
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.UP && facingState.func_203425_a(Blocks.field_150355_j)) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 20);
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        BlockPos blockpos = pos.func_177984_a();
        if (worldIn.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a)) {
            worldIn.func_184133_a(null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.8f);
            worldIn.func_195598_a((IParticleData)ParticleTypes.field_197594_E, (double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.25, (double)blockpos.func_177952_p() + 0.5, 8, 0.5, 0.25, 0.5, 0.0);
        }
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        worldIn.func_205220_G_().func_205360_a(pos, (Object)this, 1);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{POWERED});
    }
}

