/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.tileentity;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.registries.ForgeRegistries;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.tileentity.FramedTileEntity;

public class FramedFlowerPotTileEntity
extends FramedTileEntity {
    public static final ModelProperty<Block> FLOWER_BLOCK = new ModelProperty();
    private Block flowerBlock = Blocks.field_150350_a;

    public FramedFlowerPotTileEntity() {
        super((TileEntityType)FBContent.tileTypeFramedFlowerPot.get());
    }

    public void setFlowerBlock(Block flowerBlock) {
        if (flowerBlock != this.flowerBlock) {
            this.flowerBlock = flowerBlock;
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
        }
    }

    public boolean hasFlowerBlock() {
        return this.flowerBlock != Blocks.field_150350_a;
    }

    public Block getFlowerBlock() {
        return this.flowerBlock;
    }

    @Override
    public void addCamoDrops(List<ItemStack> drops) {
        super.addCamoDrops(drops);
        if (this.flowerBlock != Blocks.field_150350_a) {
            drops.add(new ItemStack((IItemProvider)this.flowerBlock));
        }
    }

    @Override
    protected void writeToDataPacket(CompoundNBT nbt) {
        super.writeToDataPacket(nbt);
        nbt.func_74778_a("flower", this.flowerBlock.getRegistryName().toString());
    }

    @Override
    protected boolean readFromDataPacket(CompoundNBT nbt) {
        boolean update;
        Block flower = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(nbt.func_74779_i("flower")));
        boolean bl = update = flower != this.flowerBlock;
        if (update) {
            this.flowerBlock = flower;
            this.getModelData().setData(FLOWER_BLOCK, (Object)flower);
        }
        return super.readFromDataPacket(nbt) || update;
    }

    @Override
    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        nbt.func_74778_a("flower", this.flowerBlock.getRegistryName().toString());
        return nbt;
    }

    @Override
    public void handleUpdateTag(BlockState state, CompoundNBT nbt) {
        super.handleUpdateTag(state, nbt);
        Block flower = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(nbt.func_74779_i("flower")));
        if (flower != this.flowerBlock) {
            this.flowerBlock = flower;
            this.getModelData().setData(FLOWER_BLOCK, (Object)flower);
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        nbt.func_74778_a("flower", this.flowerBlock.getRegistryName().toString());
        return super.func_189515_b(nbt);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.flowerBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(nbt.func_74779_i("flower")));
    }
}

