/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import xfacthd.framedblocks.common.block.IFramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.CornerType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.SlopeType;
import xfacthd.framedblocks.common.util.SideSkipPredicate;
import xfacthd.framedblocks.common.util.Utils;

public class SlopeSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(IBlockReader world, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        if (SideSkipPredicate.CTM.test(world, pos, state, adjState, side)) {
            return true;
        }
        if (!(adjState.func_177230_c() instanceof IFramedBlock)) {
            return false;
        }
        BlockType adjBlock = ((IFramedBlock)adjState.func_177230_c()).getBlockType();
        Direction dir = Utils.getBlockFacing(state);
        SlopeType type = Utils.getSlopeType(state);
        if (adjBlock == BlockType.FRAMED_SLOPE || adjBlock == BlockType.FRAMED_RAIL_SLOPE) {
            return this.testAgainstSlope(world, pos, dir, type, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_DOUBLE_SLOPE) {
            return this.testAgainstDoubleSlope(world, pos, dir, type, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_CORNER_SLOPE) {
            return this.testAgainstCorner(world, pos, dir, type, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_DOUBLE_CORNER) {
            return this.testAgainstDoubleCorner(world, pos, dir, type, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_DOUBLE_PRISM_CORNER || adjBlock == BlockType.FRAMED_DOUBLE_THREEWAY_CORNER) {
            return this.testAgainstDoubleThreewayCorner(world, pos, dir, type, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_INNER_CORNER_SLOPE) {
            return this.testAgainstInnerCorner(world, pos, dir, type, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_PRISM_CORNER || adjBlock == BlockType.FRAMED_THREEWAY_CORNER) {
            return this.testAgainstThreewayCorner(world, pos, dir, type, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_INNER_PRISM_CORNER || adjBlock == BlockType.FRAMED_INNER_THREEWAY_CORNER) {
            return this.testAgainstInnerThreewayCorner(world, pos, dir, type, adjBlock, adjState, side);
        }
        return false;
    }

    private boolean testAgainstSlope(IBlockReader world, BlockPos pos, Direction dir, SlopeType type, BlockState adjState, Direction side) {
        Direction adjDir = Utils.getBlockFacing(adjState);
        SlopeType adjType = Utils.getSlopeType(adjState);
        if (type == SlopeType.HORIZONTAL && side.func_176740_k() == Direction.Axis.Y) {
            return dir == adjDir && type == adjType && SideSkipPredicate.compareState(world, pos, side, dir);
        }
        if (type != SlopeType.HORIZONTAL && (side == dir.func_176746_e() || side == dir.func_176735_f())) {
            return dir == adjDir && type == adjType && SideSkipPredicate.compareState(world, pos, side, dir);
        }
        return false;
    }

    private boolean testAgainstDoubleSlope(IBlockReader world, BlockPos pos, Direction dir, SlopeType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        SlopeType adjType = (SlopeType)((Object)adjState.func_177229_b(PropertyHolder.SLOPE_TYPE));
        if (type == SlopeType.HORIZONTAL && adjType == SlopeType.HORIZONTAL && side.func_176740_k() == Direction.Axis.Y) {
            return (dir == adjDir || adjDir == dir.func_176734_d()) && SideSkipPredicate.compareState(world, pos, side, dir);
        }
        if (type != SlopeType.HORIZONTAL && adjType != SlopeType.HORIZONTAL && (side == dir.func_176746_e() || side == dir.func_176735_f())) {
            return dir == adjDir && type == adjType || dir.func_176734_d() == adjDir && type != adjType && SideSkipPredicate.compareState(world, pos, side, dir);
        }
        return false;
    }

    private boolean testAgainstCorner(IBlockReader world, BlockPos pos, Direction dir, SlopeType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.func_177229_b(PropertyHolder.CORNER_TYPE));
        if (side == dir.func_176746_e() && adjDir == dir) {
            if (type == SlopeType.BOTTOM && (adjType == CornerType.BOTTOM || adjType == CornerType.HORIZONTAL_BOTTOM_LEFT)) {
                return SideSkipPredicate.compareState(world, pos, side, dir);
            }
            if (type == SlopeType.TOP && (adjType == CornerType.TOP || adjType == CornerType.HORIZONTAL_TOP_LEFT)) {
                return SideSkipPredicate.compareState(world, pos, side, dir);
            }
        } else if (side == dir.func_176735_f()) {
            if (adjDir == dir) {
                if (type == SlopeType.BOTTOM && adjType == CornerType.HORIZONTAL_BOTTOM_RIGHT) {
                    return SideSkipPredicate.compareState(world, pos, side, dir);
                }
                if (type == SlopeType.TOP && adjType == CornerType.HORIZONTAL_TOP_RIGHT) {
                    return SideSkipPredicate.compareState(world, pos, side, dir);
                }
            } else if (adjDir == dir.func_176746_e()) {
                if (type == SlopeType.BOTTOM && adjType == CornerType.BOTTOM) {
                    return SideSkipPredicate.compareState(world, pos, side, dir);
                }
                if (type == SlopeType.TOP && adjType == CornerType.TOP) {
                    return SideSkipPredicate.compareState(world, pos, side, dir);
                }
            }
        } else if (side.func_176740_k() == Direction.Axis.Y && type == SlopeType.HORIZONTAL && side == Direction.UP != adjType.isTop()) {
            if (adjType.isRight()) {
                return dir == adjDir.func_176746_e() && SideSkipPredicate.compareState(world, pos, side, dir);
            }
            return dir == adjDir && SideSkipPredicate.compareState(world, pos, side, dir);
        }
        return false;
    }

    private boolean testAgainstDoubleCorner(IBlockReader world, BlockPos pos, Direction dir, SlopeType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.func_177229_b(PropertyHolder.CORNER_TYPE));
        if (adjType.isHorizontal()) {
            if (type == SlopeType.HORIZONTAL && (side == Direction.DOWN && !adjType.isTop() || side == Direction.UP && adjType.isTop())) {
                if (!(adjDir != dir && adjDir != dir.func_176734_d() || adjType.isRight())) {
                    return SideSkipPredicate.compareState(world, pos, side, dir);
                }
                if ((adjDir == dir.func_176746_e() || adjDir == dir.func_176735_f()) && adjType.isRight()) {
                    return SideSkipPredicate.compareState(world, pos, side, adjDir == dir.func_176746_e() ? adjDir.func_176734_d() : dir);
                }
            } else {
                if (type != SlopeType.HORIZONTAL && adjDir == dir && (side == dir.func_176735_f() && !adjType.isRight() || side == dir.func_176746_e() && adjType.isRight())) {
                    return type == SlopeType.TOP == adjType.isTop() && SideSkipPredicate.compareState(world, pos, side, dir);
                }
                if (type != SlopeType.HORIZONTAL && (side == dir.func_176746_e() && !adjType.isRight() || side == dir.func_176735_f() && adjType.isRight())) {
                    return adjDir == dir.func_176734_d() && type == SlopeType.TOP != adjType.isTop() && SideSkipPredicate.compareState(world, pos, side, dir);
                }
            }
        } else {
            if (side == dir.func_176735_f() && adjDir == dir || side == dir.func_176746_e() && adjDir == dir.func_176746_e()) {
                return type == SlopeType.TOP == adjType.isTop() && SideSkipPredicate.compareState(world, pos, side, dir);
            }
            if (side == dir.func_176746_e() && adjDir == dir.func_176734_d() || side == dir.func_176735_f() && adjDir == dir.func_176735_f()) {
                Direction face = adjType.isTop() ? Direction.DOWN : Direction.UP;
                return type == SlopeType.TOP != adjType.isTop() && SideSkipPredicate.compareState(world, pos, side, face);
            }
        }
        return false;
    }

    private boolean testAgainstDoubleThreewayCorner(IBlockReader world, BlockPos pos, Direction dir, SlopeType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        if (type != SlopeType.HORIZONTAL) {
            if (type == SlopeType.TOP == adjTop && (side == dir.func_176735_f() && adjDir == dir || side == dir.func_176746_e() && adjDir == dir.func_176746_e())) {
                return SideSkipPredicate.compareState(world, pos, side, dir);
            }
            if (type == SlopeType.TOP != adjTop && (side == dir.func_176735_f() && adjDir == dir.func_176735_f() || side == dir.func_176746_e() && adjDir == dir.func_176734_d())) {
                return SideSkipPredicate.compareState(world, pos, side, dir);
            }
        } else if ((adjDir == dir || adjDir == dir.func_176734_d()) && (side == Direction.DOWN && !adjTop || side == Direction.UP && adjTop)) {
            return SideSkipPredicate.compareState(world, pos, side, dir);
        }
        return false;
    }

    private boolean testAgainstInnerCorner(IBlockReader world, BlockPos pos, Direction dir, SlopeType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.func_177229_b(PropertyHolder.CORNER_TYPE));
        if (side == dir.func_176746_e() && adjDir == dir) {
            if (type == SlopeType.BOTTOM && (adjType == CornerType.BOTTOM || adjType == CornerType.HORIZONTAL_BOTTOM_RIGHT)) {
                return SideSkipPredicate.compareState(world, pos, side, dir);
            }
            if (type == SlopeType.TOP && (adjType == CornerType.TOP || adjType == CornerType.HORIZONTAL_TOP_RIGHT)) {
                return SideSkipPredicate.compareState(world, pos, side, dir);
            }
        } else if (side == dir.func_176735_f()) {
            if (adjDir == dir) {
                if (type == SlopeType.BOTTOM && adjType == CornerType.HORIZONTAL_BOTTOM_LEFT) {
                    return SideSkipPredicate.compareState(world, pos, side, dir);
                }
                if (type == SlopeType.TOP && adjType == CornerType.HORIZONTAL_TOP_LEFT) {
                    return SideSkipPredicate.compareState(world, pos, side, dir);
                }
            } else if (adjDir == dir.func_176735_f()) {
                if (type == SlopeType.BOTTOM && adjType == CornerType.BOTTOM) {
                    return SideSkipPredicate.compareState(world, pos, side, dir);
                }
                if (type == SlopeType.TOP && adjType == CornerType.TOP) {
                    return SideSkipPredicate.compareState(world, pos, side, dir);
                }
            }
        } else if (side.func_176740_k() == Direction.Axis.Y && type == SlopeType.HORIZONTAL && side == Direction.UP == adjType.isTop()) {
            if (adjType.isRight()) {
                return dir == adjDir.func_176746_e() && SideSkipPredicate.compareState(world, pos, side, dir);
            }
            return dir == adjDir && SideSkipPredicate.compareState(world, pos, side, dir);
        }
        return false;
    }

    private boolean testAgainstThreewayCorner(IBlockReader world, BlockPos pos, Direction dir, SlopeType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        if (type != SlopeType.HORIZONTAL && adjTop == (type == SlopeType.TOP)) {
            if (side == dir.func_176746_e()) {
                return dir == adjDir && SideSkipPredicate.compareState(world, pos, side, dir);
            }
            if (side == dir.func_176735_f()) {
                return adjDir == dir.func_176746_e() && SideSkipPredicate.compareState(world, pos, side, dir);
            }
        } else if (type == SlopeType.HORIZONTAL && side.func_176740_k() == Direction.Axis.Y && adjTop == (side == Direction.DOWN)) {
            return dir == adjDir && SideSkipPredicate.compareState(world, pos, side, dir);
        }
        return false;
    }

    private boolean testAgainstInnerThreewayCorner(IBlockReader world, BlockPos pos, Direction dir, SlopeType type, BlockType adjBlock, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        if (adjBlock == BlockType.FRAMED_INNER_THREEWAY_CORNER) {
            adjDir = adjDir.func_176746_e();
        }
        if (type != SlopeType.HORIZONTAL && adjTop == (type == SlopeType.TOP)) {
            if (side == dir.func_176746_e()) {
                return adjDir == dir.func_176746_e() && SideSkipPredicate.compareState(world, pos, side, dir);
            }
            if (side == dir.func_176735_f()) {
                return dir == adjDir && SideSkipPredicate.compareState(world, pos, side, dir);
            }
        } else if (type == SlopeType.HORIZONTAL && side.func_176740_k() == Direction.Axis.Y && adjTop == (side == Direction.UP)) {
            return dir == adjDir && SideSkipPredicate.compareState(world, pos, side, dir);
        }
        return false;
    }
}

