/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import xfacthd.framedblocks.common.block.IFramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.CornerType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.SlopeType;
import xfacthd.framedblocks.common.util.SideSkipPredicate;
import xfacthd.framedblocks.common.util.Utils;

public class InnerCornerSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(IBlockReader world, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        if (SideSkipPredicate.CTM.test(world, pos, state, adjState, side)) {
            return true;
        }
        if (!(adjState.func_177230_c() instanceof IFramedBlock)) {
            return false;
        }
        BlockType adjBlock = ((IFramedBlock)adjState.func_177230_c()).getBlockType();
        Direction dir = (Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR);
        CornerType type = (CornerType)((Object)state.func_177229_b(PropertyHolder.CORNER_TYPE));
        if (adjBlock == BlockType.FRAMED_INNER_CORNER_SLOPE) {
            return this.testAgainstInnerCorner(world, pos, dir, type, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_CORNER_SLOPE) {
            return this.testAgainstCorner(world, pos, dir, type, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_DOUBLE_CORNER) {
            return this.testAgainstDoubleCorner(world, pos, dir, type, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_SLOPE || adjBlock == BlockType.FRAMED_RAIL_SLOPE) {
            return this.testAgainstSlope(world, pos, dir, type, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_DOUBLE_SLOPE) {
            return this.testAgainstDoubleSlope(world, pos, dir, type, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_PRISM_CORNER || adjBlock == BlockType.FRAMED_THREEWAY_CORNER) {
            return this.testAgainstThreewaySlope(world, pos, dir, type, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_INNER_PRISM_CORNER || adjBlock == BlockType.FRAMED_INNER_THREEWAY_CORNER) {
            return this.testAgainstInnerThreewaySlope(world, pos, dir, type, adjBlock, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_DOUBLE_PRISM_CORNER || adjBlock == BlockType.FRAMED_DOUBLE_THREEWAY_CORNER) {
            return this.testAgainstDoubleThreewayCorner(world, pos, dir, type, adjState, side);
        }
        return false;
    }

    private boolean testAgainstInnerCorner(IBlockReader world, BlockPos pos, Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.func_177229_b(PropertyHolder.CORNER_TYPE));
        if (!type.isHorizontal() && adjType == type && (side == dir.func_176734_d() && adjDir == dir.func_176746_e() || side == dir.func_176735_f() && adjDir == dir.func_176735_f())) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        if (type.isHorizontal() && type.isHorizontalAdjacentInner(dir, side, adjType) && adjDir == dir) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        if (!type.isHorizontal() && adjType.isHorizontal() && adjType.isTop() == type.isTop() && (side == dir.func_176734_d() && adjType.isRight() && adjDir == dir.func_176746_e() || side == dir.func_176735_f() && !adjType.isRight() && adjDir == dir)) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        if (type.isHorizontal() && !adjType.isHorizontal() && adjType.isTop() == type.isTop() && (!type.isRight() && side == dir.func_176746_e() && adjDir == dir || type.isRight() && side == dir.func_176735_f() && adjDir == dir.func_176735_f())) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private boolean testAgainstCorner(IBlockReader world, BlockPos pos, Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.func_177229_b(PropertyHolder.CORNER_TYPE));
        if (!type.isHorizontal() && !adjType.isHorizontal() && adjDir == dir.func_176746_e() && adjType.isTop() == type.isTop()) {
            return (side == dir.func_176734_d() || side == dir.func_176735_f()) && SideSkipPredicate.compareState(world, pos, side);
        }
        if (type.isHorizontal() && adjType == type && adjDir == dir && (side == Direction.UP && !type.isTop() || side == Direction.DOWN && type.isTop() || side == dir.func_176746_e() && !type.isRight() || side == dir.func_176735_f() && type.isRight())) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        if (!type.isHorizontal() && adjType.isHorizontal() && adjType.isTop() == type.isTop() && (side == dir.func_176734_d() && !adjType.isRight() && adjDir == dir.func_176746_e() || side == dir.func_176735_f() && adjType.isRight() && adjDir == dir)) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        if (type.isHorizontal() && !adjType.isHorizontal() && adjType.isTop() == type.isTop() && (!type.isRight() && side == dir.func_176746_e() && adjDir == dir || type.isRight() && side == dir.func_176735_f() && adjDir == dir.func_176746_e())) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private boolean testAgainstDoubleCorner(IBlockReader world, BlockPos pos, Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.func_177229_b(PropertyHolder.CORNER_TYPE));
        if (!type.isHorizontal() && !adjType.isHorizontal()) {
            if (type.isTop() == adjType.isTop() && (side == dir.func_176734_d() && adjDir == dir.func_176734_d() || side == dir.func_176735_f() && adjDir == dir)) {
                return SideSkipPredicate.compareState(world, pos, side, type.isTop() ? Direction.UP : Direction.DOWN);
            }
            if (type.isTop() != adjType.isTop() && adjDir == dir.func_176735_f() && (side == dir.func_176734_d() || side == dir.func_176735_f())) {
                return SideSkipPredicate.compareState(world, pos, side, type.isTop() ? Direction.UP : Direction.DOWN);
            }
        } else if (type.isHorizontal() && !adjType.isHorizontal()) {
            if (type.isTop() == adjType.isTop() && (side == dir.func_176735_f() && adjDir == dir && type.isRight() || side == dir.func_176746_e() && adjDir == dir.func_176746_e() && !type.isRight())) {
                return SideSkipPredicate.compareState(world, pos, side, type.isTop() ? Direction.UP : Direction.DOWN);
            }
            if (type.isTop() != adjType.isTop() && (side == dir.func_176746_e() && adjDir == dir.func_176734_d() && !type.isRight() || side == dir.func_176735_f() && adjDir == dir.func_176735_f() && type.isRight())) {
                return SideSkipPredicate.compareState(world, pos, side, type.isTop() ? Direction.UP : Direction.DOWN);
            }
        } else if (!type.isHorizontal()) {
            if (type.isTop() == adjType.isTop() && (side == dir.func_176734_d() && adjDir == dir.func_176746_e() && adjType.isRight() || side == dir.func_176735_f() && adjDir == dir && !adjType.isRight())) {
                return SideSkipPredicate.compareState(world, pos, side, adjDir);
            }
            if (type.isTop() != adjType.isTop() && (side == dir.func_176734_d() && adjDir == dir.func_176735_f() && !adjType.isRight() || side == dir.func_176735_f() && adjDir == dir.func_176734_d() && adjType.isRight())) {
                return SideSkipPredicate.compareState(world, pos, side, adjDir.func_176734_d());
            }
        } else if (adjDir == dir) {
            if (type.isRight() == adjType.isRight() && (side == Direction.UP && !type.isTop() && adjType.isTop() || side == Direction.DOWN && type.isTop() && !adjType.isTop())) {
                return SideSkipPredicate.compareState(world, pos, side, dir);
            }
            if (type.isTop() == adjType.isTop() && (side == dir.func_176746_e() && !type.isRight() && adjType.isRight() || side == dir.func_176735_f() && type.isRight() && !adjType.isRight())) {
                return SideSkipPredicate.compareState(world, pos, side, dir);
            }
        } else if (adjDir == dir.func_176734_d()) {
            if (type.isRight() == adjType.isRight() && (side == Direction.UP && !type.isTop() && adjType.isTop() || side == Direction.DOWN && type.isTop() && !adjType.isTop())) {
                return SideSkipPredicate.compareState(world, pos, side, dir);
            }
            if (type.isRight() == adjType.isRight() && type.isTop() != adjType.isTop() && (side == dir.func_176735_f() && type.isRight() || side == dir.func_176746_e() && !type.isRight())) {
                return SideSkipPredicate.compareState(world, pos, side, dir);
            }
        }
        return false;
    }

    private boolean testAgainstSlope(IBlockReader world, BlockPos pos, Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = Utils.getBlockFacing(adjState);
        SlopeType adjType = Utils.getSlopeType(adjState);
        if (!type.isHorizontal() && adjType != SlopeType.HORIZONTAL && (side == dir.func_176734_d() && adjDir == dir.func_176746_e() || side == adjDir.func_176735_f() && adjDir == dir)) {
            return adjType == SlopeType.TOP == type.isTop() && SideSkipPredicate.compareState(world, pos, side);
        }
        if (type.isHorizontal()) {
            if ((side == Direction.UP && !type.isTop() || side == Direction.DOWN && type.isTop()) && adjType == SlopeType.HORIZONTAL) {
                return (!type.isRight() && adjDir == dir || type.isRight() && adjDir == dir.func_176746_e()) && SideSkipPredicate.compareState(world, pos, side);
            }
            if (side.func_176740_k() != Direction.Axis.Y && adjDir == dir && adjType == SlopeType.TOP == type.isTop()) {
                return (!type.isRight() && side == dir.func_176746_e() || type.isRight() && side == dir.func_176735_f()) && SideSkipPredicate.compareState(world, pos, side);
            }
        }
        return false;
    }

    private boolean testAgainstDoubleSlope(IBlockReader world, BlockPos pos, Direction dir, CornerType type, BlockState adjState, Direction side) {
        boolean adjTop;
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        SlopeType adjType = (SlopeType)((Object)adjState.func_177229_b(PropertyHolder.SLOPE_TYPE));
        boolean bl = adjTop = adjType == SlopeType.TOP;
        if (!type.isHorizontal() && adjType != SlopeType.HORIZONTAL && (side == dir.func_176734_d() && type.isTop() == adjTop && adjDir == dir.func_176746_e() || side == dir.func_176734_d() && type.isTop() != adjTop && adjDir == dir.func_176735_f() || side == dir.func_176735_f() && type.isTop() == adjTop && adjDir == dir || side == dir.func_176735_f() && type.isTop() != adjTop && adjDir == dir.func_176734_d())) {
            Direction face = type.isTop() == adjTop ? adjDir : adjDir.func_176734_d();
            return SideSkipPredicate.compareState(world, pos, side, face);
        }
        if (type.isHorizontal() && adjType == SlopeType.HORIZONTAL && (side == Direction.UP && !type.isTop() || side == Direction.DOWN && type.isTop())) {
            if (!type.isRight() && (adjDir == dir || adjDir == dir.func_176734_d()) || type.isRight() && (adjDir == dir.func_176746_e() || adjDir == dir.func_176735_f())) {
                return SideSkipPredicate.compareState(world, pos, side, dir);
            }
        } else if (type.isHorizontal() && adjType != SlopeType.HORIZONTAL && (side == dir.func_176746_e() && !type.isRight() || side == dir.func_176735_f() && type.isRight())) {
            Direction face = type.isTop() == adjTop ? adjDir : adjDir.func_176734_d();
            return (type.isTop() == adjTop && adjDir == dir || type.isTop() != adjTop && adjDir == dir.func_176734_d()) && SideSkipPredicate.compareState(world, pos, side, face);
        }
        return false;
    }

    private boolean testAgainstThreewaySlope(IBlockReader world, BlockPos pos, Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        if (!(type.isHorizontal() || adjDir != dir.func_176746_e() || adjTop != type.isTop() || side != dir.func_176734_d() && side != dir.func_176735_f())) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        if (type.isHorizontal() && (!type.isRight() && adjDir == dir || type.isRight() && adjDir == dir.func_176746_e()) && adjTop == type.isTop() && (side == Direction.UP && !type.isTop() || side == Direction.DOWN && type.isTop() || side == dir.func_176746_e() && !type.isRight() || side == dir.func_176735_f() && type.isRight())) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private boolean testAgainstInnerThreewaySlope(IBlockReader world, BlockPos pos, Direction dir, CornerType type, BlockType adjBlock, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        if (adjBlock == BlockType.FRAMED_INNER_THREEWAY_CORNER) {
            adjDir = adjDir.func_176746_e();
        }
        if (!type.isHorizontal() && adjTop == type.isTop() && (side == dir.func_176734_d() && adjDir == dir.func_176734_d() || side == dir.func_176735_f() && adjDir == dir)) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        if (type.isHorizontal()) {
            if (adjTop != type.isTop() && (adjDir == dir && !type.isRight() || adjDir == dir.func_176746_e() && type.isRight()) && (!type.isTop() && side == Direction.UP || type.isTop() && side == Direction.DOWN)) {
                return SideSkipPredicate.compareState(world, pos, side, dir);
            }
            if (adjTop == type.isTop() && (!type.isRight() && side == dir.func_176746_e() && adjDir == dir.func_176746_e() || type.isRight() && side == dir.func_176735_f() && adjDir == dir)) {
                return SideSkipPredicate.compareState(world, pos, side, dir);
            }
        }
        return false;
    }

    private boolean testAgainstDoubleThreewayCorner(IBlockReader world, BlockPos pos, Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        if (!type.isHorizontal()) {
            if (adjTop == type.isTop() && (side == dir.func_176735_f() && adjDir == dir || side == dir.func_176734_d() && adjDir == dir.func_176734_d())) {
                return SideSkipPredicate.compareState(world, pos, side, adjTop ? Direction.UP : Direction.DOWN);
            }
            if (adjTop != type.isTop() && adjDir == dir.func_176735_f() && (side == dir.func_176734_d() || side == dir.func_176735_f())) {
                return SideSkipPredicate.compareState(world, pos, side, type.isTop() ? Direction.UP : Direction.DOWN);
            }
        } else {
            if (adjTop == type.isTop() && (side == dir.func_176735_f() && adjDir == dir && type.isRight() || side == dir.func_176746_e() && adjDir == dir.func_176746_e() && !type.isRight())) {
                return SideSkipPredicate.compareState(world, pos, side, dir);
            }
            if (adjTop != type.isTop() && (side == dir.func_176746_e() && adjDir == dir.func_176734_d() && !type.isRight() || side == dir.func_176735_f() && adjDir == dir.func_176735_f() && type.isRight())) {
                return SideSkipPredicate.compareState(world, pos, side, dir);
            }
            if (adjTop != type.isTop() && (side == Direction.UP && !type.isTop() || side == Direction.DOWN && type.isTop()) && (!type.isRight() && (adjDir == dir || adjDir == dir.func_176734_d()) || type.isRight() && (adjDir == dir.func_176746_e() || adjDir == dir.func_176735_f()))) {
                return SideSkipPredicate.compareState(world, pos, side, dir);
            }
        }
        return false;
    }
}

