/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.util.CtmPredicate;
import xfacthd.framedblocks.common.util.SideSkipPredicate;
import xfacthd.framedblocks.common.util.Utils;

public class FramedSlopedPrismBlock
extends FramedBlock {
    public static final CtmPredicate CTM_PREDICATE = (state, side) -> side == ((Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H)).func_176734_d();
    public static final SideSkipPredicate SKIP_PREDICATE = (level, pos, state, adjState, side) -> {
        Direction facing = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H);
        Direction orientation = (Direction)state.func_177229_b((Property)PropertyHolder.ORIENTATION);
        if (side != orientation) {
            return false;
        }
        if (adjState.func_203425_a((Block)FBContent.blockFramedSlopedPrism.get())) {
            Direction adjFacing = (Direction)adjState.func_177229_b((Property)BlockStateProperties.field_208155_H);
            Direction adjOrientation = (Direction)adjState.func_177229_b((Property)PropertyHolder.ORIENTATION);
            return adjFacing == facing && adjOrientation == orientation.func_176734_d() && SideSkipPredicate.compareState(level, pos, side);
        }
        if (adjState.func_203425_a((Block)FBContent.blockFramedPrism.get())) {
            Direction.Axis adjAxis = (Direction.Axis)adjState.func_177229_b((Property)BlockStateProperties.field_208148_A);
            Direction adjFacing = (Direction)adjState.func_177229_b((Property)BlockStateProperties.field_208155_H);
            return adjFacing == facing && adjAxis == orientation.func_176740_k() && SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    };

    public FramedSlopedPrismBlock() {
        super(BlockType.FRAMED_SLOPED_PRISM);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)PropertyHolder.SOLID, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208155_H, PropertyHolder.ORIENTATION, BlockStateProperties.field_208198_y, PropertyHolder.SOLID, PropertyHolder.GLOWING});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction orientation;
        BlockState state = this.func_176223_P();
        Direction face = context.func_196000_l();
        state = (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)face);
        if (face.func_176740_k() == Direction.Axis.Y) {
            orientation = context.func_195992_f();
        } else {
            Vector3d subHit = Utils.fraction(context.func_221532_j());
            double xz = (face.func_176740_k() == Direction.Axis.X ? subHit.func_82616_c() : subHit.func_82615_a()) - 0.5;
            double y = subHit.func_82617_b() - 0.5;
            orientation = Math.max(Math.abs(xz), Math.abs(y)) == Math.abs(xz) ? (face.func_176740_k() == Direction.Axis.X ? (xz < 0.0 ? Direction.SOUTH : Direction.NORTH) : (xz < 0.0 ? Direction.EAST : Direction.WEST)) : (y < 0.0 ? Direction.UP : Direction.DOWN);
        }
        state = (BlockState)state.func_206870_a((Property)PropertyHolder.ORIENTATION, (Comparable)orientation);
        return this.withWater(state, (IWorldReader)context.func_195991_k(), context.func_195995_a());
    }

    public static ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape shapeBottom = VoxelShapes.func_216384_a((VoxelShape)FramedSlopedPrismBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedSlopedPrismBlock.func_208617_a((double)0.5, (double)0.0, (double)0.0, (double)15.5, (double)4.0, (double)15.5), FramedSlopedPrismBlock.func_208617_a((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)8.0, (double)12.0)}).func_197753_c();
        VoxelShape shapeTop = VoxelShapes.func_216384_a((VoxelShape)FramedSlopedPrismBlock.func_208617_a((double)0.0, (double)15.5, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedSlopedPrismBlock.func_208617_a((double)0.5, (double)12.0, (double)0.0, (double)15.5, (double)16.0, (double)15.5), FramedSlopedPrismBlock.func_208617_a((double)4.0, (double)8.0, (double)0.0, (double)12.0, (double)16.0, (double)12.0)}).func_197753_c();
        VoxelShape shapeRight = VoxelShapes.func_216384_a((VoxelShape)FramedSlopedPrismBlock.func_208617_a((double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedSlopedPrismBlock.func_208617_a((double)0.0, (double)0.5, (double)12.0, (double)15.5, (double)15.5, (double)16.0), FramedSlopedPrismBlock.func_208617_a((double)0.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0, (double)16.0)}).func_197753_c();
        VoxelShape shapeLeft = VoxelShapes.func_216384_a((VoxelShape)FramedSlopedPrismBlock.func_208617_a((double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedSlopedPrismBlock.func_208617_a((double)0.5, (double)0.5, (double)12.0, (double)16.0, (double)15.5, (double)16.0), FramedSlopedPrismBlock.func_208617_a((double)4.0, (double)4.0, (double)8.0, (double)16.0, (double)12.0, (double)16.0)}).func_197753_c();
        VoxelShape shapeUp = VoxelShapes.func_216384_a((VoxelShape)FramedSlopedPrismBlock.func_208617_a((double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedSlopedPrismBlock.func_208617_a((double)0.5, (double)0.5, (double)12.0, (double)15.5, (double)16.0, (double)16.0), FramedSlopedPrismBlock.func_208617_a((double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)16.0, (double)16.0)}).func_197753_c();
        VoxelShape shapeDown = VoxelShapes.func_216384_a((VoxelShape)FramedSlopedPrismBlock.func_208617_a((double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedSlopedPrismBlock.func_208617_a((double)0.5, (double)0.0, (double)12.0, (double)15.5, (double)15.5, (double)16.0), FramedSlopedPrismBlock.func_208617_a((double)4.0, (double)0.0, (double)8.0, (double)12.0, (double)12.0, (double)16.0)}).func_197753_c();
        for (BlockState state : states) {
            VoxelShape shape;
            Direction facing = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H);
            Direction orientation = (Direction)state.func_177229_b((Property)PropertyHolder.ORIENTATION);
            if (orientation == facing || orientation == facing.func_176734_d()) {
                builder.put((Object)state, (Object)VoxelShapes.func_197868_b());
                continue;
            }
            if (facing.func_176740_k() == Direction.Axis.Y) {
                builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, orientation, facing == Direction.UP ? shapeBottom : shapeTop));
                continue;
            }
            if (orientation == Direction.UP) {
                shape = shapeUp;
            } else if (orientation == Direction.DOWN) {
                shape = shapeDown;
            } else if (orientation == facing.func_176746_e()) {
                shape = shapeLeft;
            } else if (orientation == facing.func_176735_f()) {
                shape = shapeRight;
            } else {
                throw new IllegalArgumentException("Invalid orientation for direction!");
            }
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, facing, shape));
        }
        return builder.build();
    }
}

