/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.UnmodifiableIterator;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.tileentity.FramedDoubleTileEntity;
import xfacthd.framedblocks.common.tileentity.FramedTileEntity;
import xfacthd.framedblocks.common.util.CtmPredicate;

public class FramedSlabBlock
extends FramedBlock {
    public static final CtmPredicate CTM_PREDICATE = (state, dir) -> (Boolean)state.func_177229_b((Property)PropertyHolder.TOP) != false && dir == Direction.UP || (Boolean)state.func_177229_b((Property)PropertyHolder.TOP) == false && dir == Direction.DOWN;

    public FramedSlabBlock() {
        super(BlockType.FRAMED_SLAB);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)PropertyHolder.TOP, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{PropertyHolder.TOP, BlockStateProperties.field_208198_y, PropertyHolder.SOLID, PropertyHolder.GLOWING});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.withWater(this.withTop(this.func_176223_P(), context.func_196000_l(), context.func_221532_j()), (IWorldReader)context.func_195991_k(), context.func_195995_a());
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == ((Block)FBContent.blockFramedSlab.get()).func_199767_j()) {
            boolean top = (Boolean)state.func_177229_b((Property)PropertyHolder.TOP);
            Direction face = hit.func_216354_b();
            if (face == Direction.UP && !top || face == Direction.DOWN && top) {
                if (!world.func_201670_d()) {
                    BlockState camoState = Blocks.field_150350_a.func_176223_P();
                    ItemStack camoStack = ItemStack.field_190927_a;
                    boolean glowing = false;
                    boolean intangible = false;
                    TileEntity te = world.func_175625_s(pos);
                    if (te instanceof FramedTileEntity) {
                        camoState = ((FramedTileEntity)te).getCamoState();
                        camoStack = ((FramedTileEntity)te).getCamoStack();
                        glowing = ((FramedTileEntity)te).isGlowing();
                        intangible = ((FramedTileEntity)te).isIntangible(null);
                    }
                    world.func_175656_a(pos, ((Block)FBContent.blockFramedDoubleSlab.get()).func_176223_P());
                    SoundType sound = ((Block)FBContent.blockFramedCube.get()).func_220072_p(((Block)FBContent.blockFramedCube.get()).func_176223_P());
                    world.func_184133_a(null, pos, sound.func_185841_e(), SoundCategory.BLOCKS, (sound.func_185843_a() + 1.0f) / 2.0f, sound.func_185847_b() * 0.8f);
                    if (!player.func_184812_l_()) {
                        stack.func_190918_g(1);
                        player.field_71071_by.func_70296_d();
                    }
                    if ((te = world.func_175625_s(pos)) instanceof FramedDoubleTileEntity) {
                        ((FramedDoubleTileEntity)te).setCamo(camoStack, camoState, top);
                        ((FramedDoubleTileEntity)te).setGlowing(glowing);
                        ((FramedDoubleTileEntity)te).setIntangible(intangible);
                    }
                }
                return ActionResultType.func_233537_a_((boolean)world.func_201670_d());
            }
        }
        return super.func_225533_a_(state, world, pos, player, hand, hit);
    }

    @Override
    public boolean func_196266_a(BlockState state, IBlockReader world, BlockPos pos, PathType type) {
        return type == PathType.WATER && world.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a);
    }

    public static ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape bottomShape = FramedSlabBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
        VoxelShape topShape = FramedSlabBlock.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        UnmodifiableIterator unmodifiableIterator = states.iterator();
        while (unmodifiableIterator.hasNext()) {
            BlockState state;
            builder.put((Object)state, (Object)((Boolean)(state = (BlockState)unmodifiableIterator.next()).func_177229_b((Property)PropertyHolder.TOP) != false ? topShape : bottomShape));
        }
        return builder.build();
    }
}

