/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.util.SideSkipPredicate;

public class FramedLatticeBlock
extends FramedBlock {
    public static final SideSkipPredicate SKIP_PREDICATE = (world, pos, state, adjState, side) -> {
        if (adjState.func_177230_c() == FBContent.blockFramedLattice.get()) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    };

    public FramedLatticeBlock() {
        super(BlockType.FRAMED_LATTICE_BLOCK);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)PropertyHolder.X_AXIS, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)PropertyHolder.Y_AXIS, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)PropertyHolder.Z_AXIS, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{PropertyHolder.X_AXIS, PropertyHolder.Y_AXIS, PropertyHolder.Z_AXIS, BlockStateProperties.field_208198_y});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        BlockState state = this.func_176223_P();
        state = (BlockState)state.func_206870_a((Property)PropertyHolder.X_AXIS, (Comparable)Boolean.valueOf(world.func_180495_p(pos.func_177974_f()).func_203425_a((Block)this) || world.func_180495_p(pos.func_177976_e()).func_203425_a((Block)this)));
        state = (BlockState)state.func_206870_a((Property)PropertyHolder.Y_AXIS, (Comparable)Boolean.valueOf(world.func_180495_p(pos.func_177984_a()).func_203425_a((Block)this) || world.func_180495_p(pos.func_177977_b()).func_203425_a((Block)this)));
        state = (BlockState)state.func_206870_a((Property)PropertyHolder.Z_AXIS, (Comparable)Boolean.valueOf(world.func_180495_p(pos.func_177978_c()).func_203425_a((Block)this) || world.func_180495_p(pos.func_177968_d()).func_203425_a((Block)this)));
        return this.withWater(state, (IWorldReader)world, pos);
    }

    @Override
    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
        state = (BlockState)state.func_206870_a((Property)FramedLatticeBlock.getPropFromAxis(facing), (Comparable)Boolean.valueOf(facingState.func_203425_a((Block)this) || world.func_180495_p(pos.func_177972_a(facing.func_176734_d())).func_203425_a((Block)this)));
        return super.func_196271_a(state, facing, facingState, world, pos, facingPos);
    }

    public static ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape xShape = FramedLatticeBlock.func_208617_a((double)0.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
        VoxelShape yShape = FramedLatticeBlock.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
        VoxelShape zShape = FramedLatticeBlock.func_208617_a((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)16.0);
        for (BlockState state : states) {
            VoxelShape shape = FramedLatticeBlock.func_208617_a((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
            if (((Boolean)state.func_177229_b((Property)PropertyHolder.X_AXIS)).booleanValue()) {
                shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)xShape);
            }
            if (((Boolean)state.func_177229_b((Property)PropertyHolder.Y_AXIS)).booleanValue()) {
                shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)yShape);
            }
            if (((Boolean)state.func_177229_b((Property)PropertyHolder.Z_AXIS)).booleanValue()) {
                shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)zShape);
            }
            builder.put((Object)state, (Object)shape.func_197753_c());
        }
        return builder.build();
    }

    public static BooleanProperty getPropFromAxis(Direction dir) {
        switch (dir.func_176740_k()) {
            case X: {
                return PropertyHolder.X_AXIS;
            }
            case Y: {
                return PropertyHolder.Y_AXIS;
            }
            case Z: {
                return PropertyHolder.Z_AXIS;
            }
        }
        throw new IllegalArgumentException("Facing with invalid axis: " + dir);
    }
}

