/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.world.gen.feature;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FeatureSpreadConfig;
import untamedwilds.block.IPostGenUpdate;
import untamedwilds.config.ConfigFeatureControl;
import untamedwilds.init.ModBlock;
import untamedwilds.init.ModTags;

public class FeatureVegetation
extends Feature<FeatureSpreadConfig> {
    public FeatureVegetation(Codec<FeatureSpreadConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos genPos, FeatureSpreadConfig config) {
        boolean flag = false;
        int x = rand.nextInt(16) - 8;
        int z = rand.nextInt(16) - 8;
        BlockPos pos = genPos.func_177982_a(x, 0, z);
        Pair<Block, Integer> flora = FloraTypes.getFloraForPos((IWorld)world, genPos);
        if (flora != null) {
            Block block = (Block)flora.getFirst();
            int size = (Integer)flora.getSecond();
            for (int i = 0; i < size; ++i) {
                BlockPos blockpos = pos.func_177982_a(rand.nextInt(6) - rand.nextInt(6), rand.nextInt(2) - rand.nextInt(2), rand.nextInt(6) - rand.nextInt(6));
                if (!world.func_180495_p(blockpos.func_177977_b()).func_177230_c().func_203417_a(ModTags.BlockTags.REEDS_PLANTABLE_ON) || !world.func_180495_p(blockpos).canBeReplacedByLeaves((IWorldReader)world, blockpos) || !world.func_204610_c(blockpos).func_206888_e() || block == null) continue;
                world.func_180501_a(blockpos, block.func_176223_P(), 2);
                if (block.getBlock() instanceof IPostGenUpdate) {
                    ((IPostGenUpdate)block.getBlock()).updatePostGen(world, blockpos);
                }
                flag = true;
            }
        }
        return flag;
    }

    public static enum FloraTypes implements IStringSerializable
    {
        TEMPERATE_BUSH((Block)ModBlock.BUSH_TEMPERATE.get(), 8, (Boolean)ConfigFeatureControl.addFlora.get(), false, 32, Biome.Category.FOREST, Biome.Category.SWAMP, Biome.Category.EXTREME_HILLS, Biome.Category.TAIGA, Biome.Category.PLAINS),
        ELEPHANT_EAR((Block)ModBlock.ELEPHANT_EAR.get(), 6, (Boolean)ConfigFeatureControl.addFlora.get(), false, 32, Biome.Category.JUNGLE),
        HEMLOCK((Block)ModBlock.HEMLOCK.get(), 1, (Boolean)ConfigFeatureControl.addFlora.get(), false, 16, Biome.Category.FOREST, Biome.Category.PLAINS),
        TITAN_ARUM((Block)ModBlock.TITAN_ARUM.get(), 6, (Boolean)ConfigFeatureControl.addFlora.get(), false, 1, Biome.Category.JUNGLE),
        ZIMBABWE_ALOE((Block)ModBlock.ZIMBABWE_ALOE.get(), 4, (Boolean)ConfigFeatureControl.addFlora.get(), false, 1, Biome.Category.MESA);

        public Block type;
        public int rarity;
        public boolean enabled;
        public boolean spawnsInWater;
        public int size;
        public Biome.Category[] spawnBiomes;

        private FloraTypes(Block type, int rolls, boolean add, boolean spawnsInWater, int size, Biome.Category ... biomes) {
            this.type = type;
            this.rarity = rolls;
            this.enabled = add;
            this.spawnsInWater = spawnsInWater;
            this.spawnBiomes = biomes;
            this.size = size;
        }

        public String func_176610_l() {
            return "why would you do this?";
        }

        public static Pair<Block, Integer> getFloraForPos(IWorld world, BlockPos pos) {
            Biome biome = world.func_226691_t_(pos);
            ArrayList<FloraTypes> types = new ArrayList<FloraTypes>();
            for (FloraTypes type : FloraTypes.values()) {
                if (!type.enabled || !type.spawnsInWater && world.func_180495_p(pos).func_177230_c() == Blocks.field_150355_j) continue;
                for (Biome.Category biomeTypes : type.spawnBiomes) {
                    if (biome.func_201856_r() != biomeTypes) continue;
                    for (int i = 0; i < type.rarity; ++i) {
                        types.add(type);
                    }
                }
            }
            if (!types.isEmpty()) {
                int i = new Random().nextInt(types.size());
                return new Pair((Object)((FloraTypes)((Object)types.get((int)i))).type, (Object)((FloraTypes)((Object)types.get((int)i))).size);
            }
            return null;
        }
    }
}

