/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.world.gen.feature;

import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import untamedwilds.block.blockentity.CritterBurrowBlockEntity;
import untamedwilds.entity.ISpecies;
import untamedwilds.init.ModBlock;
import untamedwilds.world.FaunaHandler;

public class FeatureCritterBurrow
extends Feature<NoFeatureConfig> {
    public FeatureCritterBurrow(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        int i = rand.nextInt(8) - rand.nextInt(8);
        int j = rand.nextInt(8) - rand.nextInt(8);
        int k = world.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, pos.func_177958_n() + i, pos.func_177952_p() + j);
        pos = new BlockPos(pos.func_177958_n() + i, k, pos.func_177952_p() + j);
        FaunaHandler.SpawnListEntry entry = (FaunaHandler.SpawnListEntry)WeightedRandom.func_76271_a((Random)rand, FaunaHandler.getSpawnableList(FaunaHandler.animalType.CRITTER));
        Entity entity = entry.entityType.func_200721_a((World)world.func_201672_e());
        if (entity != null && world.func_180495_p(pos).canBeReplacedByLeaves((IWorldReader)world, pos) && world.func_180495_p(pos.func_177977_b()).func_235719_a_((IBlockReader)world, pos, entity)) {
            if (entity instanceof ISpecies) {
                Optional optional = world.func_242406_i(pos);
                int variant = ((ISpecies)entity).setSpeciesByBiome((RegistryKey<Biome>)((RegistryKey)optional.get()), world.func_226691_t_(pos), SpawnReason.CHUNK_GENERATION);
                if (variant == 99) {
                    entity.func_70106_y();
                    return false;
                }
                world.func_180501_a(pos, ((Block)ModBlock.BURROW.get()).func_176223_P(), 1);
                CritterBurrowBlockEntity te = (CritterBurrowBlockEntity)world.func_175625_s(pos);
                if (te != null) {
                    te.setCount(Math.max(3, entry.groupCount * (rand.nextInt(2) + 1)));
                    te.setEntityType(entry.entityType);
                    te.setVariant(variant);
                }
            } else {
                world.func_180501_a(pos, ((Block)ModBlock.BURROW.get()).func_176223_P(), 1);
                CritterBurrowBlockEntity te = (CritterBurrowBlockEntity)world.func_175625_s(pos);
                if (te != null) {
                    te.setCount(entry.groupCount * rand.nextInt(3) + 4);
                    te.setEntityType(entry.entityType);
                }
            }
            entity.func_70106_y();
            return true;
        }
        return false;
    }
}

