/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.util;

import java.util.Objects;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import untamedwilds.UntamedWilds;
import untamedwilds.entity.ComplexMob;
import untamedwilds.init.ModEntity;
import untamedwilds.network.SyncTextureData;
import untamedwilds.network.UntamedInstance;
import untamedwilds.util.EntityDataHolder;
import untamedwilds.util.JSONLoader;
import untamedwilds.util.SpeciesDataHolder;

@Mod.EventBusSubscriber(modid="untamedwilds")
public class ResourceListenerEvent {
    public static final JSONLoader<EntityDataHolder> ENTITY_DATA_HOLDERS = new JSONLoader<EntityDataHolder>("entities", EntityDataHolder.CODEC);
    public static EntityDataHolder TARANTULA;
    public static EntityDataHolder GIANT_CLAM;
    public static EntityDataHolder GIANT_SALAMANDER;
    public static EntityDataHolder NEWT;
    public static EntityDataHolder AROWANA;
    public static EntityDataHolder FOOTBALL_FISH;
    public static EntityDataHolder SHARK;
    public static EntityDataHolder SUNFISH;
    public static EntityDataHolder WHALE_SHARK;
    public static EntityDataHolder TREVALLY;
    public static EntityDataHolder TRIGGERFISH;
    public static EntityDataHolder CATFISH;
    public static EntityDataHolder SNAKE;
    public static EntityDataHolder ANACONDA;
    public static EntityDataHolder SOFTSHELL_TURTLE;
    public static EntityDataHolder TORTOISE;
    public static EntityDataHolder AARDVARK;
    public static EntityDataHolder HIPPO;
    public static EntityDataHolder RHINO;
    public static EntityDataHolder HYENA;
    public static EntityDataHolder BOAR;
    public static EntityDataHolder BEAR;
    public static EntityDataHolder BIG_CAT;
    public static EntityDataHolder BISON;
    public static EntityDataHolder MANATEE;
    public static EntityDataHolder CAMEL;

    @SubscribeEvent
    public static void onAddReloadListeners(AddReloadListenerEvent event) {
        event.addListener(ENTITY_DATA_HOLDERS);
        ResourceListenerEvent.registerData();
    }

    private static void registerData() {
        TARANTULA = ResourceListenerEvent.registerEntityData(ModEntity.TARANTULA);
        GIANT_CLAM = ResourceListenerEvent.registerEntityData(ModEntity.GIANT_CLAM);
        GIANT_SALAMANDER = ResourceListenerEvent.registerEntityData(ModEntity.GIANT_SALAMANDER);
        NEWT = ResourceListenerEvent.registerEntityData(ModEntity.NEWT);
        AROWANA = ResourceListenerEvent.registerEntityData(ModEntity.AROWANA);
        FOOTBALL_FISH = ResourceListenerEvent.registerEntityData(ModEntity.FOOTBALL_FISH);
        SHARK = ResourceListenerEvent.registerEntityData(ModEntity.SHARK);
        SUNFISH = ResourceListenerEvent.registerEntityData(ModEntity.SUNFISH);
        TREVALLY = ResourceListenerEvent.registerEntityData(ModEntity.TREVALLY);
        WHALE_SHARK = ResourceListenerEvent.registerEntityData(ModEntity.WHALE_SHARK);
        TRIGGERFISH = ResourceListenerEvent.registerEntityData(ModEntity.TRIGGERFISH);
        CATFISH = ResourceListenerEvent.registerEntityData(ModEntity.CATFISH);
        SNAKE = ResourceListenerEvent.registerEntityData(ModEntity.SNAKE);
        ANACONDA = ResourceListenerEvent.registerEntityData(ModEntity.ANACONDA);
        SOFTSHELL_TURTLE = ResourceListenerEvent.registerEntityData(ModEntity.SOFTSHELL_TURTLE);
        TORTOISE = ResourceListenerEvent.registerEntityData(ModEntity.TORTOISE);
        BEAR = ResourceListenerEvent.registerEntityData(ModEntity.BEAR);
        BIG_CAT = ResourceListenerEvent.registerEntityData(ModEntity.BIG_CAT);
        AARDVARK = ResourceListenerEvent.registerEntityData(ModEntity.AARDVARK);
        BOAR = ResourceListenerEvent.registerEntityData(ModEntity.BOAR);
        RHINO = ResourceListenerEvent.registerEntityData(ModEntity.RHINO);
        HYENA = ResourceListenerEvent.registerEntityData(ModEntity.HYENA);
        HIPPO = ResourceListenerEvent.registerEntityData(ModEntity.HIPPO);
        BISON = ResourceListenerEvent.registerEntityData(ModEntity.BISON);
        MANATEE = ResourceListenerEvent.registerEntityData(ModEntity.MANATEE);
        CAMEL = ResourceListenerEvent.registerEntityData(ModEntity.CAMEL);
    }

    @SubscribeEvent
    public static void onPlayerLogIn(PlayerEvent.PlayerLoggedInEvent event) throws NoSuchFieldException {
        UntamedWilds.LOGGER.info("Firing player login event");
        ResourceListenerEvent.registerData();
        for (EntityType<?> types : ComplexMob.ENTITY_DATA_HASH.keySet()) {
            ResourceLocation entityName = types.getRegistryName();
            int size = 0;
            for (SpeciesDataHolder speciesData : ComplexMob.ENTITY_DATA_HASH.get(types).getSpeciesData()) {
                UntamedInstance.sendToClient(new SyncTextureData(entityName, speciesData.getName(), speciesData.getSkins(), size++), (ServerPlayerEntity)event.getPlayer());
            }
        }
    }

    public static EntityDataHolder registerEntityData(EntityType<?> typeIn) {
        String nameIn = Objects.requireNonNull(typeIn.getRegistryName()).func_110623_a();
        if (ENTITY_DATA_HOLDERS.getData(new ResourceLocation("untamedwilds", nameIn)) != null) {
            EntityDataHolder data = ENTITY_DATA_HOLDERS.getData(new ResourceLocation("untamedwilds", nameIn));
            ComplexMob.processData(data, typeIn);
            return data;
        }
        return null;
    }
}

