/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.network;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.entity.EntityType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import untamedwilds.entity.ComplexMob;
import untamedwilds.util.EntityDataHolderClient;
import untamedwilds.util.EntityUtils;

public class SyncTextureData {
    private final ResourceLocation entityName;
    private final String speciesName;
    private final Integer skinsData;
    private final Integer id;

    public SyncTextureData(PacketBuffer buf) {
        this.entityName = buf.func_192575_l();
        this.speciesName = buf.func_218666_n();
        this.skinsData = buf.readInt();
        this.id = buf.readInt();
    }

    public SyncTextureData(ResourceLocation str, String species_name, Integer skins, Integer id) {
        this.entityName = str;
        this.speciesName = species_name;
        this.skinsData = skins;
        this.id = id;
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_192572_a(this.entityName);
        buf.func_180714_a(this.speciesName);
        buf.writeInt(this.skinsData.intValue());
        buf.writeInt(this.id.intValue());
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(this.entityName);
            if (!ComplexMob.CLIENT_DATA_HASH.containsKey(type)) {
                ComplexMob.CLIENT_DATA_HASH.put(type, new EntityDataHolderClient(new HashMap<Integer, Map<String, SoundEvent>>(), new HashMap<Integer, String>()));
            }
            EntityUtils.buildSkinArrays(this.entityName.func_110623_a(), this.speciesName, this.skinsData, (int)this.id, ComplexMob.TEXTURES_COMMON, ComplexMob.TEXTURES_RARE);
            ComplexMob.CLIENT_DATA_HASH.get(type).addSpeciesName(this.id, this.speciesName);
        });
        return true;
    }
}

