/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.item;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.AbstractSpawner;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.INeedsPostUpdate;

public class UntamedSpawnEggItem
extends SpawnEggItem {
    private int currentSpecies = 0;
    private boolean isCached;
    private final EntityType<?> entityType;

    public UntamedSpawnEggItem(EntityType<?> typeIn, int primaryColorIn, int secondaryColorIn, Item.Properties builder) {
        super(typeIn, primaryColorIn, secondaryColorIn, builder);
        this.entityType = typeIn;
        this.isCached = false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("item.untamedwilds.spawn_egg_info").func_240699_a_(TextFormatting.GRAY));
        tooltip.add((ITextComponent)new TranslationTextComponent("item.untamedwilds.spawn_egg_current", new Object[]{this.getCurrentSpeciesNumber(stack)}).func_240699_a_(TextFormatting.ITALIC).func_240699_a_(TextFormatting.GRAY));
    }

    private String getCurrentSpeciesNumber(ItemStack stack) {
        int i;
        if (!this.isCached && stack.func_77942_o() && stack.func_77978_p().func_74764_b("EntityTag")) {
            this.currentSpecies = stack.func_77978_p().func_74775_l("EntityTag").func_74762_e("Variant");
            this.isCached = true;
        }
        return (i = this.currentSpecies - 1) >= 0 ? String.valueOf(i) : "Random";
    }

    public void increaseSpeciesNumber(int intIn) {
        this.currentSpecies = intIn % (ComplexMob.getEntityData(this.entityType).getSpeciesData().size() + 1);
        this.isCached = true;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (!worldIn.field_72995_K && playerIn.func_225608_bj_()) {
            this.increaseSpeciesNumber(this.currentSpecies + 1);
            playerIn.func_146105_b((ITextComponent)new TranslationTextComponent("item.untamedwilds.spawn_egg_change", new Object[]{this.getCurrentSpeciesNumber(itemstack)}), true);
            itemstack.func_77982_d(new CompoundNBT());
            if (this.currentSpecies != 0) {
                CompoundNBT entityNBT = new CompoundNBT();
                entityNBT.func_74768_a("Variant", this.currentSpecies - 1);
                itemstack.func_77978_p().func_218657_a("EntityTag", (INBT)entityNBT);
            }
            return ActionResult.func_226250_c_((Object)itemstack);
        }
        BlockRayTraceResult raytraceresult = UntamedSpawnEggItem.func_219968_a((World)worldIn, (PlayerEntity)playerIn, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY);
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return ActionResult.func_226250_c_((Object)itemstack);
        }
        if (!(worldIn instanceof ServerWorld)) {
            return ActionResult.func_226248_a_((Object)itemstack);
        }
        BlockPos blockpos = raytraceresult.func_216350_a();
        if (!(worldIn.func_180495_p(blockpos).func_177230_c() instanceof FlowingFluidBlock)) {
            return ActionResult.func_226250_c_((Object)itemstack);
        }
        if (worldIn.func_175660_a(playerIn, blockpos) && playerIn.func_175151_a(blockpos, raytraceresult.func_216354_b(), itemstack)) {
            EntityType entitytype = this.func_208076_b(itemstack.func_77978_p());
            Entity spawn = entitytype.func_220349_b((ServerWorld)worldIn, itemstack.func_77978_p(), null, playerIn, blockpos, SpawnReason.SPAWN_EGG, false, false);
            if (spawn == null) {
                return ActionResult.func_226250_c_((Object)itemstack);
            }
            if (spawn instanceof ComplexMob) {
                ComplexMob entitySpawn = (ComplexMob)spawn;
                entitySpawn.chooseSkinForSpecies(entitySpawn, true);
                entitySpawn.setRandomMobSize();
                entitySpawn.setGender(entitySpawn.func_70681_au().nextInt(2));
                if (spawn instanceof INeedsPostUpdate) {
                    ((INeedsPostUpdate)spawn).updateAttributes();
                }
                worldIn.func_217376_c(spawn);
            }
            if (!playerIn.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            return ActionResult.func_226249_b_((Object)itemstack);
        }
        return ActionResult.func_226251_d_((Object)itemstack);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        TileEntity tileentity;
        World world = context.func_195991_k();
        if (!(world instanceof ServerWorld)) {
            return ActionResultType.SUCCESS;
        }
        ItemStack itemstack = context.func_195996_i();
        BlockPos blockpos = context.func_195995_a();
        Direction direction = context.func_196000_l();
        BlockState blockstate = world.func_180495_p(blockpos);
        if (blockstate.func_203425_a(Blocks.field_150474_ac) && (tileentity = world.func_175625_s(blockpos)) instanceof MobSpawnerTileEntity) {
            AbstractSpawner abstractspawner = ((MobSpawnerTileEntity)tileentity).func_145881_a();
            EntityType entitytype1 = this.func_208076_b(itemstack.func_77978_p());
            abstractspawner.func_200876_a(entitytype1);
            CompoundNBT entityNBT = new CompoundNBT();
            abstractspawner.func_189530_b(entityNBT);
            ListNBT listnbt = new ListNBT();
            CompoundNBT compoundnbt = new CompoundNBT();
            CompoundNBT entityNBT_2 = new CompoundNBT();
            entityNBT_2.func_74778_a("id", entitytype1.getRegistryName().toString());
            entityNBT_2.func_74768_a("Variant", this.currentSpecies - 1);
            compoundnbt.func_218657_a("Entity", (INBT)entityNBT_2);
            compoundnbt.func_74768_a("Weight", 1);
            listnbt.add((Object)compoundnbt);
            entityNBT.func_150295_c("SpawnPotentials", 10).clear();
            entityNBT.func_150295_c("SpawnPotentials", 10).add((Object)listnbt);
            abstractspawner.func_98270_a(entityNBT);
            tileentity.func_70296_d();
            world.func_184138_a(blockpos, blockstate, blockstate, 3);
            itemstack.func_190918_g(1);
            return ActionResultType.CONSUME;
        }
        BlockPos blockpos1 = blockstate.func_196952_d((IBlockReader)world, blockpos).func_197766_b() ? blockpos : blockpos.func_177972_a(direction);
        EntityType entitytype = this.func_208076_b(itemstack.func_77978_p());
        Entity spawn = entitytype.func_220349_b((ServerWorld)world, itemstack.func_77978_p(), null, context.func_195999_j(), blockpos1, SpawnReason.SPAWN_EGG, true, !Objects.equals(blockpos, blockpos1) && direction == Direction.UP);
        if (spawn == null) {
            return ActionResultType.PASS;
        }
        if (spawn instanceof ComplexMob) {
            ComplexMob entitySpawn = (ComplexMob)spawn;
            entitySpawn.chooseSkinForSpecies(entitySpawn, true);
            entitySpawn.setRandomMobSize();
            entitySpawn.setGender(entitySpawn.func_70681_au().nextInt(2));
            if (spawn instanceof INeedsPostUpdate) {
                ((INeedsPostUpdate)spawn).updateAttributes();
            }
            world.func_217376_c(spawn);
        }
        itemstack.func_190918_g(1);
        return ActionResultType.CONSUME;
    }
}

