/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.init;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import untamedwilds.client.render.RendererAardvark;
import untamedwilds.client.render.RendererAnaconda;
import untamedwilds.client.render.RendererArowana;
import untamedwilds.client.render.RendererBear;
import untamedwilds.client.render.RendererBigCat;
import untamedwilds.client.render.RendererBison;
import untamedwilds.client.render.RendererBoar;
import untamedwilds.client.render.RendererCamel;
import untamedwilds.client.render.RendererCatfish;
import untamedwilds.client.render.RendererFootballFish;
import untamedwilds.client.render.RendererGiantClam;
import untamedwilds.client.render.RendererGiantSalamander;
import untamedwilds.client.render.RendererHippo;
import untamedwilds.client.render.RendererHyena;
import untamedwilds.client.render.RendererManatee;
import untamedwilds.client.render.RendererNewt;
import untamedwilds.client.render.RendererRhino;
import untamedwilds.client.render.RendererShark;
import untamedwilds.client.render.RendererSnake;
import untamedwilds.client.render.RendererSoftshellTurtle;
import untamedwilds.client.render.RendererSunfish;
import untamedwilds.client.render.RendererTarantula;
import untamedwilds.client.render.RendererTortoise;
import untamedwilds.client.render.RendererTrevally;
import untamedwilds.client.render.RendererTriggerfish;
import untamedwilds.client.render.RendererWhaleShark;
import untamedwilds.config.ConfigMobControl;
import untamedwilds.entity.amphibian.EntityGiantSalamander;
import untamedwilds.entity.amphibian.EntityNewt;
import untamedwilds.entity.arthropod.EntityTarantula;
import untamedwilds.entity.fish.EntityArowana;
import untamedwilds.entity.fish.EntityCatfish;
import untamedwilds.entity.fish.EntityFootballFish;
import untamedwilds.entity.fish.EntityShark;
import untamedwilds.entity.fish.EntitySunfish;
import untamedwilds.entity.fish.EntityTrevally;
import untamedwilds.entity.fish.EntityTriggerfish;
import untamedwilds.entity.fish.EntityWhaleShark;
import untamedwilds.entity.mammal.EntityAardvark;
import untamedwilds.entity.mammal.EntityBear;
import untamedwilds.entity.mammal.EntityBigCat;
import untamedwilds.entity.mammal.EntityBison;
import untamedwilds.entity.mammal.EntityBoar;
import untamedwilds.entity.mammal.EntityCamel;
import untamedwilds.entity.mammal.EntityHippo;
import untamedwilds.entity.mammal.EntityHyena;
import untamedwilds.entity.mammal.EntityManatee;
import untamedwilds.entity.mammal.EntityRhino;
import untamedwilds.entity.mollusk.EntityGiantClam;
import untamedwilds.entity.reptile.EntityAnaconda;
import untamedwilds.entity.reptile.EntitySnake;
import untamedwilds.entity.reptile.EntitySoftshellTurtle;
import untamedwilds.entity.reptile.EntityTortoise;
import untamedwilds.item.UntamedSpawnEggItem;
import untamedwilds.world.FaunaHandler;

@Mod.EventBusSubscriber(modid="untamedwilds", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModEntity {
    private static final List<EntityType<? extends Entity>> entities = Lists.newArrayList();
    private static final List<Item> spawnEggs = Lists.newArrayList();
    public static final Map<String, Integer> eco_levels = new HashMap<String, Integer>();
    public static EntityType<EntityTarantula> TARANTULA = ModEntity.createEntity((Boolean)ConfigMobControl.addTarantula.get(), EntityTarantula::new, "tarantula", 0.4f, 0.3f, 11907221, 2500907, FaunaHandler.animalType.CRITTER, 4);
    public static EntityType<EntitySnake> SNAKE = ModEntity.createEntity((Boolean)ConfigMobControl.addSnake.get(), EntitySnake::new, "snake", 0.6f, 0.3f, 14198098, 6042917, FaunaHandler.animalType.CRITTER, 4, 1);
    public static EntityType<EntitySoftshellTurtle> SOFTSHELL_TURTLE = ModEntity.createEntity((Boolean)ConfigMobControl.addSoftshellTurtle.get(), EntitySoftshellTurtle::new, "softshell_turtle", 0.6f, 0.3f, 0x828444, 2500907, FaunaHandler.animalType.CRITTER, 3, 2);
    public static EntityType<EntityTortoise> TORTOISE = ModEntity.createEntity((Boolean)ConfigMobControl.addTortoise.get(), EntityTortoise::new, "tortoise", 0.6f, 0.6f, 11509620, 7819826, FaunaHandler.animalType.CRITTER, 3, 2);
    public static EntityType<EntityAnaconda> ANACONDA = ModEntity.createEntity((Boolean)ConfigMobControl.addLargeSnake.get(), EntityAnaconda::new, "large_snake", 1.5f, 0.6f, 6647884, 4335898, FaunaHandler.animalType.APEX_PRED, 4, 1);
    public static EntityType<EntityGiantClam> GIANT_CLAM = ModEntity.createEntity((Boolean)ConfigMobControl.addGiantClam.get(), EntityGiantClam::new, EntityClassification.WATER_CREATURE, "giant_clam", 32, 10, true, 1.0f, 1.0f, 3435376, 11366716, FaunaHandler.animalType.SESSILE, 1);
    public static EntityType<EntityBear> BEAR = ModEntity.createEntity((Boolean)ConfigMobControl.addBear.get(), EntityBear::new, "bear", 1.3f, 1.3f, 2102027, 5655621, FaunaHandler.animalType.APEX_PRED, 10, 1);
    public static EntityType<EntityBigCat> BIG_CAT = ModEntity.createEntity((Boolean)ConfigMobControl.addBigCat.get(), EntityBigCat::new, "big_cat", 1.2f, 1.0f, 12951365, 3682593, FaunaHandler.animalType.APEX_PRED, 10, 1);
    public static EntityType<EntityHippo> HIPPO = ModEntity.createEntity((Boolean)ConfigMobControl.addHippo.get(), EntityHippo::new, "hippo", 1.8f, 1.8f, 4602417, 9791329, FaunaHandler.animalType.APEX_PRED, 10, 5);
    public static EntityType<EntityAardvark> AARDVARK = ModEntity.createEntity((Boolean)ConfigMobControl.addAardvark.get(), EntityAardvark::new, "aardvark", 0.9f, 0.9f, 4602417, 9791329, FaunaHandler.animalType.CRITTER, 2);
    public static EntityType<EntityRhino> RHINO = ModEntity.createEntity((Boolean)ConfigMobControl.addRhino.get(), EntityRhino::new, "rhino", 2.0f, 1.8f, 0x787676, 0x665956, FaunaHandler.animalType.APEX_PRED, 6);
    public static EntityType<EntityHyena> HYENA = ModEntity.createEntity((Boolean)ConfigMobControl.addHyena.get(), EntityHyena::new, "hyena", 0.9f, 1.1f, 7104599, 9931110, FaunaHandler.animalType.APEX_PRED, 10, 6);
    public static EntityType<EntityBoar> BOAR = ModEntity.createEntity((Boolean)ConfigMobControl.addBoar.get(), EntityBoar::new, "boar", 1.2f, 1.2f, 5258282, 6313033, FaunaHandler.animalType.APEX_PRED, 6, 3);
    public static EntityType<EntityBison> BISON = ModEntity.createEntity((Boolean)ConfigMobControl.addBison.get(), EntityBison::new, "bison", 1.7f, 1.6f, 8674091, 4797482, FaunaHandler.animalType.APEX_PRED, 6, 6);
    public static EntityType<EntityCamel> CAMEL = ModEntity.createEntity((Boolean)ConfigMobControl.addCamel.get(), EntityCamel::new, "camel", 1.8f, 2.0f, 14727561, 9923389, FaunaHandler.animalType.APEX_PRED, 2, 4);
    public static EntityType<EntityManatee> MANATEE = ModEntity.createEntity((Boolean)ConfigMobControl.addManatee.get(), EntityManatee::new, "manatee", 1.8f, 2.0f, 0x4A4040, 0x787676, FaunaHandler.animalType.LARGE_OCEAN, 1, 1);
    public static EntityType<EntitySunfish> SUNFISH = ModEntity.createEntity((Boolean)ConfigMobControl.addSunfish.get(), EntitySunfish::new, "sunfish", 1.6f, 1.6f, 2905179, 11981011, FaunaHandler.animalType.LARGE_OCEAN, 2);
    public static EntityType<EntityTrevally> TREVALLY = ModEntity.createEntity((Boolean)ConfigMobControl.addTrevally.get(), EntityTrevally::new, "trevally", 0.8f, 0.8f, 10859695, 13147415, FaunaHandler.animalType.LARGE_OCEAN, 4, 8);
    public static EntityType<EntityArowana> AROWANA = ModEntity.createEntity((Boolean)ConfigMobControl.addArowana.get(), EntityArowana::new, "arowana", 0.6f, 0.6f, 6577221, 11706194, FaunaHandler.animalType.DENSE_WATER, 1);
    public static EntityType<EntityShark> SHARK = ModEntity.createEntity((Boolean)ConfigMobControl.addShark.get(), EntityShark::new, "shark", 1.8f, 1.3f, 7033154, 11579555, FaunaHandler.animalType.LARGE_OCEAN, 2);
    public static EntityType<EntityFootballFish> FOOTBALL_FISH = ModEntity.createEntity((Boolean)ConfigMobControl.addFootballFish.get(), EntityFootballFish::new, "football_fish", 0.8f, 0.8f, 5461356, 3092535, FaunaHandler.animalType.LARGE_OCEAN, 1);
    public static EntityType<EntityWhaleShark> WHALE_SHARK = ModEntity.createEntity((Boolean)ConfigMobControl.addWhaleShark.get(), EntityWhaleShark::new, "whale_shark", 2.6f, 1.6f, 0x222426, 8289668, FaunaHandler.animalType.LARGE_OCEAN, 1);
    public static EntityType<EntityTriggerfish> TRIGGERFISH = ModEntity.createEntity((Boolean)ConfigMobControl.addTriggerfish.get(), EntityTriggerfish::new, "triggerfish", 0.8f, 0.8f, 2034201, 16563456, FaunaHandler.animalType.LARGE_OCEAN, 4);
    public static EntityType<EntityCatfish> CATFISH = ModEntity.createEntity((Boolean)ConfigMobControl.addCatfish.get(), EntityCatfish::new, "catfish", 0.8f, 0.8f, 5527907, 3812387, FaunaHandler.animalType.DENSE_WATER, 2, 3);
    public static EntityType<EntityGiantSalamander> GIANT_SALAMANDER = ModEntity.createEntity((Boolean)ConfigMobControl.addGiantSalamander.get(), EntityGiantSalamander::new, "giant_salamander", 1.0f, 0.6f, 3812387, 7033154, FaunaHandler.animalType.DENSE_WATER, 1);
    public static EntityType<EntityNewt> NEWT = ModEntity.createEntity((Boolean)ConfigMobControl.addNewt.get(), EntityNewt::new, "newt", 0.6f, 0.3f, 0x232323, 16747776, FaunaHandler.animalType.CRITTER, 2);

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        for (EntityType<? extends Entity> entity : entities) {
            event.getRegistry().register(entity);
        }
    }

    private static <T extends Entity> EntityType<T> createEntity(boolean enable, EntityType.IFactory<T> factory, EntityClassification classification, String name, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates, float sizeX, float sizeY, int baseColor, int overlayColor) {
        return ModEntity.createEntity(enable, factory, classification, name, trackingRange, updateFrequency, sendsVelocityUpdates, sizeX, sizeY, baseColor, overlayColor, FaunaHandler.animalType.CRITTER, 1);
    }

    private static <T extends Entity> EntityType<T> createEntity(boolean enable, EntityType.IFactory<T> factory, String name, float sizeX, float sizeY, int baseColor, int overlayColor, FaunaHandler.animalType spawnType, int weight) {
        return ModEntity.createEntity(enable, factory, EntityClassification.CREATURE, name, 64, 1, true, sizeX, sizeY, baseColor, overlayColor, spawnType, weight);
    }

    private static <T extends Entity> EntityType<T> createEntity(boolean enable, EntityType.IFactory<T> factory, String name, float sizeX, float sizeY, int baseColor, int overlayColor, FaunaHandler.animalType spawnType, int weight, int groupCount) {
        return ModEntity.createEntity(enable, factory, EntityClassification.CREATURE, name, 64, 1, true, sizeX, sizeY, baseColor, overlayColor, spawnType, weight, groupCount);
    }

    private static <T extends Entity> EntityType<T> createEntity(boolean enable, EntityType.IFactory<T> factory, EntityClassification classification, String name, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates, float sizeX, float sizeY, int maincolor, int backcolor, FaunaHandler.animalType spawnType, int weight) {
        return ModEntity.createEntity(enable, factory, EntityClassification.CREATURE, name, 64, 1, true, sizeX, sizeY, maincolor, backcolor, spawnType, weight, 1);
    }

    private static <T extends Entity> EntityType<T> createEntity(boolean enable, EntityType.IFactory<T> factory, EntityClassification classification, String name, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates, float sizeX, float sizeY, int maincolor, int backcolor, FaunaHandler.animalType spawnType, int weight, int groupCount) {
        ResourceLocation location = new ResourceLocation("untamedwilds", name);
        EntityType type = EntityType.Builder.func_220322_a(factory, (EntityClassification)classification).func_220321_a(sizeX, sizeY).setTrackingRange(trackingRange).setUpdateInterval(updateFrequency).setShouldReceiveVelocityUpdates(sendsVelocityUpdates).func_206830_a(location.toString());
        type.setRegistryName(name);
        entities.add((EntityType<? extends Entity>)type);
        if (enable) {
            spawnEggs.add((Item)new UntamedSpawnEggItem(type, maincolor, backcolor, new Item.Properties().func_200916_a(ItemGroup.field_78026_f)).setRegistryName(name + "_spawn_egg"));
            if (((Boolean)ConfigMobControl.masterSpawner.get()).booleanValue()) {
                ModEntity.addWorldSpawn(type, weight, spawnType, groupCount);
            }
        }
        return type;
    }

    @SubscribeEvent
    public static void bakeAttributes(EntityAttributeCreationEvent event) {
        event.put(TARANTULA, EntityTarantula.registerAttributes().func_233813_a_());
        event.put(SNAKE, EntitySnake.registerAttributes().func_233813_a_());
        event.put(SOFTSHELL_TURTLE, EntitySoftshellTurtle.registerAttributes().func_233813_a_());
        event.put(TORTOISE, EntityTortoise.registerAttributes().func_233813_a_());
        event.put(ANACONDA, EntityAnaconda.registerAttributes().func_233813_a_());
        event.put(GIANT_CLAM, EntityGiantClam.registerAttributes().func_233813_a_());
        event.put(BEAR, EntityBear.registerAttributes().func_233813_a_());
        event.put(BIG_CAT, EntityBigCat.registerAttributes().func_233813_a_());
        event.put(HIPPO, EntityHippo.registerAttributes().func_233813_a_());
        event.put(AARDVARK, EntityAardvark.registerAttributes().func_233813_a_());
        event.put(RHINO, EntityRhino.registerAttributes().func_233813_a_());
        event.put(HYENA, EntityHyena.registerAttributes().func_233813_a_());
        event.put(BOAR, EntityBoar.registerAttributes().func_233813_a_());
        event.put(BISON, EntityBison.registerAttributes().func_233813_a_());
        event.put(CAMEL, EntityCamel.registerAttributes().func_233813_a_());
        event.put(MANATEE, EntityManatee.registerAttributes().func_233813_a_());
        event.put(SUNFISH, EntitySunfish.registerAttributes().func_233813_a_());
        event.put(TREVALLY, EntityTrevally.registerAttributes().func_233813_a_());
        event.put(AROWANA, EntityArowana.registerAttributes().func_233813_a_());
        event.put(SHARK, EntityShark.registerAttributes().func_233813_a_());
        event.put(FOOTBALL_FISH, EntityFootballFish.registerAttributes().func_233813_a_());
        event.put(WHALE_SHARK, EntityWhaleShark.registerAttributes().func_233813_a_());
        event.put(TRIGGERFISH, EntityTriggerfish.registerAttributes().func_233813_a_());
        event.put(CATFISH, EntityTriggerfish.registerAttributes().func_233813_a_());
        event.put(GIANT_SALAMANDER, EntityGiantSalamander.registerAttributes().func_233813_a_());
        event.put(NEWT, EntityNewt.registerAttributes().func_233813_a_());
    }

    @SubscribeEvent
    public static void registerSpawnEggs(RegistryEvent.Register<Item> event) {
        for (Item spawnEgg : spawnEggs) {
            event.getRegistry().register((IForgeRegistryEntry)spawnEgg);
        }
    }

    public static void registerRendering() {
        RenderingRegistry.registerEntityRenderingHandler(TARANTULA, RendererTarantula::new);
        RenderingRegistry.registerEntityRenderingHandler(SOFTSHELL_TURTLE, RendererSoftshellTurtle::new);
        RenderingRegistry.registerEntityRenderingHandler(SNAKE, RendererSnake::new);
        RenderingRegistry.registerEntityRenderingHandler(TORTOISE, RendererTortoise::new);
        RenderingRegistry.registerEntityRenderingHandler(ANACONDA, RendererAnaconda::new);
        RenderingRegistry.registerEntityRenderingHandler(GIANT_CLAM, RendererGiantClam::new);
        RenderingRegistry.registerEntityRenderingHandler(BEAR, RendererBear::new);
        RenderingRegistry.registerEntityRenderingHandler(BIG_CAT, RendererBigCat::new);
        RenderingRegistry.registerEntityRenderingHandler(HIPPO, RendererHippo::new);
        RenderingRegistry.registerEntityRenderingHandler(AARDVARK, RendererAardvark::new);
        RenderingRegistry.registerEntityRenderingHandler(RHINO, RendererRhino::new);
        RenderingRegistry.registerEntityRenderingHandler(HYENA, RendererHyena::new);
        RenderingRegistry.registerEntityRenderingHandler(BOAR, RendererBoar::new);
        RenderingRegistry.registerEntityRenderingHandler(BISON, RendererBison::new);
        RenderingRegistry.registerEntityRenderingHandler(CAMEL, RendererCamel::new);
        RenderingRegistry.registerEntityRenderingHandler(MANATEE, RendererManatee::new);
        RenderingRegistry.registerEntityRenderingHandler(SUNFISH, RendererSunfish::new);
        RenderingRegistry.registerEntityRenderingHandler(TREVALLY, RendererTrevally::new);
        RenderingRegistry.registerEntityRenderingHandler(AROWANA, RendererArowana::new);
        RenderingRegistry.registerEntityRenderingHandler(SHARK, RendererShark::new);
        RenderingRegistry.registerEntityRenderingHandler(FOOTBALL_FISH, RendererFootballFish::new);
        RenderingRegistry.registerEntityRenderingHandler(WHALE_SHARK, RendererWhaleShark::new);
        RenderingRegistry.registerEntityRenderingHandler(TRIGGERFISH, RendererTriggerfish::new);
        RenderingRegistry.registerEntityRenderingHandler(CATFISH, RendererCatfish::new);
        RenderingRegistry.registerEntityRenderingHandler(GIANT_SALAMANDER, RendererGiantSalamander::new);
        RenderingRegistry.registerEntityRenderingHandler(NEWT, RendererNewt::new);
    }

    public static void addWorldSpawn(EntityType<?> entityClass, int weightedProb, FaunaHandler.animalType type, int groupCount) {
        List<FaunaHandler.SpawnListEntry> spawns = FaunaHandler.getSpawnableList(type);
        boolean found = false;
        for (FaunaHandler.SpawnListEntry entry : spawns) {
            if (entry.entityType != entityClass) continue;
            entry.field_76292_a = weightedProb;
            entry.groupCount = groupCount;
            found = true;
            break;
        }
        if (!found) {
            spawns.add(new FaunaHandler.SpawnListEntry(entityClass, weightedProb, groupCount));
        }
    }
}

