/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.mammal;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ComplexMobAquatic;
import untamedwilds.entity.INeedsPostUpdate;
import untamedwilds.entity.INewSkins;
import untamedwilds.entity.ISpecies;
import untamedwilds.entity.ai.SmartMateGoal;
import untamedwilds.init.ModEntity;
import untamedwilds.util.EntityUtils;

public class EntityManatee
extends ComplexMobAquatic
implements ISpecies,
INewSkins,
INeedsPostUpdate {
    private static final DataParameter<Boolean> IS_EATING = EntityDataManager.func_187226_a(EntityManatee.class, (IDataSerializer)DataSerializers.field_187198_h);
    public int ringBufferIndex = -1;
    public final double[][] ringBuffer = new double[64][3];

    public EntityManatee(EntityType<? extends ComplexMob> type, World worldIn) {
        super(type, worldIn);
        this.turn_speed = 0.1f;
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233823_f_, 2.0).func_233815_a_(Attributes.field_233824_g_, 0.0).func_233815_a_(Attributes.field_233821_d_, 0.45).func_233815_a_(Attributes.field_233819_b_, 8.0).func_233815_a_(Attributes.field_233818_a_, 30.0).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_(Attributes.field_233826_i_, 2.0);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(2, (Goal)new SmartMateGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new ManateeFeedGoal(this, 120));
        this.field_70714_bg.func_75776_a(4, (Goal)new ComplexMobAquatic.SwimGoal(this));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (this.isEating()) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, (double)-0.01f, 0.0));
            }
            if (this.field_70170_p.func_82737_E() % 4000L == 0L) {
                this.func_70691_i(1.0f);
            }
        }
        if (!this.func_175446_cd() && !this.func_70631_g_()) {
            if (this.ringBufferIndex < 0) {
                for (int i = 0; i < this.ringBuffer.length; ++i) {
                    this.ringBuffer[i][0] = this.field_70177_z;
                    this.ringBuffer[i][1] = this.func_226278_cu_();
                }
            }
            ++this.ringBufferIndex;
            if (this.ringBufferIndex == this.ringBuffer.length) {
                this.ringBufferIndex = 0;
            }
            this.ringBuffer[this.ringBufferIndex][0] = this.field_70126_B + 0.5f * MathHelper.func_76142_g((float)(this.field_70177_z - this.field_70126_B));
            this.ringBuffer[this.ringBufferIndex][1] = this.func_226278_cu_();
        }
    }

    public double[] getMovementOffsets(int offset, float partialTicks) {
        if (this.func_233643_dh_()) {
            partialTicks = 0.0f;
        }
        partialTicks = 1.0f - partialTicks;
        int i = this.ringBufferIndex - offset & 0x3F;
        int j = this.ringBufferIndex - offset - 1 & 0x3F;
        double[] adouble = new double[3];
        double d0 = this.ringBuffer[i][0];
        double d1 = this.ringBuffer[j][0] - d0;
        adouble[0] = d0 + d1 * (double)partialTicks;
        d0 = this.ringBuffer[i][1];
        d1 = this.ringBuffer[j][1] - d0;
        adouble[1] = d0 + d1 * (double)partialTicks;
        adouble[2] = MathHelper.func_219803_d((double)partialTicks, (double)this.ringBuffer[i][2], (double)this.ringBuffer[j][2]);
        return adouble;
    }

    @Override
    public boolean wantsToBreed() {
        if (((Boolean)ConfigGamerules.naturalBreeding.get()).booleanValue() && this.field_175504_a == 0 && EntityUtils.hasFullHealth((LivingEntity)this)) {
            List list = this.field_70170_p.func_217357_a(EntityManatee.class, this.func_174813_aQ().func_72314_b(12.0, 8.0, 12.0));
            list.removeIf(input -> EntityUtils.isInvalidPartner(this, input, false));
            if (list.size() >= 1) {
                this.func_70873_a(this.func_70874_b());
                ((EntityManatee)list.get(0)).func_70873_a(this.func_70874_b());
                return true;
            }
        }
        return false;
    }

    @Nullable
    public EntityManatee func_241840_a(ServerWorld serverWorld, AgeableEntity ageable) {
        return this.create_offspring(new EntityManatee(ModEntity.MANATEE, this.field_70170_p));
    }

    @Override
    protected SoundEvent getFlopSound() {
        return SoundEvents.field_187684_cg;
    }

    @Override
    public void updateAttributes() {
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a((double)EntityManatee.getEntityData(this.func_200600_R()).getSpeciesData().get(this.getVariant()).getAttack().floatValue());
        this.func_110148_a(Attributes.field_233818_a_).func_111128_a((double)EntityManatee.getEntityData(this.func_200600_R()).getSpeciesData().get(this.getVariant()).getHealth().floatValue());
        this.func_70606_j(this.func_110138_aP());
    }

    public boolean isEating() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_EATING);
    }

    private void setIsEating(boolean eating) {
        this.field_70180_af.func_187227_b(IS_EATING, (Object)eating);
    }

    public class ManateeFeedGoal
    extends Goal {
        private final EntityManatee taskOwner;
        private final int chance;
        private BlockPos targetPos;
        private boolean taskComplete;
        private int counter;
        private int eatingCounter;

        public ManateeFeedGoal(EntityManatee entityIn, int chance) {
            this.taskOwner = entityIn;
            this.chance = chance;
        }

        public boolean func_75250_a() {
            if (this.taskOwner.field_70146_Z.nextInt(this.chance) == 0) {
                this.taskComplete = false;
                this.targetPos = this.getNearbySandBlock(this.taskOwner.func_233580_cy_());
                return this.targetPos != null;
            }
            return false;
        }

        private BlockPos getNearbySandBlock(BlockPos roomCenter) {
            int X = 5;
            int Y = 8;
            for (BlockPos blockpos : BlockPos.Mutable.func_218278_a((BlockPos)roomCenter.func_177982_a(-X, -Y, -X), (BlockPos)roomCenter.func_177982_a(X, 0, X))) {
                if (this.taskOwner.field_70170_p.func_180495_p(blockpos).func_177230_c() != Blocks.field_203198_aQ || EntityManatee.this.field_70146_Z.nextInt(2) != 0) continue;
                return blockpos;
            }
            return null;
        }

        public boolean func_75253_b() {
            return !this.taskComplete && !this.taskOwner.func_70661_as().func_75500_f() && this.eatingCounter != 0;
        }

        public void start() {
            this.eatingCounter = -1;
            this.taskOwner.func_70661_as().func_75492_a((double)this.targetPos.func_177958_n() + 0.5, (double)this.targetPos.func_177984_a().func_177956_o(), (double)this.targetPos.func_177952_p() + 0.5, 1.5);
        }

        public void func_75251_c() {
            if (this.taskOwner.isEating()) {
                this.taskOwner.setIsEating(false);
            }
            super.func_75251_c();
        }

        public void func_75246_d() {
            if (this.eatingCounter > 0) {
                --this.eatingCounter;
            }
            if (this.counter == 0 && this.taskOwner.func_70092_e((double)this.targetPos.func_177958_n() + 0.5, this.targetPos.func_177984_a().func_177956_o(), (double)this.targetPos.func_177952_p() + 0.5) < 1.0) {
                this.taskOwner.func_70661_as().func_75499_g();
                this.counter = this.taskOwner.field_70146_Z.nextInt(20) + 30;
            }
            if (this.counter > 0) {
                --this.counter;
                if (this.counter == 0) {
                    this.taskOwner.setIsEating(true);
                    this.eatingCounter = this.taskOwner.field_70146_Z.nextInt(40) + 20;
                    this.taskOwner.func_70661_as().func_75499_g();
                    World worldIn = this.taskOwner.func_130014_f_();
                    this.taskOwner.func_70671_ap().func_220679_a((double)this.targetPos.func_177958_n(), (double)this.targetPos.func_177956_o(), (double)this.targetPos.func_177952_p());
                    if (worldIn.func_180495_p(this.targetPos).func_177230_c() == Blocks.field_203198_aQ && ForgeEventFactory.getMobGriefingEvent((World)worldIn, (Entity)this.taskOwner) && ((Boolean)ConfigGamerules.grazerGriefing.get()).booleanValue()) {
                        worldIn.func_175655_b(this.targetPos, false);
                    }
                    this.taskOwner.func_70615_aA();
                    this.taskOwner.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
                    this.taskComplete = true;
                }
            }
        }
    }
}

