/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.mammal;

import com.github.alexthe666.citadel.animation.Animation;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ComplexMobTerrestrial;
import untamedwilds.entity.INewSkins;
import untamedwilds.entity.ISpecies;
import untamedwilds.entity.ai.FindItemsGoal;
import untamedwilds.entity.ai.GotoSleepGoal;
import untamedwilds.entity.ai.SmartAvoidGoal;
import untamedwilds.entity.ai.SmartLookAtGoal;
import untamedwilds.entity.ai.SmartMateGoal;
import untamedwilds.entity.ai.SmartSwimGoal;
import untamedwilds.entity.ai.SmartWanderGoal;
import untamedwilds.init.ModEntity;
import untamedwilds.init.ModLootTables;
import untamedwilds.init.ModSounds;
import untamedwilds.util.EntityUtils;

public class EntityBoar
extends ComplexMobTerrestrial
implements ISpecies,
INewSkins {
    private BlockPos lastDugPos = null;
    public static Animation WORK_DIG;
    public static Animation ATTACK;
    public static Animation TALK;

    public EntityBoar(EntityType<? extends ComplexMob> type, World worldIn) {
        super(type, worldIn);
        this.turn_speed = 0.6f;
        WORK_DIG = Animation.create((int)48);
        ATTACK = Animation.create((int)18);
        TALK = Animation.create((int)20);
    }

    public void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SmartSwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new FindItemsGoal(this, 12, 100, false, true));
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.6, false));
        this.field_70714_bg.func_75776_a(2, (Goal)new SmartMateGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(2, new SmartAvoidGoal<LivingEntity>(this, LivingEntity.class, 16.0f, 1.2, 1.6, input -> EntityBoar.getEcoLevel(input) > EntityBoar.getEcoLevel((LivingEntity)this)));
        this.field_70714_bg.func_75776_a(3, (Goal)new GotoSleepGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new SmartWanderGoal(this, 1.0, 120, 20, true));
        this.field_70714_bg.func_75776_a(6, (Goal)new SmartLookAtGoal(this, LivingEntity.class, 10.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233823_f_, 3.0).func_233815_a_(Attributes.field_233821_d_, 0.2).func_233815_a_(Attributes.field_233819_b_, 24.0).func_233815_a_(Attributes.field_233818_a_, 16.0).func_233815_a_(Attributes.field_233820_c_, 0.6).func_233815_a_(Attributes.field_233826_i_, 2.0);
    }

    @Override
    public boolean wantsToBreed() {
        if (super.wantsToBreed()) {
            return !this.func_70608_bn() && this.func_70874_b() == 0 && EntityUtils.hasFullHealth((LivingEntity)this) && this.getHunger() >= 80;
        }
        return false;
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K) {
            this.setAngry(this.func_70638_az() != null);
            if (this.field_70173_aa % 600 == 0 && this.wantsToBreed()) {
                this.func_146082_f(null);
            }
            if (this.field_70170_p.func_82737_E() % 1000L == 0L) {
                this.addHunger(-10);
                if (!this.isStarving()) {
                    this.func_70691_i(1.0f);
                }
            }
            if (this.getAnimation() == NO_ANIMATION && this.func_70638_az() == null && !this.func_70608_bn() && this.getCommandInt() == 0) {
                int i = this.field_70146_Z.nextInt(3000);
                if (i == 13 && !this.func_70090_H() && this.isNotMoving() && this.canMove()) {
                    this.setSitting(true);
                }
                if (i == 14 && this.func_233685_eM_()) {
                    this.setSitting(false);
                }
                if (i > 2960 && i < 2979 && !this.func_70090_H() && !this.func_70631_g_()) {
                    this.setAnimation(TALK);
                }
                if (i > 2980 && !this.func_70090_H() && this.getHunger() < 60 && this.canMove() && this.getAnimation() == NO_ANIMATION && (this.lastDugPos == null || this.func_70092_e(this.lastDugPos.func_177958_n(), this.func_226278_cu_(), this.lastDugPos.func_177952_p()) > 50.0) && this.field_70170_p.func_180495_p(this.func_233580_cy_().func_177977_b()).getHarvestTool() == ToolType.SHOVEL) {
                    this.setAnimation(WORK_DIG);
                    this.addHunger(20);
                    this.lastDugPos = this.func_233580_cy_();
                }
            }
            if (this.getAnimation() == WORK_DIG && this.getAnimationTick() % 8 == 0) {
                ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, this.field_70170_p.func_180495_p(this.func_233580_cy_().func_177977_b())), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 20, 0.0, 0.0, 0.0, (double)0.15f);
                this.func_184185_a(SoundEvents.field_187771_eN, 0.8f, 0.6f);
                if (this.getAnimationTick() == 64 && this.field_70146_Z.nextInt(5) == 0) {
                    List<ItemStack> result = EntityUtils.getItemFromLootTable(ModLootTables.LOOT_DIGGING, this.field_70170_p);
                    for (ItemStack itemstack : result) {
                        this.func_199701_a_(itemstack);
                    }
                }
            }
            if (this.getAnimation() == TALK && this.getAnimationTick() == 1) {
                this.func_184185_a(this.func_184639_G(), this.func_70599_aP(), this.func_70647_i());
            }
            if (this.func_70638_az() != null && this.field_70173_aa % 120 == 0) {
                this.func_184185_a(this.getThreatSound(), this.func_70599_aP(), this.func_70647_i());
            }
            if (this.getAnimation() != NO_ANIMATION && this.getAnimation() == ATTACK && this.getAnimationTick() == 8 && this.field_70146_Z.nextInt(3) == 0) {
                this.func_184185_a(ModSounds.ENTITY_BOAR_SQUEAL, this.func_70599_aP(), this.func_70647_i());
            }
        }
        super.func_70636_d();
    }

    @Override
    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(Hand.MAIN_HAND);
        if (hand == Hand.MAIN_HAND && !this.field_70170_p.func_201670_d() && !this.func_70909_n() && this.func_70631_g_() && EntityUtils.hasFullHealth((LivingEntity)this) && this.func_70877_b(itemstack)) {
            this.func_184185_a(SoundEvents.field_187711_cp, 1.5f, 0.8f);
            if (this.func_70681_au().nextInt(3) == 0) {
                this.func_193101_c(player);
                EntityUtils.spawnParticlesOnEntity(this.field_70170_p, (LivingEntity)this, ParticleTypes.field_197633_z, 3, 6);
            } else {
                EntityUtils.spawnParticlesOnEntity(this.field_70170_p, (LivingEntity)this, ParticleTypes.field_197601_L, 3, 3);
            }
        }
        return super.func_230254_b_(player, hand);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = super.func_70652_k(entityIn);
        if (flag && this.getAnimation() == NO_ANIMATION && !this.func_70631_g_()) {
            this.setAnimation(ATTACK);
            this.setAnimationTick(0);
        }
        return flag;
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, WORK_DIG, ATTACK, TALK};
    }

    @Override
    public Animation getAnimationEat() {
        return WORK_DIG;
    }

    @Nullable
    public EntityBoar func_241840_a(ServerWorld serverWorld, AgeableEntity ageable) {
        return this.create_offspring(new EntityBoar(ModEntity.BOAR, this.field_70170_p));
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.lastDugPos != null) {
            compound.func_74768_a("DugPosX", this.lastDugPos.func_177958_n());
            compound.func_74768_a("DugPosZ", this.lastDugPos.func_177952_p());
        }
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("LastDugPos")) {
            this.lastDugPos = new BlockPos(compound.func_74762_e("DugPosX"), 0, compound.func_74762_e("DugPosZ"));
        }
    }
}

