/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.fish;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ComplexMobAquatic;
import untamedwilds.entity.INeedsPostUpdate;
import untamedwilds.entity.INewSkins;
import untamedwilds.entity.ISpecies;
import untamedwilds.entity.ai.MeleeAttackCircle;
import untamedwilds.entity.ai.SmartMateGoal;
import untamedwilds.entity.ai.target.HuntWeakerTarget;
import untamedwilds.entity.ai.unique.SharkSwimmingGoal;
import untamedwilds.init.ModEntity;
import untamedwilds.util.EntityUtils;

public class EntityShark
extends ComplexMobAquatic
implements ISpecies,
IAnimatedEntity,
INeedsPostUpdate,
INewSkins {
    private static final DataParameter<Boolean> SHORT_FINS = EntityDataManager.func_187226_a(EntityShark.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static Animation ATTACK_THRASH;
    private int animationTick;
    private Animation currentAnimation;

    public EntityShark(EntityType<? extends ComplexMob> type, World worldIn) {
        super(type, worldIn);
        ATTACK_THRASH = Animation.create((int)15);
        this.field_70728_aV = 10;
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233823_f_, 12.0).func_233815_a_(Attributes.field_233821_d_, 0.8).func_233815_a_(Attributes.field_233819_b_, 32.0).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_(Attributes.field_233818_a_, 50.0);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackCircle((CreatureEntity)this, 2.3, false, 2.0f));
        this.field_70714_bg.func_75776_a(3, (Goal)new SmartMateGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new SharkSwimmingGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(3, new HuntWeakerTarget<LivingEntity>(this, LivingEntity.class, true));
    }

    @Override
    public void func_70636_d() {
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        if (!this.field_70170_p.field_72995_K) {
            this.setAngry(this.func_70638_az() != null);
            if (this.field_70173_aa % 1000 == 0 && this.wantsToBreed() && !this.isMale()) {
                this.func_70873_a(this.getPregnancyTime());
            }
            if (this.field_70170_p.func_82737_E() % 4000L == 0L) {
                this.func_70691_i(1.0f);
            }
        }
        super.func_70636_d();
    }

    @Override
    public boolean wantsToBreed() {
        if (((Boolean)ConfigGamerules.naturalBreeding.get()).booleanValue() && this.func_70874_b() == 0 && EntityUtils.hasFullHealth((LivingEntity)this)) {
            List list = this.field_70170_p.func_217357_a(EntityShark.class, this.func_174813_aQ().func_72314_b(12.0, 8.0, 12.0));
            list.removeIf(input -> EntityUtils.isInvalidPartner(this, input, false));
            if (list.size() >= 1) {
                this.func_70873_a(this.func_70874_b());
                ((EntityShark)list.get(0)).func_70873_a(this.func_70874_b());
                return true;
            }
        }
        return false;
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageableEntity) {
        return this.create_offspring(new EntityShark(ModEntity.SHARK, this.field_70170_p));
    }

    @Override
    protected SoundEvent getFlopSound() {
        return SoundEvents.field_203818_az;
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = super.func_70652_k(entityIn);
        if (flag && this.getAnimation() == NO_ANIMATION && !this.func_70631_g_()) {
            this.setAnimation(ATTACK_THRASH);
        }
        return flag;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, ATTACK_THRASH};
    }

    public boolean isBottomDweller() {
        return EntityShark.getEntityData(this.func_200600_R()).getFlags(this.getVariant(), "bottomDweller") == 1;
    }

    @Override
    public void updateAttributes() {
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a((double)EntityShark.getEntityData(this.func_200600_R()).getSpeciesData().get(this.getVariant()).getAttack().floatValue());
        this.func_110148_a(Attributes.field_233818_a_).func_111128_a((double)EntityShark.getEntityData(this.func_200600_R()).getSpeciesData().get(this.getVariant()).getHealth().floatValue());
        this.func_70606_j(this.func_110138_aP());
        this.setShortFins(EntityShark.getEntityData(this.func_200600_R()).getFlags(this.getVariant(), "shortFins") == 1);
    }

    public boolean hasShortFins() {
        return (Boolean)this.field_70180_af.func_187225_a(SHORT_FINS);
    }

    private void setShortFins(boolean short_fins) {
        this.field_70180_af.func_187227_b(SHORT_FINS, (Object)short_fins);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("hasShortFins", this.hasShortFins());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setShortFins(compound.func_74767_n("hasShortFins"));
    }
}

