/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.amphibian;

import com.github.alexthe666.citadel.animation.Animation;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ComplexMobAmphibious;
import untamedwilds.entity.ComplexMobAquatic;
import untamedwilds.entity.INeedsPostUpdate;
import untamedwilds.entity.INewSkins;
import untamedwilds.entity.ISpecies;
import untamedwilds.entity.ai.AmphibiousRandomSwimGoal;
import untamedwilds.entity.ai.AmphibiousTransition;
import untamedwilds.entity.ai.SmartAvoidGoal;
import untamedwilds.entity.ai.SmartMateGoal;
import untamedwilds.entity.ai.SmartMeleeAttackGoal;
import untamedwilds.entity.ai.target.HuntMobTarget;
import untamedwilds.util.EntityUtils;

public class EntityGiantSalamander
extends ComplexMobAmphibious
implements ISpecies,
INeedsPostUpdate,
INewSkins {
    public static Animation ATTACK_SWALLOW;
    public int swimProgress;

    public EntityGiantSalamander(EntityType<? extends ComplexMob> type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new ComplexMobAquatic.MoveHelperController(this, 0.6f);
        ATTACK_SWALLOW = Animation.create((int)15);
        this.field_70728_aV = 1;
        this.swimSpeedMult = 3.0f;
        this.buoyancy = 0.992f;
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233823_f_, 2.0).func_233815_a_(Attributes.field_233821_d_, 0.16).func_233815_a_(Attributes.field_233819_b_, 8.0).func_233815_a_(Attributes.field_233818_a_, 10.0).func_233815_a_(Attributes.field_233820_c_, 0.0);
    }

    public void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(2, (Goal)new SmartMeleeAttackGoal((CreatureEntity)this, 1.4, false));
        this.field_70714_bg.func_75776_a(2, (Goal)new SmartMateGoal(this, 0.7));
        this.field_70714_bg.func_75776_a(2, new SmartAvoidGoal<LivingEntity>(this, LivingEntity.class, (float)this.func_233637_b_(Attributes.field_233819_b_), 1.0, 1.1, input -> EntityGiantSalamander.getEcoLevel(input) > EntityGiantSalamander.getEcoLevel((LivingEntity)this)));
        this.field_70714_bg.func_75776_a(3, (Goal)new AmphibiousTransition(this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new AmphibiousRandomSwimGoal(this, 0.7, 600));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(3, new HuntMobTarget<LivingEntity>(this, LivingEntity.class, true, false, input -> EntityGiantSalamander.getEcoLevel(input) < EntityGiantSalamander.getEcoLevel((LivingEntity)this)));
    }

    @Override
    public boolean wantsToLeaveWater() {
        return this.field_70170_p.func_175727_C(this.func_233580_cy_());
    }

    @Override
    public boolean wantsToEnterWater() {
        return true;
    }

    public boolean func_96092_aw() {
        return false;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70173_aa % 1000 == 0 && this.wantsToBreed() && !this.isMale()) {
                this.breed();
            }
            if (this.field_70170_p.func_82737_E() % 4000L == 0L) {
                this.func_70691_i(1.0f);
            }
        } else if (this.func_70090_H() && !this.func_233570_aj_() && this.swimProgress < 20) {
            ++this.swimProgress;
        } else if ((!this.func_70090_H() || this.func_233570_aj_()) && this.swimProgress > 0) {
            --this.swimProgress;
        }
    }

    @Override
    public boolean wantsToBreed() {
        if (super.wantsToBreed() && !this.func_70608_bn() && this.func_70874_b() == 0 && EntityUtils.hasFullHealth((LivingEntity)this)) {
            List list = this.field_70170_p.func_217357_a(EntityGiantSalamander.class, this.func_174813_aQ().func_72314_b(6.0, 4.0, 6.0));
            list.removeIf(input -> EntityUtils.isInvalidPartner(this, input, false));
            if (list.size() >= 1) {
                this.func_70873_a(this.func_70874_b());
                ((EntityGiantSalamander)list.get(0)).func_70873_a(this.func_70874_b());
                return true;
            }
        }
        return false;
    }

    public boolean func_70652_k(Entity entityIn) {
        float f = (float)this.func_110148_a(Attributes.field_233823_f_).func_111126_e();
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), f);
        if (flag) {
            if (entityIn instanceof LivingEntity && entityIn.func_213311_cf() * entityIn.func_213302_cg() < 0.4f && entityIn instanceof TameableEntity && !((TameableEntity)entityIn).func_70909_n()) {
                this.setAnimation(ATTACK_SWALLOW);
                this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_226131_af_, SoundCategory.BLOCKS, 1.0f, 1.0f);
                EntityUtils.spawnParticlesOnEntity(this.field_70170_p, (LivingEntity)entityIn, ParticleTypes.field_197598_I, 6, 2);
                this.func_213317_d(new Vector3d(entityIn.func_226277_ct_() - this.func_226277_ct_(), entityIn.func_226278_cu_() - this.func_226278_cu_(), entityIn.func_226281_cx_() - this.func_226281_cx_()).func_186678_a((double)0.15f));
                this.peacefulTicks = 12000;
                entityIn.func_70106_y();
            }
            return true;
        }
        return false;
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageableEntity) {
        EntityUtils.dropEggs(this, "egg_giant_salamander", this.getOffspring());
        return null;
    }

    @Override
    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(Hand.MAIN_HAND);
        if (hand == Hand.MAIN_HAND && itemstack.func_77973_b().equals(Items.field_151131_as) && this.func_70089_S()) {
            EntityUtils.mutateEntityIntoItem((LivingEntity)this, player, hand, "bucket_giant_salamander", itemstack);
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return super.func_230254_b_(player, hand);
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        SoundEvent soundevent = this.func_70631_g_() ? SoundEvents.field_203267_iG : SoundEvents.field_203266_iF;
        this.func_184185_a(soundevent, 0.15f, 1.0f);
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, ATTACK_SWALLOW};
    }

    @Override
    public void updateAttributes() {
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a((double)EntityGiantSalamander.getEntityData(this.func_200600_R()).getSpeciesData().get(this.getVariant()).getAttack().floatValue());
        this.func_110148_a(Attributes.field_233818_a_).func_111128_a((double)EntityGiantSalamander.getEntityData(this.func_200600_R()).getSpeciesData().get(this.getVariant()).getHealth().floatValue());
        this.func_70606_j(this.func_110138_aP());
    }
}

