/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.ai.target;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.util.EntityPredicates;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ai.target.HuntMobTarget;
import untamedwilds.util.EntityUtils;

public class HuntWeakerTarget<T extends LivingEntity>
extends HuntMobTarget<T> {
    private final int executionChance;

    public HuntWeakerTarget(ComplexMob creature, Class<T> classTarget, boolean checkSight) {
        this(creature, classTarget, checkSight, false);
    }

    public HuntWeakerTarget(ComplexMob creature, Class<T> classTarget, boolean checkSight, boolean onlyNearby) {
        this(creature, classTarget, 300, checkSight, onlyNearby, (? super LivingEntity input) -> !EntityUtils.hasFullHealth(input));
    }

    public HuntWeakerTarget(ComplexMob creature, Class<T> classTarget, int chance, boolean checkSight, boolean onlyNearby, Predicate<? super LivingEntity> targetSelector) {
        super(creature, classTarget, checkSight, 200, false, EntityPredicates.field_180132_d);
        this.executionChance = chance;
        this.targetEntitySelector = entity -> {
            if (targetSelector != null && !targetSelector.test((LivingEntity)entity)) {
                return false;
            }
            if (entity instanceof ComplexMob) {
                ComplexMob ctarget = (ComplexMob)((Object)entity);
                return this.field_75299_d.getClass() == entity.getClass() && ((ComplexMob)this.field_75299_d).getVariant() == ctarget.getVariant() || !ctarget.canBeTargeted();
            }
            return this.func_220777_a((LivingEntity)entity, EntityPredicate.field_221016_a);
        };
    }

    @Override
    public boolean func_75250_a() {
        if (this.field_75299_d.func_70631_g_() || this.field_75299_d.func_70681_au().nextInt(this.executionChance) != 0) {
            return false;
        }
        double perception = this.field_75299_d.func_110148_a(Attributes.field_233819_b_).func_111126_e();
        List list = this.field_75299_d.field_70170_p.func_175647_a(this.targetClass, this.field_75299_d.func_174813_aQ().func_72314_b(perception, 8.0, perception), this.targetEntitySelector);
        list.removeIf(this::shouldRemoveTarget);
        if (list.isEmpty()) {
            return false;
        }
        list.sort(this.sorter);
        this.targetEntity = (LivingEntity)list.get(0);
        return true;
    }

    @Override
    public boolean shouldRemoveTarget(LivingEntity entity) {
        if (entity instanceof CreeperEntity || entity == this.field_75299_d || entity.func_184187_bx() != null) {
            return true;
        }
        if (entity instanceof ComplexMob && (double)(entity.func_110143_aJ() / entity.func_110138_aP()) > 0.8) {
            ComplexMob ctarget = (ComplexMob)entity;
            return this.field_75299_d.getClass() == entity.getClass() && ((ComplexMob)this.field_75299_d).getVariant() == ctarget.getVariant() || !ctarget.canBeTargeted();
        }
        return false;
    }
}

