/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.ai;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.entity.ComplexMob;

public class SmartMateGoal
extends Goal {
    private final ComplexMob taskOwner;
    private final World world;
    private final int executionChance;
    private final Class<? extends ComplexMob> mateClass;
    private ComplexMob targetMate;
    private int spawnBabyDelay;
    private final double moveSpeed;

    public SmartMateGoal(ComplexMob entityIn, double speedIn) {
        this(entityIn, speedIn, 120, ((Object)((Object)entityIn)).getClass());
    }

    private SmartMateGoal(ComplexMob entityIn, double speedIn, int chance, Class<? extends ComplexMob> mateClass) {
        this.taskOwner = entityIn;
        this.world = entityIn.field_70170_p;
        this.mateClass = mateClass;
        this.executionChance = chance;
        this.moveSpeed = speedIn;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        if (!this.taskOwner.func_70880_s() || this.taskOwner.func_70874_b() != 0) {
            return false;
        }
        if (this.taskOwner.func_70681_au().nextInt(this.executionChance) != 0) {
            return false;
        }
        this.targetMate = this.getNearbyMate();
        return this.targetMate != null;
    }

    public boolean func_75253_b() {
        return this.targetMate.func_70089_S() && this.targetMate.func_70880_s() && this.spawnBabyDelay < 200;
    }

    public void func_75251_c() {
        this.targetMate = null;
        this.spawnBabyDelay = 0;
    }

    public void func_75246_d() {
        this.taskOwner.func_70671_ap().func_75651_a((Entity)this.targetMate, 10.0f, (float)this.taskOwner.func_70646_bf());
        this.taskOwner.func_70661_as().func_75492_a(this.targetMate.func_226277_ct_(), this.targetMate.func_226278_cu_(), this.targetMate.func_226281_cx_(), this.moveSpeed);
        ++this.spawnBabyDelay;
        if (this.spawnBabyDelay >= 100 && this.taskOwner.func_70068_e((Entity)this.targetMate) < 9.0) {
            this.taskOwner.func_70875_t();
            this.targetMate.func_70875_t();
            if (this.world.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
                this.world.func_217376_c((Entity)new ExperienceOrbEntity(this.world, this.taskOwner.func_226277_ct_(), this.taskOwner.func_226278_cu_(), this.taskOwner.func_226281_cx_(), this.taskOwner.func_70681_au().nextInt(7) + 1));
            }
            this.taskOwner.func_70873_a(this.taskOwner.getPregnancyTime());
            this.targetMate.func_70873_a(this.taskOwner.getPregnancyTime());
            if (((Boolean)ConfigGamerules.easyBreeding.get()).booleanValue()) {
                if (!this.taskOwner.isMale()) {
                    this.taskOwner.breed();
                } else {
                    this.targetMate.breed();
                }
            }
        }
    }

    private ComplexMob getNearbyMate() {
        List list = this.world.func_217357_a(this.mateClass, this.taskOwner.func_174813_aQ().func_186662_g(8.0));
        list.remove((Object)this.taskOwner);
        double d0 = Double.MAX_VALUE;
        ComplexMob entityanimal = null;
        for (ComplexMob potentialMates : list) {
            if (!this.canMateWith(this.taskOwner, potentialMates) || !(this.taskOwner.func_70068_e((Entity)potentialMates) < d0)) continue;
            entityanimal = potentialMates;
            d0 = this.taskOwner.func_70068_e((Entity)potentialMates);
        }
        return entityanimal;
    }

    private boolean canMateWith(ComplexMob father, ComplexMob mother) {
        if (((Boolean)ConfigGamerules.genderedBreeding.get()).booleanValue() && father.getGender() == mother.getGender()) {
            return false;
        }
        if (father.getVariant() != mother.getVariant()) {
            return false;
        }
        if (((Boolean)ConfigGamerules.playerBreeding.get()).booleanValue()) {
            return true;
        }
        return father.wantsToBreed() && mother.wantsToBreed();
    }
}

