/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.ai;

import java.util.EnumSet;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import untamedwilds.entity.ComplexMob;

public class SmartFollowOwnerGoal
extends Goal {
    protected final ComplexMob taskOwner;
    private LivingEntity owner;
    protected final IWorldReader world;
    private final double followSpeed;
    private final PathNavigator navigator;
    private int timeToRecalcPath;
    private final float maxDist;
    private final float minDist;
    private float oldWaterCost;

    public SmartFollowOwnerGoal(ComplexMob entityIn, double speedIn, float minDistIn, float maxDistIn) {
        this.taskOwner = entityIn;
        this.world = this.taskOwner.field_70170_p;
        this.followSpeed = speedIn;
        this.navigator = entityIn.func_70661_as();
        this.minDist = minDistIn;
        this.maxDist = maxDistIn;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!(entityIn.func_70661_as() instanceof GroundPathNavigator) && !(entityIn.func_70661_as() instanceof FlyingPathNavigator)) {
            throw new IllegalArgumentException("Unsupported mob type for SmartFollowOwnerGoal");
        }
    }

    public boolean func_75250_a() {
        LivingEntity owner = this.taskOwner.func_70902_q();
        if (owner == null || owner.func_175149_v() || !this.taskOwner.canMove() || this.taskOwner.func_70068_e((Entity)owner) < (double)(this.minDist * this.minDist)) {
            return false;
        }
        this.owner = owner;
        return this.taskOwner.getCommandInt() == 1;
    }

    public boolean func_75253_b() {
        return !this.navigator.func_75500_f() && this.taskOwner.func_70068_e((Entity)this.owner) > (double)(this.maxDist * this.maxDist) && !this.taskOwner.func_233685_eM_();
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.taskOwner.func_184643_a(PathNodeType.WATER);
        this.taskOwner.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public void func_75251_c() {
        this.owner = null;
        this.navigator.func_75499_g();
        this.taskOwner.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
    }

    public void func_75246_d() {
        this.taskOwner.func_70671_ap().func_75651_a((Entity)this.owner, 10.0f, (float)this.taskOwner.func_70646_bf());
        if (this.taskOwner.canMove() && this.taskOwner.getCommandInt() == 1 && --this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            if (!this.navigator.func_75497_a((Entity)this.owner, this.followSpeed) && !this.taskOwner.func_110167_bD() && !this.taskOwner.func_184218_aH() && this.taskOwner.func_70068_e((Entity)this.owner) >= 225.0) {
                int newPosX = MathHelper.func_76128_c((double)this.owner.func_226277_ct_()) - 2;
                int newPosZ = MathHelper.func_76128_c((double)this.owner.func_226281_cx_()) - 2;
                int newPosY = MathHelper.func_76128_c((double)this.owner.func_174813_aQ().field_72338_b);
                for (int i = 0; i <= 4; ++i) {
                    for (int j = 0; j <= 4; ++j) {
                        if (i >= 1 && j >= 1 && i <= 3 && j <= 3 || !this.canTeleportToBlock(new BlockPos((double)((float)(newPosX + i) + 0.5f), (double)(newPosY - 1), (double)((float)(newPosZ + j) + 0.5f)))) continue;
                        this.taskOwner.func_70012_b((float)(newPosX + i) + 0.5f, newPosY, (float)(newPosZ + j) + 0.5f, this.taskOwner.field_70177_z, this.taskOwner.field_70125_A);
                        this.navigator.func_75499_g();
                        return;
                    }
                }
            }
        }
    }

    protected boolean canTeleportToBlock(BlockPos pos) {
        BlockState state = this.world.func_180495_p(pos);
        return state.func_215688_a((IBlockReader)this.world, pos, this.taskOwner.func_200600_R()) && this.world.func_226664_a_(this.taskOwner.func_200600_R().func_220328_a((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 2), (double)pos.func_177952_p()));
    }
}

