/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.ai;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import untamedwilds.entity.ComplexMobTerrestrial;

public class RaidCropsGoal
extends Goal {
    private BlockPos targetPos;
    private final ComplexMobTerrestrial taskOwner;
    private boolean continueTask;

    public RaidCropsGoal(ComplexMobTerrestrial entityIn) {
        this.taskOwner = entityIn;
        this.continueTask = true;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        if (this.taskOwner.func_70909_n() || !ForgeEventFactory.getMobGriefingEvent((World)this.taskOwner.field_70170_p, (Entity)this.taskOwner)) {
            return false;
        }
        if (this.taskOwner.getHunger() > 80 || this.taskOwner.func_70638_az() != null) {
            return false;
        }
        if (this.taskOwner.func_70681_au().nextInt(120) != 0) {
            return false;
        }
        BlockPos pos = this.taskOwner.func_233580_cy_();
        this.targetPos = this.getNearbyFarmland(pos);
        return this.targetPos != null;
    }

    public void func_75249_e() {
        this.taskOwner.func_70661_as().func_75492_a((double)this.targetPos.func_177958_n() + 0.5, (double)(this.targetPos.func_177956_o() + 1), (double)this.targetPos.func_177952_p() + 0.5, 1.0);
    }

    public void func_75246_d() {
        if (this.taskOwner.func_70092_e(this.targetPos.func_177958_n(), this.targetPos.func_177956_o(), this.targetPos.func_177952_p()) < 4.0) {
            BlockState block = this.taskOwner.field_70170_p.func_180495_p(this.targetPos);
            if (block.func_177230_c() instanceof CropsBlock) {
                LootContext.Builder loot = new LootContext.Builder((ServerWorld)this.taskOwner.field_70170_p).func_216015_a(LootParameters.field_237457_g_, (Object)this.taskOwner.func_213303_ch()).func_216023_a(this.taskOwner.func_70681_au()).func_186469_a(1.0f);
                List drops = block.func_177230_c().func_220076_a(block, loot);
                if (!drops.isEmpty()) {
                    this.taskOwner.addHunger(Math.max(drops.size() * 10, 10));
                    this.taskOwner.field_70170_p.func_175655_b(this.targetPos, false);
                    this.taskOwner.func_70661_as().func_75499_g();
                }
            }
            this.continueTask = false;
        }
    }

    public boolean func_75253_b() {
        if (this.taskOwner.getHunger() > 80 || this.taskOwner.field_70170_p.func_175623_d(this.targetPos)) {
            return false;
        }
        return this.continueTask;
    }

    private BlockPos getNearbyFarmland(BlockPos roomCenter) {
        int X = 15;
        int Y = 3;
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)roomCenter.func_177982_a(-X, -Y, -X), (BlockPos)roomCenter.func_177982_a(X, Y, X))) {
            if (!(this.taskOwner.field_70170_p.func_180495_p(blockpos).func_177230_c() instanceof FarmlandBlock) || !this.hasPlantedCrop((IWorldReader)this.taskOwner.field_70170_p, blockpos)) continue;
            return blockpos.func_177984_a();
        }
        return null;
    }

    private boolean hasPlantedCrop(IWorldReader worldIn, BlockPos pos) {
        BlockState block = worldIn.func_180495_p(pos.func_177984_a());
        return block.func_177230_c() instanceof CropsBlock;
    }
}

