/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.ai;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.math.AxisAlignedBB;
import untamedwilds.entity.ComplexMobTerrestrial;

public class FindItemsGoal
extends Goal {
    private final ComplexMobTerrestrial taskOwner;
    private final ClosestSorter sorter;
    private final int distance;
    private ItemEntity targetItem;
    private Food targetItemStack;
    private final int executionChance;
    private final boolean hyperCarnivore;
    private final boolean hyperHerbivore;

    public FindItemsGoal(ComplexMobTerrestrial entityIn, int distance) {
        this(entityIn, distance, 100, false, false);
    }

    public FindItemsGoal(ComplexMobTerrestrial entityIn, int distance, boolean hyperCarnivore) {
        this(entityIn, distance, 100, hyperCarnivore, false);
    }

    public FindItemsGoal(ComplexMobTerrestrial entityIn, int distance, int chance, boolean hyperCarnivore, boolean hyperHerbivore) {
        this.taskOwner = entityIn;
        this.sorter = new ClosestSorter((Entity)entityIn);
        this.distance = distance;
        this.executionChance = chance;
        this.hyperCarnivore = hyperCarnivore;
        this.hyperHerbivore = hyperHerbivore;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.TARGET));
    }

    public boolean func_75250_a() {
        if (this.taskOwner.getHunger() > 80 || this.taskOwner.func_70631_g_() || this.taskOwner.func_70608_bn()) {
            return false;
        }
        if (this.taskOwner.func_70681_au().nextInt(this.executionChance) != 0) {
            return false;
        }
        List list = this.taskOwner.field_70170_p.func_217357_a(ItemEntity.class, this.getTargettableArea(this.distance));
        list.removeIf(item -> !item.func_92059_d().func_222117_E());
        if (!list.isEmpty()) {
            if (this.hyperCarnivore) {
                list.removeIf(item -> !this.isMeat(item.func_92059_d().func_77973_b()));
            } else if (this.hyperHerbivore) {
                list.removeIf(item -> this.isMeat(item.func_92059_d().func_77973_b()));
            }
            if (!list.isEmpty()) {
                list.sort(this.sorter);
                this.targetItem = (ItemEntity)list.get(0);
                this.targetItemStack = this.targetItem.func_92059_d().func_77973_b().func_219967_s();
                return true;
            }
        }
        return false;
    }

    private AxisAlignedBB getTargettableArea(double targetDistance) {
        return this.taskOwner.func_174813_aQ().func_72314_b(targetDistance, 4.0, targetDistance);
    }

    private boolean isMeat(Item item) {
        if (item.getItem().getItem().func_219967_s() == null) {
            return false;
        }
        return item.getItem().getItem().func_219967_s().func_221467_c() || item.getItem().getItem().func_206844_a((ITag)ItemTags.field_206964_G);
    }

    public void func_75249_e() {
        this.taskOwner.func_70661_as().func_75492_a(this.targetItem.func_226277_ct_(), this.targetItem.func_226278_cu_(), this.targetItem.func_226281_cx_(), 1.0);
    }

    public boolean func_75253_b() {
        if (this.targetItem == null || !this.targetItem.func_70089_S()) {
            return false;
        }
        if (!this.taskOwner.canMove()) {
            return false;
        }
        return !this.taskOwner.func_70781_l();
    }

    public void func_75246_d() {
        double distance = Math.sqrt(Math.pow(this.taskOwner.func_226277_ct_() - this.targetItem.func_226277_ct_(), 2.0) + Math.pow(this.taskOwner.func_226281_cx_() - this.targetItem.func_226281_cx_(), 2.0));
        if (distance < 1.5) {
            this.taskOwner.addHunger(Math.max(this.targetItemStack.func_221466_a() * 10, 10));
            this.targetItem.func_92059_d().func_190918_g(1);
            this.taskOwner.setAnimation(this.taskOwner.getAnimationEat());
        }
        if (this.taskOwner.func_70661_as().func_75500_f()) {
            this.func_75251_c();
        }
        this.taskOwner.func_70661_as().func_75492_a(this.targetItem.func_226277_ct_(), this.targetItem.func_226278_cu_(), this.targetItem.func_226281_cx_(), 1.0);
    }

    public static class ClosestSorter
    implements Comparator<Entity> {
        private final Entity entity;

        private ClosestSorter(Entity entityIn) {
            this.entity = entityIn;
        }

        @Override
        public int compare(Entity entity_1, Entity entity_2) {
            double dist_2;
            double dist_1 = this.entity.func_70068_e(entity_1);
            if (dist_1 < (dist_2 = this.entity.func_70068_e(entity_2))) {
                return -1;
            }
            return dist_1 > dist_2 ? 1 : 0;
        }
    }
}

