/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.block.blockentity;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import untamedwilds.config.ConfigMobControl;
import untamedwilds.entity.ComplexMob;
import untamedwilds.init.ModBlock;
import untamedwilds.util.EntityUtils;

public class CritterBurrowBlockEntity
extends TileEntity
implements ITickableTileEntity {
    private final List<Inhabitants> inhabitants = Lists.newArrayList();
    private EntityType<?> entityType;
    private int variant;
    private int count;
    public int cooldown = 0;

    public CritterBurrowBlockEntity() {
        super((TileEntityType)ModBlock.TILE_ENTITY_BURROW.get());
    }

    public int getSumMobs() {
        return this.inhabitants.size() + this.count;
    }

    public boolean hasNoMobs() {
        return this.getSumMobs() == 0;
    }

    public void tryEnterBurrow(LivingEntity entityIn) {
        entityIn.func_184210_p();
        entityIn.func_184226_ay();
        CompoundNBT compoundnbt = EntityUtils.writeEntityToNBT(entityIn, true);
        this.inhabitants.add(new Inhabitants(compoundnbt));
        if (this.field_145850_b != null) {
            BlockPos blockpos = this.func_174877_v();
            this.field_145850_b.func_184148_a(null, (double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), SoundEvents.field_226131_af_, SoundCategory.BLOCKS, 1.0f, 1.0f);
            EntityUtils.spawnParticlesOnEntity(this.field_145850_b, entityIn, ParticleTypes.field_197598_I, 3, 6);
        }
        entityIn.func_70106_y();
        this.func_70296_d();
    }

    public void setCount(int newCount) {
        this.count = newCount;
    }

    public int getCount() {
        return this.count;
    }

    public void setVariant(int variant) {
        this.variant = variant;
    }

    public int getVariant() {
        return this.variant;
    }

    public void setEntityType(EntityType<?> type) {
        this.entityType = type;
    }

    public EntityType<?> getEntityType() {
        return this.entityType;
    }

    public void func_73660_a() {
        if (this.cooldown > 0) {
            --this.cooldown;
        }
        if (this.cooldown == 0 && this.field_145850_b != null && !this.field_145850_b.field_72995_K && !this.hasNoMobs() && this.getEntityType() != null && (double)this.field_145850_b.func_201674_k().nextFloat() < Math.min(0.01, 0.002 * (double)(this.getSumMobs() * this.getSumMobs()))) {
            BlockPos blockpos = this.func_174877_v();
            if (this.func_145831_w().func_217358_a((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.5, (double)blockpos.func_177952_p() + 0.5, (double)((Integer)ConfigMobControl.critterSpawnRange.get()).intValue())) {
                Entity spawn;
                ServerWorld worldIn = (ServerWorld)this.field_145850_b;
                if (!this.getInhabitants().isEmpty()) {
                    int i = worldIn.field_73012_v.nextInt(this.inhabitants.size());
                    Entity spawn2 = this.getEntityType().func_220349_b(worldIn, this.inhabitants.get(i).entityData, null, null, blockpos, SpawnReason.DISPENSER, true, false);
                    if (spawn2 != null) {
                        worldIn.func_217376_c(spawn2);
                        this.inhabitants.remove(i);
                        this.func_70296_d();
                    }
                } else if (this.getCount() > 0 && this.getEntityType() != null && (spawn = this.getEntityType().func_200721_a((World)worldIn)) != null) {
                    spawn.func_70012_b((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p() + 0.5, MathHelper.func_76142_g((float)(worldIn.field_73012_v.nextFloat() * 360.0f)), 0.0f);
                    if (spawn instanceof MobEntity) {
                        ((MobEntity)spawn).func_213386_a((IServerWorld)worldIn, worldIn.func_175649_E(blockpos), SpawnReason.CHUNK_GENERATION, null, null);
                    }
                    if (spawn instanceof ComplexMob) {
                        ComplexMob entitySpawn = (ComplexMob)spawn;
                        entitySpawn.setVariant(EntityUtils.getClampedNumberOfSpecies(this.variant, this.entityType));
                        entitySpawn.setHome(this.func_174877_v());
                    }
                    worldIn.func_217376_c(spawn);
                    this.setCount(this.getCount() - 1);
                    this.func_70296_d();
                }
                if (this.field_145850_b.func_201674_k().nextInt(10) == 0 && this.getCount() < 10) {
                    this.setCount(this.getCount() + 1);
                }
                this.cooldown = 200 + this.field_145850_b.func_201674_k().nextInt(2000);
            }
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.inhabitants.clear();
        ListNBT listnbt = nbt.func_150295_c("Inhabitants", 10);
        this.setVariant(nbt.func_74762_e("Variant"));
        this.setCount(nbt.func_74762_e("Count"));
        this.cooldown = nbt.func_74762_e("Cooldown");
        if (nbt.func_74764_b("entityType")) {
            this.setEntityType(EntityType.func_220327_a((String)nbt.func_74779_i("entityType")).orElse(null));
        }
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundNBT compoundnbt = listnbt.func_150305_b(i);
            Inhabitants beehivetileentity$bee = new Inhabitants(compoundnbt.func_74775_l("EntityData"));
            this.inhabitants.add(beehivetileentity$bee);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_218657_a("Inhabitants", (INBT)this.getInhabitants());
        compound.func_74768_a("Count", this.getCount());
        compound.func_74768_a("Variant", this.getVariant());
        compound.func_74768_a("Cooldown", this.cooldown / 3);
        if (this.getEntityType() != null) {
            compound.func_74778_a("entityType", this.getEntityType().getRegistryName().toString());
        }
        return compound;
    }

    public ListNBT getInhabitants() {
        ListNBT listnbt = new ListNBT();
        for (Inhabitants inhabitant : this.inhabitants) {
            CompoundNBT compoundnbt = new CompoundNBT();
            compoundnbt.func_218657_a("EntityData", (INBT)inhabitant.entityData);
            listnbt.add((Object)compoundnbt);
        }
        return listnbt;
    }

    static class Inhabitants {
        private final CompoundNBT entityData;

        private Inhabitants(CompoundNBT nbt) {
            nbt.func_82580_o("UUID");
            this.entityData = nbt;
        }
    }
}

