/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.block.blockentity;

import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.server.ServerWorld;
import untamedwilds.UntamedWilds;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.init.ModBlock;
import untamedwilds.init.ModTags;
import untamedwilds.util.EntityUtils;

public class CageBlockEntity
extends TileEntity {
    private CompoundNBT spawndata;
    private boolean caged;

    public CageBlockEntity() {
        super((TileEntityType)ModBlock.TILE_ENTITY_CAGE.get());
    }

    public static boolean isBlacklisted(Entity entity) {
        return EntityTypeTags.func_219762_a().func_199910_a(ModTags.EntityTags.CAGE_BLACKLIST).func_230235_a_((Object)entity.func_200600_R());
    }

    public boolean cageEntity(MobEntity entity) {
        if (!(this.hasCagedEntity() || CageBlockEntity.isBlacklisted((Entity)entity) || !((Boolean)ConfigGamerules.easyMobCapturing.get()).booleanValue() && entity.func_70638_az() != null)) {
            this.setTagCompound(EntityUtils.writeEntityToNBT((LivingEntity)entity));
            this.setCagedEntity(true);
            entity.func_70106_y();
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public boolean spawnCagedCreature(ServerWorld worldIn, BlockPos pos, boolean offsetHitbox) {
        EntityType<?> entity;
        if (!worldIn.field_72995_K && this.hasCagedEntity() && (entity = EntityUtils.getEntityTypeFromTag(this.getTagCompound(), null)) != null && worldIn.func_226664_a_(entity.func_220328_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() - (offsetHitbox ? entity.func_220344_i() + 0.4f : 0.0f)), (double)((float)pos.func_177952_p() + 0.5f)))) {
            if (worldIn.func_217461_a(this.spawndata.func_74775_l("EntityTag").func_186857_a("UUID")) != null) {
                UntamedWilds.LOGGER.info("Randomizing UUID for mob");
                this.spawndata.func_74775_l("EntityTag").func_186854_a("UUID", MathHelper.func_180182_a((Random)worldIn.field_73012_v));
            }
            Entity caged_entity = entity.func_220349_b(worldIn, this.spawndata, null, null, pos, SpawnReason.DISPENSER, true, !Objects.equals(pos, this.func_174877_v()));
            caged_entity.func_70012_b((double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o() - (offsetHitbox ? (double)caged_entity.func_213302_cg() + 0.4 : 0.8), (double)((float)pos.func_177952_p() + 0.5f), MathHelper.func_76142_g((float)(worldIn.field_73012_v.nextFloat() * 360.0f)), 0.0f);
            if (!worldIn.func_217440_f(caged_entity)) {
                caged_entity.func_184221_a(MathHelper.func_180182_a((Random)worldIn.field_73012_v));
                worldIn.func_217376_c(caged_entity);
            }
            this.setTagCompound(null);
            this.caged = true;
            return true;
        }
        return false;
    }

    @Nullable
    public CompoundNBT getTagCompound() {
        return this.spawndata;
    }

    private void setTagCompound(@Nullable CompoundNBT nbt) {
        this.spawndata = nbt;
    }

    public boolean hasTagCompound() {
        return this.spawndata != null;
    }

    public boolean hasCagedEntity() {
        return this.caged;
    }

    private void setCagedEntity(boolean trap) {
        this.caged = trap;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.setTagCompound(compound.func_74737_b());
        this.setCagedEntity(compound.func_74767_n("closed"));
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("closed", this.hasCagedEntity());
        if (this.getTagCompound() != null) {
            compound.func_218657_a("EntityTag", (INBT)this.getTagCompound().func_74775_l("EntityTag"));
        }
        return compound;
    }
}

