/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.SwordItem;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import untamedwilds.entity.ComplexMobAquatic;
import untamedwilds.init.ModBlock;
import untamedwilds.init.ModTags;

public class ReedBlock
extends Block
implements IGrowable,
IWaterLoggable {
    protected static final VoxelShape SHAPE_NORMAL = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    public static final IntegerProperty PROPERTY_AGE = BlockStateProperties.field_208167_T;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final IntegerProperty PROPERTY_STAGE = BlockStateProperties.field_208137_al;

    public ReedBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(0))).func_206870_a((Property)PROPERTY_STAGE, (Comparable)Integer.valueOf(0))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{PROPERTY_AGE, PROPERTY_STAGE, WATERLOGGED});
    }

    public AbstractBlock.OffsetType func_176218_Q() {
        return AbstractBlock.OffsetType.XZ;
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Vector3d vector3d = state.func_191059_e(worldIn, pos);
        return SHAPE_NORMAL.func_197751_a(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c);
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return true;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }

    @Nullable
    public BlockState getStateForWorldgen(ISeedReader world, BlockPos pos) {
        boolean isWaterLogged = !world.func_204610_c(pos).func_206888_e();
        BlockState blockstate = world.func_180495_p(pos.func_177977_b());
        if (blockstate.func_177230_c() == ModBlock.COMMON_REED.get()) {
            BlockState blockstate1;
            if (world.func_204610_c(pos.func_177977_b()).func_206888_e() || world.func_180495_p(pos.func_177979_c(2)).func_177230_c() == ModBlock.COMMON_REED.get()) {
                world.func_180501_a(pos.func_177977_b(), (BlockState)blockstate.getBlockState().func_206870_a((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(1)), 1);
            }
            return (blockstate1 = world.func_180495_p(pos.func_177984_a())).func_177230_c() != ModBlock.COMMON_REED.get() ? (BlockState)((BlockState)((Block)ModBlock.COMMON_REED.get()).func_176223_P().func_206870_a((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(0))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWaterLogged)) : (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(1))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWaterLogged));
        }
        if (blockstate.func_235714_a_(ModTags.BlockTags.REEDS_PLANTABLE_ON)) {
            return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(isWaterLogged ? 2 : 0))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWaterLogged));
        }
        return null;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        boolean isWaterLogged = !context.func_195991_k().func_204610_c(context.func_195995_a()).func_206888_e();
        BlockState blockstate = context.func_195991_k().func_180495_p(context.func_195995_a().func_177977_b());
        if (blockstate.func_177230_c() == ModBlock.COMMON_REED.get()) {
            BlockState blockstate1;
            if (context.func_195991_k().func_204610_c(context.func_195995_a().func_177977_b()).func_206888_e() || context.func_195991_k().func_180495_p(context.func_195995_a().func_177979_c(2)).func_177230_c() == ModBlock.COMMON_REED.get()) {
                context.func_195991_k().func_175656_a(context.func_195995_a().func_177977_b(), (BlockState)blockstate.getBlockState().func_206870_a((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(1)));
            }
            return (blockstate1 = context.func_195991_k().func_180495_p(context.func_195995_a().func_177984_a())).func_177230_c() != ModBlock.COMMON_REED.get() ? (BlockState)((BlockState)((Block)ModBlock.COMMON_REED.get()).func_176223_P().func_206870_a((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(0))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWaterLogged)) : (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(1))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWaterLogged));
        }
        if (blockstate.func_235714_a_(ModTags.BlockTags.REEDS_PLANTABLE_ON)) {
            return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(isWaterLogged ? 2 : 0))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWaterLogged));
        }
        return null;
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (!state.func_196955_c((IWorldReader)worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
        }
    }

    public boolean func_149653_t(BlockState state) {
        return (Integer)state.func_177229_b((Property)PROPERTY_STAGE) == 0;
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        int i;
        if ((Integer)state.func_177229_b((Property)PROPERTY_STAGE) == 0 && random.nextInt(8) == 0 && worldIn.func_175623_d(pos.func_177984_a()) && worldIn.func_226659_b_(pos.func_177984_a(), 0) >= 9 && (i = this.getNumReedBlocksBelow((IBlockReader)worldIn, pos) + 1) < 4 && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (random.nextInt(3) == 0 ? 1 : 0) != 0)) {
            this.grow(state, (World)worldIn, pos, random, i);
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_235714_a_(ModTags.BlockTags.REEDS_PLANTABLE_ON) || worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == ModBlock.COMMON_REED.get();
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        if (!stateIn.func_196955_c((IWorldReader)worldIn, currentPos)) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        int j;
        int i = this.getNumReedBlocksAbove(worldIn, pos);
        return i + (j = this.getNumReedBlocksBelow(worldIn, pos)) + 1 < 4 && (Integer)worldIn.func_180495_p(pos.func_177981_b(i)).func_177229_b((Property)PROPERTY_STAGE) != 1;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        int i = this.getNumReedBlocksAbove((IBlockReader)worldIn, pos);
        int j = this.getNumReedBlocksBelow((IBlockReader)worldIn, pos);
        int k = i + j + 1;
        int l = 1 + rand.nextInt(2);
        for (int i1 = 0; i1 < l; ++i1) {
            BlockPos blockpos = pos.func_177981_b(i);
            BlockState blockstate = worldIn.func_180495_p(blockpos);
            if (k >= 4 || (Integer)blockstate.func_177229_b((Property)PROPERTY_STAGE) == 1 || !worldIn.func_175623_d(blockpos.func_177984_a())) {
                return;
            }
            this.grow(blockstate, (World)worldIn, blockpos, rand, k);
            ++i;
            ++k;
        }
    }

    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader worldIn, BlockPos pos) {
        return player.func_184614_ca().func_77973_b() instanceof SwordItem ? 1.0f : super.func_180647_a(state, player, worldIn, pos);
    }

    protected void grow(BlockState blockStateIn, World worldIn, BlockPos posIn, Random rand, int p_220258_5_) {
        int j;
        BlockState blockstate = worldIn.func_180495_p(posIn.func_177977_b());
        boolean i = (Integer)blockStateIn.func_177229_b((Property)PROPERTY_AGE) == 1 || blockstate.func_177230_c() == ModBlock.COMMON_REED.get();
        int n = j = !(p_220258_5_ >= 1 && rand.nextFloat() < 0.4f || p_220258_5_ == 4) ? 0 : 1;
        if ((Integer)blockStateIn.func_177229_b((Property)PROPERTY_AGE) != 2) {
            worldIn.func_180501_a(posIn, (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(1))).func_206870_a((Property)PROPERTY_STAGE, (Comparable)Integer.valueOf(j)), 3);
        }
        worldIn.func_180501_a(posIn.func_177984_a(), (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(0))).func_206870_a((Property)PROPERTY_STAGE, (Comparable)Integer.valueOf(j)), 3);
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (!(!(entityIn instanceof LivingEntity) || entityIn instanceof WaterMobEntity || entityIn instanceof ComplexMobAquatic || entityIn.func_70090_H() || entityIn.func_225608_bj_())) {
            entityIn.func_213295_a(state, new Vector3d((double)0.95f, 1.0, (double)0.95f));
            if (worldIn.func_201674_k().nextInt(20) == 0) {
                worldIn.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187579_bV, SoundCategory.AMBIENT, 1.0f, 1.0f, true);
            }
        }
    }

    protected int getNumReedBlocksAbove(IBlockReader worldIn, BlockPos pos) {
        int i;
        for (i = 0; i < 4 && worldIn.func_180495_p(pos.func_177981_b(i + 1)).func_177230_c() == ModBlock.COMMON_REED.get(); ++i) {
        }
        return i;
    }

    protected int getNumReedBlocksBelow(IBlockReader worldIn, BlockPos pos) {
        int i;
        for (i = 0; i < 4 && worldIn.func_180495_p(pos.func_177979_c(i + 1)).func_177230_c() == ModBlock.COMMON_REED.get(); ++i) {
        }
        return i;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }
}

