/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DirectionalPlaceContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import untamedwilds.block.blockentity.CageBlockEntity;
import untamedwilds.init.ModBlock;
import untamedwilds.util.EntityUtils;

public class CageBlock
extends Block
implements IWaterLoggable {
    public static final BooleanProperty OPEN = BlockStateProperties.field_208193_t;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private static final VoxelShape CAGE_COLLISION_AABB_EMPTY = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0);
    private static final VoxelShape CAGE_COLLISION_AABB_FULL = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);

    public CageBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)OPEN, (Comparable)Boolean.FALSE)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{OPEN, WATERLOGGED});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        if (!worldIn.field_72995_K) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof CageBlockEntity) {
                CageBlockEntity te = (CageBlockEntity)tileentity;
                ItemStack itemstack = new ItemStack((IItemProvider)ModBlock.TRAP_CAGE.get());
                CompoundNBT compound = new CompoundNBT();
                if (te.hasTagCompound() && te.hasCagedEntity()) {
                    compound.func_74757_a("closed", te.hasCagedEntity());
                    compound.func_218657_a("EntityTag", (INBT)te.getTagCompound().func_74775_l("EntityTag"));
                    itemstack.func_77982_d(compound);
                }
                CageBlock.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)itemstack);
                worldIn.func_175666_e(pos, state.func_177230_c());
            } else {
                super.func_176208_a(worldIn, pos, state, player);
            }
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return (Boolean)state.func_177229_b((Property)OPEN) != false ? CAGE_COLLISION_AABB_EMPTY : CAGE_COLLISION_AABB_FULL;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return (Boolean)state.func_177229_b((Property)OPEN);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState blockstate = this.func_176223_P();
        FluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)((BlockState)blockstate.func_206870_a((Property)OPEN, (Comparable)Boolean.TRUE)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (stack.func_77942_o()) {
            TileEntity te = worldIn.func_175625_s(pos);
            if (stack.func_77978_p() != null && te != null) {
                te.func_230337_a_(state, stack.func_77978_p());
                CageBlockEntity tileentity = (CageBlockEntity)worldIn.func_175625_s(pos);
                if (tileentity.hasCagedEntity() && tileentity.hasTagCompound()) {
                    worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)OPEN, (Comparable)Boolean.FALSE));
                }
            }
        }
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!worldIn.field_72995_K && worldIn.func_175640_z(pos)) {
            this.trySpawningEntity(state, (ServerWorld)worldIn, pos);
        }
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult hit) {
        if (playerIn.func_225608_bj_() || worldIn.field_72995_K || ((Boolean)state.func_177229_b((Property)OPEN)).booleanValue()) {
            return ActionResultType.FAIL;
        }
        boolean success = this.trySpawningEntity(state, (ServerWorld)worldIn, pos);
        return success ? ActionResultType.SUCCESS : ActionResultType.FAIL;
    }

    private boolean trySpawningEntity(BlockState state, ServerWorld worldIn, BlockPos pos) {
        CageBlockEntity te = (CageBlockEntity)worldIn.func_175625_s(pos);
        BlockPos check = pos.func_177977_b();
        if (te != null) {
            BlockPos spawnpos;
            BlockPos blockPos = spawnpos = !worldIn.func_180495_p(check).func_200132_m() ? pos : new BlockPos((double)pos.func_177958_n(), (double)((float)pos.func_177956_o() + 1.0f), (double)pos.func_177952_p());
            if (te.spawnCagedCreature(worldIn, spawnpos, worldIn.func_175623_d(check))) {
                this.spawnParticles((World)worldIn, pos, ParticleTypes.field_197598_I);
                worldIn.func_184133_a(null, pos, SoundEvents.field_187895_gX, SoundCategory.BLOCKS, 0.3f, 0.8f);
                worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)OPEN, (Comparable)Boolean.TRUE));
                return true;
            }
            this.spawnParticles((World)worldIn, pos, ParticleTypes.field_197601_L);
            worldIn.func_184133_a(null, pos, SoundEvents.field_187893_gW, SoundCategory.BLOCKS, 0.3f, 0.6f);
        }
        return false;
    }

    private <T extends IParticleData> void spawnParticles(World worldIn, BlockPos pos, T particle) {
        Random random = worldIn.field_73012_v;
        float d3 = random.nextFloat() * 0.02f;
        float d1 = random.nextFloat() * 0.02f;
        float d2 = random.nextFloat() * 0.02f;
        ((ServerWorld)worldIn).func_195598_a(particle, (double)((float)pos.func_177958_n() + random.nextFloat()), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + random.nextFloat()), 15, (double)d3, (double)d1, (double)d2, (double)0.12f);
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        CageBlockEntity te = (CageBlockEntity)world.func_175625_s(pos);
        if (!world.field_72995_K && !(entity instanceof PlayerEntity) && entity.func_70089_S() && entity.func_184222_aU() && entity instanceof LivingEntity && te != null && !te.hasCagedEntity() && entity instanceof MobEntity && te.cageEntity((MobEntity)entity)) {
            world.func_184133_a(null, pos, SoundEvents.field_187895_gX, SoundCategory.BLOCKS, 0.3f, 0.8f);
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)OPEN, (Comparable)Boolean.FALSE));
            this.spawnParticles(world, pos, ParticleTypes.field_197598_I);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77978_p() != null) {
            EntityType<?> type = EntityUtils.getEntityTypeFromTag(stack.func_77978_p(), null);
            if (type != null) {
                EntityUtils.buildTooltipData(stack, tooltip, type, EntityUtils.getVariantName(type, stack.func_77978_p().func_74762_e("Variant")));
            }
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("block.trap_cage.state_empty").func_240699_a_(TextFormatting.GRAY));
        }
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader worldIn) {
        return new CageBlockEntity();
    }

    public static class DispenserBehaviorTrapCage
    extends DefaultDispenseItemBehavior
    implements IDispenseItemBehavior {
        public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            Item item = stack.func_77973_b();
            if (item instanceof BlockItem) {
                Direction direction = (Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a);
                BlockPos blockpos = source.func_180699_d().func_177972_a(direction);
                Direction direction1 = source.func_197524_h().func_175623_d(blockpos.func_177977_b()) ? direction : Direction.UP;
                boolean bl = ((BlockItem)item).func_195942_a((BlockItemUseContext)new DirectionalPlaceContext((World)source.func_197524_h(), blockpos, direction, stack, direction1)) == ActionResultType.SUCCESS;
            }
            return stack;
        }

        protected void func_82485_a(IBlockSource source) {
            source.func_197524_h().func_217379_c(1000, source.func_180699_d(), 0);
        }
    }
}

