/*
 * Decompiled with CFR 0.152.
 */
package com.teamremastered.endrem.world.structures.config;

import com.teamremastered.endrem.config.ERConfig;
import com.teamremastered.endrem.mixin.world.ChunkGeneratorAccessorMixin;
import com.teamremastered.endrem.world.structures.AncientWitchHut;
import com.teamremastered.endrem.world.structures.EndCastle;
import com.teamremastered.endrem.world.structures.EndGate;
import com.teamremastered.endrem.world.structures.config.ERConfiguredStructures;
import com.teamremastered.endrem.world.structures.config.ERStructures;
import java.util.HashMap;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.World;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class StructureGenerator {
    public static void init() {
        ERStructures.STRUCTURES.register(FMLJavaModLoadingContext.get().getModEventBus());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(StructureGenerator::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(StructureGenerator::complete);
        MinecraftForge.EVENT_BUS.addListener(StructureGenerator::biomeModification);
        MinecraftForge.EVENT_BUS.addListener(StructureGenerator::addDimensionalSpacing);
        if (!ERConfig.MONSTER_DIFFICULTY.getRaw().equals("peaceful")) {
            MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, EndGate::setupStructureSpawns);
            MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, EndCastle::setupStructureSpawns);
            MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, AncientWitchHut::setupStructureSpawns);
        }
    }

    public static void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ERStructures.setupStructures();
            ERStructures.registerAllPieces();
            ERConfiguredStructures.registerConfiguredStructures();
        });
    }

    public static void complete(FMLLoadCompleteEvent event) {
        event.enqueueWork(() -> {
            StructureGenerator.register((RegistryKey<DimensionSettings>)DimensionSettings.field_242734_c, (Structure)ERStructures.END_CASTLE.get(), new StructureSeparationSettings(ERConfig.END_CASTLE_DISTANCE.getRaw().intValue(), ERConfig.END_CASTLE_DISTANCE.getRaw() - 30, 487192276));
            StructureGenerator.register((RegistryKey<DimensionSettings>)DimensionSettings.field_242734_c, (Structure)ERStructures.END_GATE.get(), new StructureSeparationSettings(ERConfig.END_GATE_DISTANCE.getRaw().intValue(), ERConfig.END_GATE_DISTANCE.getRaw() - 30, 959834864));
            StructureGenerator.register((RegistryKey<DimensionSettings>)DimensionSettings.field_242734_c, (Structure)ERStructures.ANCIENT_WITCH_HUT.get(), new StructureSeparationSettings(ERConfig.ANCIENT_WITCH_HUT_DISTANCE.getRaw().intValue(), ERConfig.ANCIENT_WITCH_HUT_DISTANCE.getRaw() - 5, 324897233));
        });
    }

    public static void register(RegistryKey<DimensionSettings> dimension, Structure<?> structure, StructureSeparationSettings separationSettings) {
        WorldGenRegistries.field_243658_j.func_243575_c(dimension).ifPresent(dimensionSettings -> {
            DimensionStructuresSettings structuresSettings = dimensionSettings.func_236108_a_();
            structuresSettings.field_236193_d_.put(structure, separationSettings);
        });
    }

    public static void biomeModification(BiomeLoadingEvent event) {
        BiomeGenerationSettingsBuilder generation = event.getGeneration();
        if (ERConfig.END_CASTLE_DISTANCE.getRaw() > 0 && EndCastle.getValidBiomeCategories().contains(event.getCategory()) && !ERConfig.END_CASTLE_BLACKLISTED_BIOMES.getList().contains(event.getName().toString())) {
            generation.getStructures().add(() -> ERConfiguredStructures.CONFIGURED_END_CASTLE);
        }
        if (ERConfig.END_GATE_DISTANCE.getRaw() > 0 && EndGate.getValidBiomeCategories().contains(event.getCategory()) && !ERConfig.END_GATE_BLACKLISTED_BIOMES.getList().contains(event.getName().toString())) {
            generation.getStructures().add(() -> ERConfiguredStructures.CONFIGURED_END_GATE);
        }
        if (ERConfig.ANCIENT_WITCH_HUT_DISTANCE.getRaw() > 0 && AncientWitchHut.getValidBiomeCategories().contains(event.getCategory())) {
            generation.getStructures().add(() -> ERConfiguredStructures.CONFIGURED_ANCIENT_WITCH_HUT);
        }
    }

    public static void addDimensionalSpacing(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)event.getWorld();
            ResourceLocation cgRL = Registry.field_239690_aB_.func_177774_c(((ChunkGeneratorAccessorMixin)serverWorld.func_72863_F().field_186029_c).endrem_getCodec());
            if (cgRL != null && cgRL.func_110624_b().equals("terraforged")) {
                return;
            }
            HashMap<IForgeRegistryEntry, Object> tempMap = new HashMap<IForgeRegistryEntry, Object>(serverWorld.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
            if (serverWorld.func_72863_F().func_201711_g() instanceof FlatChunkGenerator && serverWorld.func_234923_W_().equals(World.field_234918_g_)) {
                tempMap.keySet().remove(ERStructures.END_CASTLE.get());
                tempMap.keySet().remove(ERStructures.END_GATE.get());
                tempMap.keySet().remove(ERStructures.ANCIENT_WITCH_HUT.get());
            } else if (!ERConfig.WHITELISTED_DIMENSIONS.getList().contains(serverWorld.func_234923_W_().func_240901_a_().toString())) {
                tempMap.keySet().remove(ERStructures.END_CASTLE.get());
                tempMap.keySet().remove(ERStructures.END_GATE.get());
                tempMap.keySet().remove(ERStructures.ANCIENT_WITCH_HUT.get());
            } else {
                tempMap.putIfAbsent(ERStructures.END_CASTLE.get(), DimensionStructuresSettings.field_236191_b_.get((Object)ERStructures.END_CASTLE.get()));
                tempMap.putIfAbsent(ERStructures.END_GATE.get(), DimensionStructuresSettings.field_236191_b_.get((Object)ERStructures.END_GATE.get()));
                tempMap.putIfAbsent(ERStructures.ANCIENT_WITCH_HUT.get(), DimensionStructuresSettings.field_236191_b_.get((Object)ERStructures.ANCIENT_WITCH_HUT.get()));
            }
            serverWorld.func_72863_F().field_186029_c.func_235957_b_().field_236193_d_ = tempMap;
        }
    }
}

