/*
 * Decompiled with CFR 0.152.
 */
package com.teamremastered.endrem.world.structures.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import com.teamremastered.endrem.config.ERConfig;
import com.teamremastered.endrem.world.structures.AncientWitchHut;
import com.teamremastered.endrem.world.structures.EndCastle;
import com.teamremastered.endrem.world.structures.EndCastlePieces;
import com.teamremastered.endrem.world.structures.EndGate;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ERStructures {
    public static final DeferredRegister<Structure<?>> STRUCTURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"endrem");
    public static final RegistryObject<Structure<NoFeatureConfig>> END_GATE = ERStructures.registerStructure("end_gate", () -> new EndGate((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> ANCIENT_WITCH_HUT = ERStructures.registerStructure("ancient_witch_hut", () -> new AncientWitchHut((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> END_CASTLE = ERStructures.registerStructure("end_castle", () -> new EndCastle((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static IStructurePieceType EC = EndCastlePieces.Piece::new;

    private static <T extends Structure<?>> RegistryObject<T> registerStructure(String name, Supplier<T> structure) {
        return STRUCTURES.register(name, structure);
    }

    public static void setupStructures() {
        ERStructures.setupMapSpacingAndLand((Structure)END_CASTLE.get(), new StructureSeparationSettings(ERConfig.END_CASTLE_DISTANCE.getRaw().intValue(), ERConfig.END_CASTLE_DISTANCE.getRaw() - 30, 487192276), ERConfig.END_CASTLE_TERRAFORMING.getRaw());
        ERStructures.setupMapSpacingAndLand((Structure)END_GATE.get(), new StructureSeparationSettings(ERConfig.END_GATE_DISTANCE.getRaw().intValue(), ERConfig.END_GATE_DISTANCE.getRaw() - 30, 959834864), false);
        ERStructures.setupMapSpacingAndLand((Structure)ANCIENT_WITCH_HUT.get(), new StructureSeparationSettings(ERConfig.ANCIENT_WITCH_HUT_DISTANCE.getRaw().intValue(), ERConfig.ANCIENT_WITCH_HUT_DISTANCE.getRaw() - 5, 324897233), false);
    }

    public static <F extends Structure<?>> void setupMapSpacingAndLand(F structure, StructureSeparationSettings structureFeatureConfiguration, boolean transformSurroundingLand) {
        Structure.field_236365_a_.put((Object)structure.getRegistryName().toString(), structure);
        if (transformSurroundingLand) {
            Structure.field_236384_t_ = ImmutableList.builder().addAll((Iterable)Structure.field_236384_t_).add(structure).build();
        }
        DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put(structure, (Object)structureFeatureConfiguration).build();
    }

    static void registerStructurePiece(IStructurePieceType structurePiece, ResourceLocation rl) {
        Registry.func_218322_a((Registry)Registry.field_218362_C, (ResourceLocation)rl, (Object)structurePiece);
    }

    public static void registerAllPieces() {
        ERStructures.registerStructurePiece(EC, new ResourceLocation("endrem", "ec"));
    }
}

